/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.redis.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.core.observation.CompositeObservation;
import org.eclipse.leshan.core.observation.Observation;
import org.eclipse.leshan.core.observation.ObservationIdentifier;
import org.eclipse.leshan.core.observation.SingleObservation;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.util.Hex;

public class ObservationSerDes {
    private static final String OBS_ID = "id";
    private static final String OBS_REGID = "regid";
    private static final String OBS_USER_CONTEXT = "userContext";
    private static final String OBS_PROTOCOL_DATA = "protocolData";
    private static final String OBS_KIND = "kind";
    private static final String SOBS_CONTENT_FORMAT = "ct";
    private static final String SOBS_PATH = "path";
    private static final String COBS_RESP_CONTENT_FORMAT = "resCt";
    private static final String COBS_REQ_CONTENT_FORMAT = "reqCt";
    private static final String COBS_PATHS = "paths";
    private static final String KIND_SINGLE = "single";
    private static final String KIND_COMPOSITE = "composite";

    public byte[] serialize(Observation obs) {
        ObjectNode n = JsonNodeFactory.instance.objectNode();
        n.put(OBS_ID, obs.getId().getAsHexString());
        n.put(OBS_REGID, obs.getRegistrationId());
        ObjectNode userContext = JsonNodeFactory.instance.objectNode();
        for (Map.Entry entry : obs.getContext().entrySet()) {
            userContext.put((String)entry.getKey(), (String)entry.getValue());
        }
        n.set(OBS_USER_CONTEXT, (JsonNode)userContext);
        ObjectNode protocolData = JsonNodeFactory.instance.objectNode();
        for (Map.Entry entry : obs.getProtocolData().entrySet()) {
            protocolData.put((String)entry.getKey(), (String)entry.getValue());
        }
        n.set(OBS_PROTOCOL_DATA, (JsonNode)protocolData);
        if (obs instanceof SingleObservation) {
            SingleObservation singleObservation = (SingleObservation)obs;
            n.put(OBS_KIND, KIND_SINGLE);
            if (singleObservation.getContentFormat() != null) {
                n.put(SOBS_CONTENT_FORMAT, singleObservation.getContentFormat().getCode());
            }
            n.put(SOBS_PATH, singleObservation.getPath().toString());
        } else if (obs instanceof CompositeObservation) {
            CompositeObservation compositeObservation = (CompositeObservation)obs;
            n.put(OBS_KIND, KIND_COMPOSITE);
            if (compositeObservation.getRequestContentFormat() != null) {
                n.put(COBS_REQ_CONTENT_FORMAT, compositeObservation.getRequestContentFormat().getCode());
            }
            if (compositeObservation.getResponseContentFormat() != null) {
                n.put(COBS_RESP_CONTENT_FORMAT, compositeObservation.getResponseContentFormat().getCode());
            }
            ArrayNode arrayNode = JsonNodeFactory.instance.arrayNode();
            for (LwM2mPath path : compositeObservation.getPaths()) {
                arrayNode.add(path.toString());
            }
            n.set(COBS_PATHS, (JsonNode)arrayNode);
        } else {
            throw new IllegalArgumentException(String.format("Unsupported kind of Observation : %s", obs));
        }
        return n.toString().getBytes();
    }

    public Observation deserialize(byte[] data) {
        String json = new String(data);
        try {
            JsonNode n = new ObjectMapper().readTree(json);
            String id = n.get(OBS_ID).asText();
            ObservationIdentifier obsId = new ObservationIdentifier(Hex.decodeHex((char[])id.toCharArray()));
            String regid = n.get(OBS_REGID).asText();
            String kind = n.get(OBS_KIND).asText();
            HashMap<String, String> context = null;
            ObjectNode jUserContext = (ObjectNode)n.get(OBS_USER_CONTEXT);
            if (jUserContext != null) {
                context = new HashMap<String, String>();
                Iterator it = jUserContext.fieldNames();
                while (it.hasNext()) {
                    String k = (String)it.next();
                    context.put(k, jUserContext.get(k).asText());
                }
            }
            HashMap<String, String> protocolData = null;
            ObjectNode jProtocolData = (ObjectNode)n.get(OBS_PROTOCOL_DATA);
            if (jProtocolData != null) {
                protocolData = new HashMap<String, String>();
                Iterator it = jProtocolData.fieldNames();
                while (it.hasNext()) {
                    String k = (String)it.next();
                    protocolData.put(k, jProtocolData.get(k).asText());
                }
            }
            if (KIND_SINGLE.equals(kind)) {
                ContentFormat contentFormat = null;
                if (n.has(SOBS_CONTENT_FORMAT)) {
                    contentFormat = ContentFormat.fromCode((int)n.get(SOBS_CONTENT_FORMAT).asInt());
                }
                LwM2mPath path = new LwM2mPath(n.get(SOBS_PATH).asText());
                return new SingleObservation(obsId, regid, path, contentFormat, context, protocolData);
            }
            if (KIND_COMPOSITE.equals(kind)) {
                ContentFormat reqContentFormat = null;
                if (n.has(COBS_REQ_CONTENT_FORMAT)) {
                    reqContentFormat = ContentFormat.fromCode((int)n.get(COBS_REQ_CONTENT_FORMAT).asInt());
                }
                ContentFormat respcontentFormat = null;
                if (n.has(COBS_RESP_CONTENT_FORMAT)) {
                    respcontentFormat = ContentFormat.fromCode((int)n.get(COBS_RESP_CONTENT_FORMAT).asInt());
                }
                ArrayList<LwM2mPath> paths = null;
                ArrayNode jPaths = (ArrayNode)n.get(COBS_PATHS);
                if (jPaths != null) {
                    paths = new ArrayList<LwM2mPath>();
                    for (JsonNode jPath : jPaths) {
                        paths.add(new LwM2mPath(jPath.asText()));
                    }
                }
                return new CompositeObservation(obsId, regid, paths, reqContentFormat, respcontentFormat, context, protocolData);
            }
            throw new IllegalArgumentException(String.format("Unsupported kind of Observation : %s in %s", kind, json));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(String.format("Unable to deserialize Observation %s", json), e);
        }
    }
}

