/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.redis.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import org.eclipse.leshan.core.util.Hex;
import org.eclipse.leshan.server.security.SecurityInfo;

public class SecurityInfoSerDes {
    public static byte[] serialize(SecurityInfo s) {
        ObjectNode o = JsonNodeFactory.instance.objectNode();
        o.put("ep", s.getEndpoint());
        if (s.getPskIdentity() != null) {
            o.put("id", s.getPskIdentity());
        }
        if (s.getPreSharedKey() != null) {
            o.put("psk", Hex.encodeHexString((byte[])s.getPreSharedKey()));
        }
        if (s.getRawPublicKey() != null) {
            ObjectNode rpk = JsonNodeFactory.instance.objectNode();
            ECPublicKey ecPublicKey = (ECPublicKey)s.getRawPublicKey();
            byte[] x = ecPublicKey.getW().getAffineX().toByteArray();
            if (x[0] == 0) {
                x = Arrays.copyOfRange(x, 1, x.length);
            }
            rpk.put("x", Hex.encodeHexString((byte[])x));
            byte[] y = ecPublicKey.getW().getAffineY().toByteArray();
            if (y[0] == 0) {
                y = Arrays.copyOfRange(y, 1, y.length);
            }
            rpk.put("y", Hex.encodeHexString((byte[])y));
            ecPublicKey.getParams();
            rpk.put("params", ecPublicKey.getParams().toString().split(" ")[0]);
            o.set("rpk", (JsonNode)rpk);
        }
        if (s.useX509Cert()) {
            o.put("x509", true);
        }
        return o.toString().getBytes();
    }

    public static SecurityInfo deserialize(byte[] data) {
        SecurityInfo i;
        try {
            JsonNode o = new ObjectMapper().readTree(new String(data));
            String ep = o.get("ep").asText();
            if (o.get("psk") != null) {
                i = SecurityInfo.newPreSharedKeyInfo((String)ep, (String)o.get("id").asText(), (byte[])Hex.decodeHex((char[])o.get("psk").asText().toCharArray()));
            } else if (o.get("x509") != null) {
                i = SecurityInfo.newX509CertInfo((String)ep);
            } else {
                JsonNode rpk = o.get("rpk");
                byte[] x = Hex.decodeHex((char[])rpk.get("x").asText().toCharArray());
                byte[] y = Hex.decodeHex((char[])rpk.get("y").asText().toCharArray());
                String params = rpk.get("params").asText();
                AlgorithmParameters algoParameters = AlgorithmParameters.getInstance("EC");
                algoParameters.init(new ECGenParameterSpec(params));
                ECParameterSpec parameterSpec = algoParameters.getParameterSpec(ECParameterSpec.class);
                ECPublicKeySpec keySpec = new ECPublicKeySpec(new ECPoint(new BigInteger(1, x), new BigInteger(1, y)), parameterSpec);
                PublicKey key = KeyFactory.getInstance("EC").generatePublic(keySpec);
                i = SecurityInfo.newRawPublicKeyInfo((String)ep, (PublicKey)key);
            }
        }
        catch (JsonProcessingException | IllegalArgumentException | NoSuchAlgorithmException | InvalidKeySpecException | InvalidParameterSpecException e) {
            throw new IllegalStateException("Invalid security info content", e);
        }
        return i;
    }
}

