/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.redis;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.leshan.server.redis.serialization.SecurityInfoSerDes;
import org.eclipse.leshan.server.security.EditableSecurityStore;
import org.eclipse.leshan.server.security.NonUniqueSecurityInfoException;
import org.eclipse.leshan.server.security.SecurityInfo;
import org.eclipse.leshan.server.security.SecurityStoreListener;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.util.Pool;

public class RedisSecurityStore
implements EditableSecurityStore {
    private static final String SEC_EP = "SEC#EP#";
    private static final String PSKID_SEC = "PSKID#SEC";
    private final Pool<Jedis> pool;
    private SecurityStoreListener listener;

    public RedisSecurityStore(Pool<Jedis> pool) {
        this.pool = pool;
    }

    public SecurityInfo getByEndpoint(String endpoint) {
        try (Jedis j = (Jedis)this.pool.getResource();){
            byte[] data = j.get((SEC_EP + endpoint).getBytes());
            if (data == null) {
                SecurityInfo securityInfo = null;
                return securityInfo;
            }
            SecurityInfo securityInfo = this.deserialize(data);
            return securityInfo;
        }
    }

    public SecurityInfo getByIdentity(String identity) {
        try (Jedis j = (Jedis)this.pool.getResource();){
            String ep = j.hget(PSKID_SEC, identity);
            if (ep == null) {
                SecurityInfo securityInfo = null;
                return securityInfo;
            }
            byte[] data = j.get((SEC_EP + ep).getBytes());
            if (data == null) {
                SecurityInfo securityInfo = null;
                return securityInfo;
            }
            SecurityInfo securityInfo = this.deserialize(data);
            return securityInfo;
        }
    }

    public Collection<SecurityInfo> getAll() {
        try (Jedis j = (Jedis)this.pool.getResource();){
            ScanResult res;
            ScanParams params = new ScanParams().match("SEC#EP#*").count(Integer.valueOf(100));
            LinkedList<SecurityInfo> list = new LinkedList<SecurityInfo>();
            String cursor = "0";
            do {
                res = j.scan(cursor.getBytes(), params);
                for (byte[] key : res.getResult()) {
                    byte[] element = j.get(key);
                    list.add(this.deserialize(element));
                }
            } while (!"0".equals(cursor = res.getCursor()));
            LinkedList<SecurityInfo> linkedList = list;
            return linkedList;
        }
    }

    public SecurityInfo add(SecurityInfo info) throws NonUniqueSecurityInfoException {
        byte[] data = this.serialize(info);
        try (Jedis j = (Jedis)this.pool.getResource();){
            String previousIdentity;
            byte[] previousData;
            if (info.getIdentity() != null) {
                String oldEndpoint = j.hget(PSKID_SEC, info.getIdentity());
                if (oldEndpoint != null && !oldEndpoint.equals(info.getEndpoint())) {
                    throw new NonUniqueSecurityInfoException("PSK Identity " + info.getIdentity() + " is already used");
                }
                j.hset(PSKID_SEC.getBytes(), info.getIdentity().getBytes(), info.getEndpoint().getBytes());
            }
            SecurityInfo previous = (previousData = j.getSet((SEC_EP + info.getEndpoint()).getBytes(), data)) == null ? null : this.deserialize(previousData);
            String string = previousIdentity = previous == null ? null : previous.getIdentity();
            if (previousIdentity != null && !previousIdentity.equals(info.getIdentity())) {
                j.hdel(PSKID_SEC, new String[]{previousIdentity});
            }
            SecurityInfo securityInfo = previous;
            return securityInfo;
        }
    }

    public SecurityInfo remove(String endpoint, boolean infosAreCompromised) {
        try (Jedis j = (Jedis)this.pool.getResource();){
            byte[] data = j.get((SEC_EP + endpoint).getBytes());
            if (data != null) {
                SecurityInfo info = this.deserialize(data);
                if (info.getIdentity() != null) {
                    j.hdel(PSKID_SEC.getBytes(), (byte[][])new byte[][]{info.getIdentity().getBytes()});
                }
                j.del((SEC_EP + endpoint).getBytes());
                if (this.listener != null) {
                    this.listener.securityInfoRemoved(infosAreCompromised, new SecurityInfo[]{info});
                }
                SecurityInfo securityInfo = info;
                return securityInfo;
            }
        }
        return null;
    }

    private byte[] serialize(SecurityInfo secInfo) {
        return SecurityInfoSerDes.serialize(secInfo);
    }

    private SecurityInfo deserialize(byte[] data) {
        return SecurityInfoSerDes.deserialize(data);
    }

    public void setListener(SecurityStoreListener listener) {
        this.listener = listener;
    }
}

