/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.redis.serialization;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.InetSocketAddress;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.elements.AddressEndpointContext;
import org.eclipse.californium.elements.Definition;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.MapBasedEndpointContext;
import org.eclipse.californium.elements.auth.PreSharedKeyIdentity;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.eclipse.californium.elements.auth.X509CertPath;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.leshan.core.util.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointContextSerDes {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointContextSerDes.class);
    private static final String KEY_ADDRESS = "address";
    private static final String KEY_PORT = "port";
    private static final String KEY_ID = "id";
    private static final String KEY_DN = "dn";
    private static final String KEY_RPK = "rpk";
    private static final String KEY_ATTRIBUTES = "attributes";

    public static JsonObject serialize(EndpointContext context) {
        Map attributes;
        JsonObject peer = Json.object();
        EndpointContextSerDes.addAddress(peer, context.getPeerAddress());
        Principal principal = context.getPeerIdentity();
        if (principal != null) {
            if (principal instanceof PreSharedKeyIdentity) {
                peer.set(KEY_ID, ((PreSharedKeyIdentity)principal).getIdentity());
            } else if (principal instanceof RawPublicKeyIdentity) {
                PublicKey publicKey = ((RawPublicKeyIdentity)principal).getKey();
                peer.set(KEY_RPK, Hex.encodeHexString((byte[])publicKey.getEncoded()));
            } else if (principal instanceof X500Principal || principal instanceof X509CertPath) {
                peer.set(KEY_DN, principal.getName());
            }
        }
        if (!(attributes = context.entries()).isEmpty()) {
            JsonObject attContext = Json.object();
            for (Definition key : attributes.keySet()) {
                Object value = attributes.get(key);
                if (value instanceof InetSocketAddress) {
                    JsonObject address = Json.object();
                    EndpointContextSerDes.addAddress(address, (InetSocketAddress)value);
                    attContext.set(key.getKey(), (JsonValue)address);
                    continue;
                }
                if (value instanceof Bytes) {
                    value = ((Bytes)value).getAsString();
                }
                attContext.set(key.getKey(), value.toString());
            }
            peer.set(KEY_ATTRIBUTES, (JsonValue)attContext);
        }
        return peer;
    }

    public static EndpointContext deserialize(JsonObject peer) {
        AddressEndpointContext endpointContext;
        InetSocketAddress socketAddress = EndpointContextSerDes.getAddress(peer);
        Object principal = null;
        JsonValue value = peer.get(KEY_ID);
        if (value != null) {
            principal = new PreSharedKeyIdentity(value.asString());
        } else {
            value = peer.get(KEY_RPK);
            if (value != null) {
                try {
                    byte[] rpk = Hex.decodeHex((char[])value.asString().toCharArray());
                    X509EncodedKeySpec spec = new X509EncodedKeySpec(rpk);
                    PublicKey publicKey = KeyFactory.getInstance("EC").generatePublic(spec);
                    principal = new RawPublicKeyIdentity(publicKey);
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                    throw new IllegalStateException("Invalid security info content", e);
                }
            } else {
                value = peer.get(KEY_DN);
                if (value != null) {
                    principal = new X500Principal(value.asString());
                }
            }
        }
        value = peer.get(KEY_ATTRIBUTES);
        if (value == null) {
            endpointContext = new AddressEndpointContext(socketAddress, (Principal)principal);
        } else {
            MapBasedEndpointContext.Attributes attributes = new MapBasedEndpointContext.Attributes();
            for (JsonObject.Member member : value.asObject()) {
                String name = member.getName();
                Definition key = MapBasedEndpointContext.ATTRIBUTE_DEFINITIONS.get(name);
                if (key != null) {
                    if (key.getValueType().equals(InetSocketAddress.class)) {
                        InetSocketAddress address = EndpointContextSerDes.getAddress(member.getValue().asObject());
                        attributes.add(key, (Object)address);
                        continue;
                    }
                    String attributeValue = member.getValue().asString();
                    if (key.getValueType().equals(String.class)) {
                        attributes.add(key, (Object)attributeValue);
                        continue;
                    }
                    if (key.getValueType().equals(Bytes.class)) {
                        attributes.add(key, (Object)new Bytes(StringUtil.hex2ByteArray((String)attributeValue)));
                        continue;
                    }
                    if (key.getValueType().equals(Integer.class)) {
                        attributes.add(key, (Object)Integer.parseInt(attributeValue));
                        continue;
                    }
                    if (key.getValueType().equals(Long.class)) {
                        attributes.add(key, (Object)Long.parseLong(attributeValue));
                        continue;
                    }
                    if (key.getValueType().equals(Boolean.class)) {
                        attributes.add(key, (Object)Boolean.parseBoolean(attributeValue));
                        continue;
                    }
                    LOG.warn("Unsupported type" + key.getValueType() + " for endpoint-context-attribute '{}'.", (Object)name);
                    continue;
                }
                LOG.warn("missing definition for endpoint-context-attribute '{}'.", (Object)name);
            }
            endpointContext = new MapBasedEndpointContext(socketAddress, (Principal)principal, attributes);
        }
        return endpointContext;
    }

    private static void addAddress(JsonObject object, InetSocketAddress address) {
        object.set(KEY_ADDRESS, address.getHostString());
        object.set(KEY_PORT, address.getPort());
    }

    private static InetSocketAddress getAddress(JsonObject object) {
        String address = object.get(KEY_ADDRESS).asString();
        int port = object.get(KEY_PORT).asInt();
        return new InetSocketAddress(address, port);
    }
}

