/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.redis.serialization;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.leshan.core.LwM2m;
import org.eclipse.leshan.core.link.Link;
import org.eclipse.leshan.core.link.LinkParamValue;
import org.eclipse.leshan.core.request.BindingMode;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.server.redis.serialization.IdentitySerDes;
import org.eclipse.leshan.server.registration.Registration;

public class RegistrationSerDes {
    public static JsonObject jSerialize(Registration r) {
        JsonObject o = Json.object();
        o.add("regDate", r.getRegistrationDate().getTime());
        o.add("identity", (JsonValue)IdentitySerDes.serialize(r.getIdentity()));
        o.add("lt", r.getLifeTimeInSec().longValue());
        if (r.getSmsNumber() != null) {
            o.add("sms", r.getSmsNumber());
        }
        o.add("ver", r.getLwM2mVersion().toString());
        o.add("bnd", BindingMode.toString((EnumSet)r.getBindingMode()));
        if (r.getQueueMode() != null) {
            o.add("qm", r.getQueueMode().booleanValue());
        }
        o.add("ep", r.getEndpoint());
        o.add("regId", r.getId());
        JsonArray links = new JsonArray();
        for (Link l : r.getObjectLinks()) {
            JsonObject ol = Json.object();
            ol.add("url", l.getUriReference());
            JsonObject at = Json.object();
            for (Map.Entry e : l.getLinkParams().entrySet()) {
                if (e.getValue() == null) {
                    at.add((String)e.getKey(), Json.NULL);
                    continue;
                }
                at.add((String)e.getKey(), ((LinkParamValue)e.getValue()).toString());
            }
            ol.add("at", (JsonValue)at);
            links.add((JsonValue)ol);
        }
        o.add("objLink", (JsonValue)links);
        JsonObject addAttr = Json.object();
        for (Map.Entry e : r.getAdditionalRegistrationAttributes().entrySet()) {
            addAttr.add((String)e.getKey(), (String)e.getValue());
        }
        o.add("addAttr", (JsonValue)addAttr);
        o.add("root", r.getRootPath());
        o.add("lastUp", r.getLastUpdate().getTime());
        Set supportedContentFormat = r.getSupportedContentFormats();
        JsonArray ct = Json.array();
        for (ContentFormat contentFormat : supportedContentFormat) {
            ct.add(contentFormat.getCode());
        }
        o.add("ct", (JsonValue)ct);
        JsonObject so = Json.object();
        for (Map.Entry supportedObject : r.getSupportedObject().entrySet()) {
            so.add(((Integer)supportedObject.getKey()).toString(), (String)supportedObject.getValue());
        }
        o.add("suppObjs", (JsonValue)so);
        JsonObject ad = Json.object();
        for (Map.Entry appData : r.getApplicationData().entrySet()) {
            ad.add((String)appData.getKey(), (String)appData.getValue());
        }
        o.add("appdata", (JsonValue)ad);
        return o;
    }

    public static String sSerialize(Registration r) {
        return RegistrationSerDes.jSerialize(r).toString();
    }

    public static byte[] bSerialize(Registration r) {
        return RegistrationSerDes.jSerialize(r).toString().getBytes();
    }

    public static Registration deserialize(JsonObject jObj) {
        Registration.Builder b = new Registration.Builder(jObj.getString("regId", null), jObj.getString("ep", null), IdentitySerDes.deserialize(jObj.get("identity").asObject()));
        b.bindingMode(BindingMode.parse((String)jObj.getString("bnd", null)));
        if (jObj.get("qm") != null) {
            b.queueMode(Boolean.valueOf(jObj.getBoolean("qm", false)));
        }
        b.lastUpdate(new Date(jObj.getLong("lastUp", 0L)));
        b.lifeTimeInSec(Long.valueOf(jObj.getLong("lt", 0L)));
        String versionAsString = jObj.getString("ver", null);
        if (versionAsString == null) {
            b.lwM2mVersion(LwM2m.LwM2mVersion.getDefault());
        } else {
            b.lwM2mVersion(LwM2m.LwM2mVersion.get((String)versionAsString));
        }
        b.registrationDate(new Date(jObj.getLong("regDate", 0L)));
        if (jObj.get("sms") != null) {
            b.smsNumber(jObj.getString("sms", ""));
        }
        b.rootPath(jObj.getString("root", "/"));
        JsonArray links = (JsonArray)jObj.get("objLink");
        Link[] linkObjs = new Link[links.size()];
        for (int i = 0; i < links.size(); ++i) {
            Link o;
            JsonObject ol = (JsonObject)links.get(i);
            HashMap<String, LinkParamValue> attMap = new HashMap<String, LinkParamValue>();
            JsonObject att = (JsonObject)ol.get("at");
            for (String k : att.names()) {
                JsonValue jsonValue = att.get(k);
                if (jsonValue.isNull()) {
                    attMap.put(k, null);
                    continue;
                }
                if (jsonValue.isNumber()) {
                    attMap.put(k, new LinkParamValue(Integer.toString(jsonValue.asInt())));
                    continue;
                }
                attMap.put(k, new LinkParamValue(jsonValue.asString()));
            }
            linkObjs[i] = o = new Link(ol.getString("url", null), attMap);
        }
        b.objectLinks(linkObjs);
        HashMap<String, String> addAttr = new HashMap<String, String>();
        JsonObject o = (JsonObject)jObj.get("addAttr");
        for (String k : o.names()) {
            addAttr.put(k, o.getString(k, ""));
        }
        b.additionalRegistrationAttributes(addAttr);
        JsonValue ct = jObj.get("ct");
        if (ct == null) {
            b.extractDataFromObjectLink(true);
        } else {
            HashSet<ContentFormat> supportedContentFormat = new HashSet<ContentFormat>();
            for (JsonValue ctCode : ct.asArray()) {
                supportedContentFormat.add(ContentFormat.fromCode((int)ctCode.asInt()));
            }
            b.supportedContentFormats(supportedContentFormat);
        }
        JsonValue so = jObj.get("suppObjs");
        if (so == null) {
            b.extractDataFromObjectLink(true);
        } else {
            HashMap<Integer, String> supportedObject = new HashMap<Integer, String>();
            for (JsonObject.Member member : so.asObject()) {
                supportedObject.put(Integer.parseInt(member.getName()), member.getValue().asString());
            }
            b.supportedObjects(supportedObject);
        }
        HashMap<String, String> appData = new HashMap<String, String>();
        JsonObject oap = (JsonObject)jObj.get("appdata");
        for (String k : oap.names()) {
            JsonValue jv = oap.get(k);
            if (jv.isNull()) {
                appData.put(k, null);
                continue;
            }
            appData.put(k, jv.asString());
        }
        b.applicationData(appData);
        return b.build();
    }

    public static Registration deserialize(byte[] data) {
        return RegistrationSerDes.deserialize((JsonObject)Json.parse((String)new String(data)));
    }
}

