/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.transport.javacoap.server.coaptcp.endpoint;

import com.mbed.coap.packet.BlockSize;
import com.mbed.coap.packet.CoapRequest;
import com.mbed.coap.packet.CoapResponse;
import com.mbed.coap.server.CoapServer;
import com.mbed.coap.server.CoapServerBuilderForTcp;
import com.mbed.coap.server.TcpCoapServer;
import com.mbed.coap.server.filter.TokenGeneratorFilter;
import com.mbed.coap.server.observe.NotificationsReceiver;
import com.mbed.coap.server.observe.ObservationsStore;
import com.mbed.coap.transport.CoapTcpTransport;
import com.mbed.coap.utils.Filter;
import com.mbed.coap.utils.Service;
import java.net.InetSocketAddress;
import org.eclipse.leshan.core.endpoint.Protocol;
import org.eclipse.leshan.server.security.SecurityStore;
import org.eclipse.leshan.server.security.ServerSecurityInfo;
import org.eclipse.leshan.transport.javacoap.identity.DefaultCoapIdentityHandler;
import org.eclipse.leshan.transport.javacoap.identity.IdentityHandler;
import org.eclipse.leshan.transport.javacoap.server.coaptcp.transport.CoapTcpTransportResolver;
import org.eclipse.leshan.transport.javacoap.server.coaptcp.transport.DefaultTransportContextMatcher;
import org.eclipse.leshan.transport.javacoap.server.coaptcp.transport.NettyCoapTcpTransport;
import org.eclipse.leshan.transport.javacoap.server.endpoint.AbstractJavaCoapServerEndpointsProvider;

public class JavaCoapTcpServerEndpointsProvider
extends AbstractJavaCoapServerEndpointsProvider {
    public JavaCoapTcpServerEndpointsProvider(InetSocketAddress localAddress) {
        super(Protocol.COAP_TCP, "CoAP over TCP experimental endpoint based on java-coap and netty libraries", localAddress, (IdentityHandler)new DefaultCoapIdentityHandler());
    }

    protected CoapServer createCoapServer(InetSocketAddress localAddress, ServerSecurityInfo serverSecurityInfo, SecurityStore securityStore, Service<CoapRequest, CoapResponse> resources, NotificationsReceiver notificationReceiver, ObservationsStore observationsStore) {
        return this.createCoapServer().transport((CoapTcpTransport)new NettyCoapTcpTransport(localAddress, new CoapTcpTransportResolver(), new DefaultTransportContextMatcher(), null)).blockSize(BlockSize.S_1024_BERT).maxIncomingBlockTransferSize(4000).maxMessageSize(2100).route(resources).notificationsReceiver(notificationReceiver).observationsStore(observationsStore).build();
    }

    protected CoapServerBuilderForTcp createCoapServer() {
        return TcpCoapServer.builder().outboundFilter((Filter.SimpleFilter)TokenGeneratorFilter.RANDOM);
    }
}

