/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.transport.javacoap.server.coaptcp.endpoint;

import com.mbed.coap.packet.BlockSize;
import com.mbed.coap.packet.CoapRequest;
import com.mbed.coap.packet.CoapResponse;
import com.mbed.coap.server.CoapServer;
import com.mbed.coap.server.CoapServerBuilderForTcp;
import com.mbed.coap.server.TcpCoapServer;
import com.mbed.coap.server.filter.TokenGeneratorFilter;
import com.mbed.coap.server.observe.NotificationsReceiver;
import com.mbed.coap.server.observe.ObservationsStore;
import com.mbed.coap.transport.CoapTcpTransport;
import com.mbed.coap.transport.TransportContext;
import com.mbed.coap.utils.Filter;
import com.mbed.coap.utils.Service;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.Attribute;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.security.auth.x500.X500Principal;
import org.eclipse.leshan.core.endpoint.Protocol;
import org.eclipse.leshan.core.security.certificate.util.X509CertUtil;
import org.eclipse.leshan.core.security.certificate.verifier.DefaultCertificateVerifier;
import org.eclipse.leshan.core.security.certificate.verifier.X509CertificateVerifier;
import org.eclipse.leshan.core.security.jsse.LwM2mX509TrustManager;
import org.eclipse.leshan.server.security.EditableSecurityStore;
import org.eclipse.leshan.server.security.SecurityInfo;
import org.eclipse.leshan.server.security.SecurityStore;
import org.eclipse.leshan.server.security.SecurityStoreListener;
import org.eclipse.leshan.server.security.ServerSecurityInfo;
import org.eclipse.leshan.transport.javacoap.SingleX509KeyManager;
import org.eclipse.leshan.transport.javacoap.identity.DefaultTlsIdentityHandler;
import org.eclipse.leshan.transport.javacoap.identity.IdentityHandler;
import org.eclipse.leshan.transport.javacoap.identity.TlsTransportContextKeys;
import org.eclipse.leshan.transport.javacoap.server.coaptcp.endpoint.LwM2mTransportContextMatcher;
import org.eclipse.leshan.transport.javacoap.server.coaptcp.transport.CoapsTcpTransportResolver;
import org.eclipse.leshan.transport.javacoap.server.coaptcp.transport.NettyCoapTcpTransport;
import org.eclipse.leshan.transport.javacoap.server.coaptcp.transport.TransportContextHandler;
import org.eclipse.leshan.transport.javacoap.server.endpoint.AbstractJavaCoapServerEndpointsProvider;

public class JavaCoapsTcpServerEndpointsProvider
extends AbstractJavaCoapServerEndpointsProvider {
    public JavaCoapsTcpServerEndpointsProvider(InetSocketAddress localAddress) {
        super(Protocol.COAPS_TCP, "CoAP over TLS experimental endpoint based on java-coap and netty libraries", localAddress, (IdentityHandler)new DefaultTlsIdentityHandler());
    }

    protected CoapServer createCoapServer(InetSocketAddress localAddress, ServerSecurityInfo serverSecurityInfo, SecurityStore securityStore, Service<CoapRequest, CoapResponse> resources, NotificationsReceiver notificationReceiver, ObservationsStore observationsStore) {
        SslContext sslContext;
        try {
            SingleX509KeyManager keys = new SingleX509KeyManager(serverSecurityInfo.getPrivateKey(), serverSecurityInfo.getCertificateChain());
            LwM2mX509TrustManager trustManger = new LwM2mX509TrustManager((X509CertificateVerifier)new DefaultCertificateVerifier(Arrays.asList(X509CertUtil.asX509Certificates((Certificate[])serverSecurityInfo.getTrustedCertificates()))){

                protected void validateSubject(InetSocketAddress peerSocket, X509Certificate receivedServerCertificate) throws CertificateException {
                }
            });
            sslContext = SslContextBuilder.forServer((KeyManager)keys).startTls(false).trustManager((TrustManager)trustManger).protocols(new String[]{"TLSv1.2"}).clientAuth(ClientAuth.REQUIRE).build();
        }
        catch (CertificateException | SSLException e) {
            throw new IllegalStateException("Unable to create tls endpoint point", e);
        }
        if (sslContext == null) {
            throw new IllegalStateException("Unable to create tls endpoint point : sslcontext must not be null");
        }
        NettyCoapTcpTransport transport = new NettyCoapTcpTransport(localAddress, new CoapsTcpTransportResolver(), new LwM2mTransportContextMatcher(), sslContext);
        this.createAndAttachConnectionCleaner(transport, securityStore);
        return this.createCoapServer().transport((CoapTcpTransport)transport).blockSize(BlockSize.S_1024_BERT).maxIncomingBlockTransferSize(4000).maxMessageSize(2100).route(resources).notificationsReceiver(notificationReceiver).observationsStore(observationsStore).build();
    }

    protected CoapServerBuilderForTcp createCoapServer() {
        return TcpCoapServer.builder().outboundFilter((Filter.SimpleFilter)TokenGeneratorFilter.RANDOM);
    }

    protected void createAndAttachConnectionCleaner(final NettyCoapTcpTransport transport, SecurityStore securityStore) {
        if (securityStore instanceof EditableSecurityStore) {
            ((EditableSecurityStore)securityStore).addListener(new SecurityStoreListener(){

                public void securityInfoRemoved(boolean infosAreCompromised, SecurityInfo ... infos) {
                    transport.closeConnections(channel -> {
                        Principal principal;
                        Attribute attr = channel.attr(TransportContextHandler.TRANSPORT_CONTEXT_ATTR);
                        if (attr != null && (principal = (Principal)((TransportContext)attr.get()).get(TlsTransportContextKeys.PRINCIPAL)) != null) {
                            for (SecurityInfo info : infos) {
                                String x509CommonName;
                                if (info == null || !info.useX509Cert() || !(principal instanceof X500Principal) || !(x509CommonName = X509CertUtil.extractCN((String)principal.getName())).equals(info.getEndpoint())) continue;
                                return true;
                            }
                        }
                        return false;
                    });
                }
            });
        }
    }
}

