/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.transport.javacoap.server.coaptcp.endpoint;

import com.mbed.coap.transport.TransportContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import org.eclipse.leshan.transport.javacoap.identity.TlsTransportContextKeys;
import org.eclipse.leshan.transport.javacoap.server.coaptcp.transport.DefaultTransportContextMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LwM2mTransportContextMatcher
extends DefaultTransportContextMatcher {
    private final Logger LOG = LoggerFactory.getLogger(LwM2mTransportContextMatcher.class);

    @Override
    protected boolean matches(TransportContext.Key<?> key, Object packetValue, Object channelValue) {
        if (key.equals((Object)TlsTransportContextKeys.PRINCIPAL)) {
            if (packetValue instanceof X500Principal || channelValue instanceof X500Principal) {
                try {
                    String requestedCommonName = LwM2mTransportContextMatcher.extractCN(((X500Principal)packetValue).getName());
                    String availableCommonName = LwM2mTransportContextMatcher.extractCN(((X500Principal)channelValue).getName());
                    return requestedCommonName.equals(availableCommonName);
                }
                catch (IllegalStateException e) {
                    this.LOG.debug("Unable to extract CN from certificate {} or {}", packetValue, channelValue);
                    return false;
                }
            }
            this.LOG.debug("Unsupported kind of principal {} or {}", (Object)packetValue.getClass().getSimpleName(), (Object)channelValue.getClass().getSimpleName());
            return false;
        }
        return super.matches(key, packetValue, channelValue);
    }

    public static String extractCN(String dn) {
        Matcher endpointMatcher = Pattern.compile("CN=(.*?)(,|$)").matcher(dn);
        if (endpointMatcher.find()) {
            return endpointMatcher.group(1);
        }
        throw new IllegalStateException("Unable to extract sender identity : can not get common name in certificate");
    }
}

