/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.transport.javacoap.server.coaptcp.transport;

import com.mbed.coap.packet.CoapPacket;
import com.mbed.coap.packet.CoapTcpPacketSerializer;
import com.mbed.coap.transport.TransportContext;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.function.BiFunction;
import org.eclipse.leshan.transport.javacoap.server.coaptcp.transport.TransportContextHandler;
import org.eclipse.leshan.transport.javacoap.server.coaptcp.transport.UnconnectedPeerException;

public class CoapTcpEncoder
extends MessageToByteEncoder<CoapPacket> {
    private final BiFunction<TransportContext, TransportContext, Boolean> contextMatcher;

    public CoapTcpEncoder(BiFunction<TransportContext, TransportContext, Boolean> contextMatcher) {
        this.contextMatcher = contextMatcher;
    }

    protected void encode(ChannelHandlerContext ctx, CoapPacket msg, ByteBuf out) throws Exception {
        TransportContext transportContext = (TransportContext)ctx.channel().attr(TransportContextHandler.TRANSPORT_CONTEXT_ATTR).get();
        if (transportContext == null) {
            throw new IllegalStateException("transport context should not be null");
        }
        if (msg.getMethod() != null && !this.contextMatcher.apply(msg.getTransportContext(), transportContext).booleanValue()) {
            throw new UnconnectedPeerException(String.format("transport context expected doesn't match current one at %s", msg.getRemoteAddress().getHostString()));
        }
        byte[] bytes = CoapTcpPacketSerializer.serialize((CoapPacket)msg);
        out.writeBytes(bytes);
    }
}

