/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.transport.javacoap.server.coaptcp.transport;

import com.mbed.coap.packet.Opaque;
import com.mbed.coap.transport.TransportContext;
import io.netty.channel.Channel;
import io.netty.handler.ssl.SslHandler;
import java.security.Principal;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.eclipse.leshan.transport.javacoap.identity.TlsTransportContextKeys;
import org.eclipse.leshan.transport.javacoap.server.coaptcp.transport.CoapTcpTransportResolver;

public class CoapsTcpTransportResolver
extends CoapTcpTransportResolver {
    @Override
    public TransportContext apply(Channel channel) {
        Principal principal;
        SslHandler sslHandler = (SslHandler)channel.pipeline().get(SslHandler.class);
        if (sslHandler == null) {
            throw new IllegalStateException("Missing SslHandler");
        }
        SSLEngine sslEngine = sslHandler.engine();
        SSLSession sslSession = sslEngine.getSession();
        if (sslSession == null) {
            throw new IllegalStateException("Missing Session");
        }
        try {
            principal = sslSession.getPeerPrincipal();
        }
        catch (SSLPeerUnverifiedException e) {
            throw new IllegalStateException("Unable to get Principal", e);
        }
        if (principal == null) {
            throw new IllegalStateException("Missing Principal");
        }
        String cipherSuite = sslSession.getCipherSuite();
        if (cipherSuite == null) {
            throw new IllegalStateException("Missing Cipher Suite");
        }
        return super.apply(channel).with(TlsTransportContextKeys.TLS_SESSION_ID, (Object)new Opaque(sslSession.getId()).toHex()).with(TlsTransportContextKeys.PRINCIPAL, (Object)principal).with(TlsTransportContextKeys.CIPHER_SUITE, (Object)cipherSuite);
    }
}

