/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.transport.javacoap.server.coaptcp.transport;

import com.mbed.coap.transport.TransportContext;
import java.util.function.BiFunction;
import org.eclipse.leshan.transport.javacoap.identity.TlsTransportContextKeys;
import org.eclipse.leshan.transport.javacoap.server.coaptcp.transport.CoapTcpTransportResolver;

public class DefaultTransportContextMatcher
implements BiFunction<TransportContext, TransportContext, Boolean> {
    private final TransportContext.Key<?>[] knownKeys;

    public DefaultTransportContextMatcher() {
        this(CoapTcpTransportResolver.REMOTE_ADDRESS, CoapTcpTransportResolver.CONNECTION_ID, CoapTcpTransportResolver.CONNECTION_START_TIMESTAMP, TlsTransportContextKeys.TLS_SESSION_ID, TlsTransportContextKeys.PRINCIPAL, TlsTransportContextKeys.CIPHER_SUITE);
    }

    public DefaultTransportContextMatcher(TransportContext.Key<?> ... knownKeys) {
        this.knownKeys = knownKeys;
    }

    @Override
    public Boolean apply(TransportContext packetTransport, TransportContext channelTransport) {
        for (TransportContext.Key<?> key : this.knownKeys) {
            Object channelValue;
            Object packetValue = packetTransport.get(key);
            if (packetValue == null || this.matches(key, packetValue, channelValue = channelTransport.get(key))) continue;
            return false;
        }
        return true;
    }

    protected boolean matches(TransportContext.Key<?> key, Object packetValue, Object channelValue) {
        return packetValue.equals(channelValue);
    }
}

