/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.transport.javacoap.server.coaptcp.transport;

import com.mbed.coap.packet.CoapPacket;
import com.mbed.coap.transport.CoapTcpListener;
import com.mbed.coap.transport.CoapTcpTransport;
import com.mbed.coap.transport.TransportContext;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.net.ssl.SSLHandshakeException;
import org.eclipse.leshan.transport.javacoap.server.coaptcp.transport.CoapTcpDecoder;
import org.eclipse.leshan.transport.javacoap.server.coaptcp.transport.CoapTcpEncoder;
import org.eclipse.leshan.transport.javacoap.server.coaptcp.transport.NettyUtils;
import org.eclipse.leshan.transport.javacoap.server.coaptcp.transport.TransportContextHandler;
import org.eclipse.leshan.transport.javacoap.server.coaptcp.transport.UnconnectedPeerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyCoapTcpTransport
implements CoapTcpTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyCoapTcpTransport.class);
    private final InetSocketAddress localAddress;
    private volatile Channel mainChannel;
    private final ConcurrentMap<SocketAddress, Channel> activeChannels = new ConcurrentHashMap<SocketAddress, Channel>();
    private volatile CoapTcpListener listener;
    private CompletableFuture<CoapPacket> receivePromise = new CompletableFuture();
    private final SslContext sslContext;
    private final Function<Channel, TransportContext> contextResolver;
    private final BiFunction<TransportContext, TransportContext, Boolean> contextMatcher;

    public NettyCoapTcpTransport(InetSocketAddress localadddress, Function<Channel, TransportContext> contextResolver, BiFunction<TransportContext, TransportContext, Boolean> contextMatcher, SslContext sslContext) {
        this.localAddress = localadddress;
        this.sslContext = sslContext;
        this.contextResolver = contextResolver;
        this.contextMatcher = contextMatcher;
    }

    public synchronized void start() throws IOException {
        ServerBootstrap bootstrap = new ServerBootstrap();
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(1);
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelRegistry()).option(ChannelOption.SO_BACKLOG, (Object)100)).option(ChannelOption.AUTO_READ, (Object)true)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.mainChannel = bootstrap.bind((SocketAddress)this.localAddress).syncUninterruptibly().channel();
    }

    public void stop() {
        this.mainChannel.close();
        this.mainChannel.closeFuture().syncUninterruptibly();
    }

    public CompletableFuture<Boolean> sendPacket(CoapPacket packet) {
        InetSocketAddress peerAddress = packet.getRemoteAddress();
        Channel channel = (Channel)this.activeChannels.get(peerAddress);
        if (channel == null) {
            CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
            future.completeExceptionally(new UnconnectedPeerException(String.format("Peer %s is not connected", peerAddress)));
            return future;
        }
        ChannelPromise channelPromise = channel.newPromise();
        channel.writeAndFlush((Object)packet, channelPromise);
        return NettyUtils.toCompletableFuture(channelPromise).thenApply(__ -> true);
    }

    public void closeConnections(Predicate<Channel> filter) {
        for (Channel channel : this.activeChannels.values()) {
            if (!filter.test(channel)) continue;
            SslHandler sslHandler = (SslHandler)channel.pipeline().get(SslHandler.class);
            sslHandler.engine().getSession().invalidate();
            sslHandler.closeOutbound();
        }
    }

    public CompletableFuture<CoapPacket> receive() {
        this.receivePromise = new CompletableFuture();
        return this.receivePromise;
    }

    public InetSocketAddress getLocalSocketAddress() {
        return (InetSocketAddress)this.mainChannel.localAddress();
    }

    public Channel getChannel() {
        return this.mainChannel;
    }

    public void setListener(CoapTcpListener listener) {
        this.listener = listener;
    }

    private static class CloseOnErrorHandler
    extends ChannelInboundHandlerAdapter {
        private CloseOnErrorHandler() {
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (!this.checkAndHandleIfExpectedError(ctx, cause)) {
                LOGGER.warn("Unexpected Error :", cause);
                ctx.close();
            }
        }

        private boolean checkAndHandleIfExpectedError(ChannelHandlerContext ctx, Throwable error) {
            if (error instanceof SSLHandshakeException || error.getCause() instanceof SSLHandshakeException) {
                LOGGER.debug("Handshake Failed with {} peer:", (Object)ctx.channel().remoteAddress(), (Object)error);
                return true;
            }
            return false;
        }
    }

    private static class CloseOnIdleHandler
    extends ChannelDuplexHandler {
        private CloseOnIdleHandler() {
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof IdleStateEvent) {
                ctx.channel().close();
            }
        }
    }

    public class DispatchHandler
    extends ChannelInboundHandlerAdapter {
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (!NettyCoapTcpTransport.this.receivePromise.complete((CoapPacket)msg)) {
                ctx.fireChannelRead(msg);
            }
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            if (NettyCoapTcpTransport.this.listener != null && ctx.channel().remoteAddress() != null) {
                NettyCoapTcpTransport.this.listener.onConnected((InetSocketAddress)ctx.channel().remoteAddress());
            }
            super.channelActive(ctx);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            if (NettyCoapTcpTransport.this.listener != null && ctx.channel().remoteAddress() != null) {
                NettyCoapTcpTransport.this.listener.onDisconnected((InetSocketAddress)ctx.channel().remoteAddress());
            }
            super.channelInactive(ctx);
        }
    }

    class ChannelTracker
    extends ChannelInboundHandlerAdapter {
        ChannelTracker() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            NettyCoapTcpTransport.this.activeChannels.put(ctx.channel().remoteAddress(), ctx.channel());
            super.channelActive(ctx);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            if (ctx.channel().remoteAddress() != null) {
                NettyCoapTcpTransport.this.activeChannels.remove(ctx.channel().remoteAddress());
            } else {
                LOGGER.warn("Channel Remote Address is null");
                NettyCoapTcpTransport.this.activeChannels.values().remove(ctx.channel());
            }
            super.channelInactive(ctx);
        }
    }

    private class ChannelRegistry
    extends ChannelInitializer<SocketChannel> {
        private ChannelRegistry() {
        }

        protected void initChannel(SocketChannel ch) throws Exception {
            if (NettyCoapTcpTransport.this.sslContext != null) {
                ch.pipeline().addFirst(new ChannelHandler[]{NettyCoapTcpTransport.this.sslContext.newHandler(ch.alloc())});
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt instanceof SslHandshakeCompletionEvent && ((SslHandshakeCompletionEvent)evt).isSuccess()) {
                            super.channelActive(ctx);
                        }
                    }

                    public void channelActive(ChannelHandlerContext ctx) throws Exception {
                    }
                }});
            }
            ch.pipeline().addLast(new ChannelHandler[]{new TransportContextHandler(NettyCoapTcpTransport.this.contextResolver)});
            ch.pipeline().addLast(new ChannelHandler[]{new ChannelTracker()});
            ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(0, 0, 0)});
            ch.pipeline().addLast(new ChannelHandler[]{new CloseOnIdleHandler()});
            ch.pipeline().addLast(new ChannelHandler[]{new CoapTcpDecoder()});
            ch.pipeline().addLast(new ChannelHandler[]{new CoapTcpEncoder(NettyCoapTcpTransport.this.contextMatcher)});
            ch.pipeline().addLast(new ChannelHandler[]{new DispatchHandler()});
            ch.pipeline().addLast(new ChannelHandler[]{new CloseOnErrorHandler()});
        }
    }
}

