/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.transport.javacoap.server.coaptcp.transport;

import com.mbed.coap.transport.TransportContext;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.AttributeKey;
import java.util.Objects;
import java.util.function.Function;

public class TransportContextHandler
extends ChannelInboundHandlerAdapter {
    public static final AttributeKey<TransportContext> TRANSPORT_CONTEXT_ATTR = AttributeKey.newInstance((String)"transport");
    private final Function<Channel, TransportContext> contextResolver;

    public TransportContextHandler(Function<Channel, TransportContext> contextResolver) {
        this.contextResolver = Objects.requireNonNull(contextResolver);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.attachContextToChannel(ctx);
        super.channelActive(ctx);
    }

    protected void attachContextToChannel(ChannelHandlerContext ctx) {
        TransportContext transportContext = this.contextResolver.apply(ctx.channel());
        if (transportContext == null) {
            throw new IllegalStateException("transport context must not be null");
        }
        TransportContext oldTransportContext = (TransportContext)ctx.channel().attr(TRANSPORT_CONTEXT_ATTR).setIfAbsent((Object)transportContext);
        if (oldTransportContext != null) {
            throw new IllegalStateException(String.format("Can not create new endpoint context %s as %s already exists.", transportContext, oldTransportContext));
        }
    }
}

