/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.transport.javacoap.server.endpoint;

import com.mbed.coap.packet.CoapRequest;
import com.mbed.coap.packet.CoapResponse;
import com.mbed.coap.server.CoapServer;
import com.mbed.coap.server.RouterService;
import com.mbed.coap.server.observe.NotificationsReceiver;
import com.mbed.coap.server.observe.ObservationsStore;
import com.mbed.coap.utils.Service;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.leshan.core.endpoint.Protocol;
import org.eclipse.leshan.core.link.LinkParser;
import org.eclipse.leshan.server.LeshanServer;
import org.eclipse.leshan.server.endpoint.LwM2mServerEndpoint;
import org.eclipse.leshan.server.endpoint.LwM2mServerEndpointsProvider;
import org.eclipse.leshan.server.endpoint.ServerEndpointToolbox;
import org.eclipse.leshan.server.observation.LwM2mNotificationReceiver;
import org.eclipse.leshan.server.request.UplinkRequestReceiver;
import org.eclipse.leshan.server.security.SecurityStore;
import org.eclipse.leshan.server.security.ServerSecurityInfo;
import org.eclipse.leshan.transport.javacoap.identity.IdentityHandler;
import org.eclipse.leshan.transport.javacoap.server.endpoint.EndpointUriProvider;
import org.eclipse.leshan.transport.javacoap.server.endpoint.JavaCoapServerEndpoint;
import org.eclipse.leshan.transport.javacoap.server.endpoint.ServerCoapMessageTranslator;
import org.eclipse.leshan.transport.javacoap.server.observation.CoapNotificationReceiver;
import org.eclipse.leshan.transport.javacoap.server.observation.LwM2mObservationsStore;
import org.eclipse.leshan.transport.javacoap.server.resource.RegistrationResource;
import org.eclipse.leshan.transport.javacoap.server.resource.SendResource;

public abstract class AbstractJavaCoapServerEndpointsProvider
implements LwM2mServerEndpointsProvider {
    private final Protocol supportedProtocol;
    private final String endpointDescription;
    private final InetSocketAddress localAddress;
    private CoapServer coapServer;
    private JavaCoapServerEndpoint lwm2mEndpoint;
    private final IdentityHandler identityHandler;

    public AbstractJavaCoapServerEndpointsProvider(Protocol protocol, String endpointDescription, InetSocketAddress localAddress, IdentityHandler identityHandler) {
        this.supportedProtocol = protocol;
        this.endpointDescription = endpointDescription;
        this.localAddress = localAddress;
        this.identityHandler = identityHandler;
    }

    public void createEndpoints(UplinkRequestReceiver requestReceiver, LwM2mNotificationReceiver notificationReceiver, ServerEndpointToolbox toolbox, ServerSecurityInfo serverSecurityInfo, LeshanServer server) {
        EndpointUriProvider endpointUriProvider = new EndpointUriProvider(this.supportedProtocol);
        RegistrationResource registerResource = new RegistrationResource(requestReceiver, (LinkParser)toolbox.getLinkParser(), endpointUriProvider, this.identityHandler);
        Service resources = RouterService.builder().any("/rd/*", (Service)registerResource).any("/rd", (Service)registerResource).any("/dp", (Service)new SendResource(requestReceiver, toolbox.getDecoder(), toolbox.getProfileProvider(), endpointUriProvider, this.identityHandler)).build();
        this.coapServer = this.createCoapServer(this.localAddress, serverSecurityInfo, server.getSecurityStore(), (Service<CoapRequest, CoapResponse>)resources, new CoapNotificationReceiver(this.coapServer, notificationReceiver, server.getRegistrationStore(), server.getModelProvider(), toolbox.getDecoder()), new LwM2mObservationsStore(server.getRegistrationStore(), notificationReceiver, this.identityHandler));
        endpointUriProvider.setCoapServer(this.coapServer);
        this.lwm2mEndpoint = new JavaCoapServerEndpoint(this.supportedProtocol, this.endpointDescription, this.coapServer, new ServerCoapMessageTranslator(this.identityHandler), toolbox);
    }

    protected abstract CoapServer createCoapServer(InetSocketAddress var1, ServerSecurityInfo var2, SecurityStore var3, Service<CoapRequest, CoapResponse> var4, NotificationsReceiver var5, ObservationsStore var6);

    public List<LwM2mServerEndpoint> getEndpoints() {
        if (this.lwm2mEndpoint == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.lwm2mEndpoint);
    }

    public LwM2mServerEndpoint getEndpoint(URI uri) {
        if (this.lwm2mEndpoint != null && this.lwm2mEndpoint.getURI().equals(uri)) {
            return this.lwm2mEndpoint;
        }
        return null;
    }

    public void start() {
        try {
            this.coapServer.start();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to start java-coap endpoint", e);
        }
    }

    public void stop() {
        this.coapServer.stop();
    }

    public void destroy() {
        this.coapServer.stop();
    }
}

