/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.transport.javacoap.server.endpoint;

import com.mbed.coap.exception.CoapTimeoutException;
import com.mbed.coap.packet.CoapRequest;
import com.mbed.coap.packet.CoapResponse;
import com.mbed.coap.server.CoapServer;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.SortedMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.leshan.core.endpoint.EndpointUriUtil;
import org.eclipse.leshan.core.endpoint.Protocol;
import org.eclipse.leshan.core.observation.Observation;
import org.eclipse.leshan.core.request.DownlinkRequest;
import org.eclipse.leshan.core.request.exception.RequestCanceledException;
import org.eclipse.leshan.core.request.exception.SendFailedException;
import org.eclipse.leshan.core.request.exception.TimeoutException;
import org.eclipse.leshan.core.response.ErrorCallback;
import org.eclipse.leshan.core.response.LwM2mResponse;
import org.eclipse.leshan.core.response.ResponseCallback;
import org.eclipse.leshan.core.util.NamedThreadFactory;
import org.eclipse.leshan.core.util.Validate;
import org.eclipse.leshan.server.endpoint.LwM2mServerEndpoint;
import org.eclipse.leshan.server.endpoint.ServerEndpointToolbox;
import org.eclipse.leshan.server.profile.ClientProfile;
import org.eclipse.leshan.server.request.LowerLayerConfig;
import org.eclipse.leshan.transport.javacoap.server.endpoint.ServerCoapMessageTranslator;

public class JavaCoapServerEndpoint
implements LwM2mServerEndpoint {
    private final Protocol supportedProtocol;
    private final String endpointDescription;
    private final CoapServer coapServer;
    private final ServerCoapMessageTranslator translator;
    private final ServerEndpointToolbox toolbox;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("Leshan Async Request timeout"));
    private final ConcurrentNavigableMap<String, CompletableFuture<? extends LwM2mResponse>> ongoingRequests = new ConcurrentSkipListMap<String, CompletableFuture<? extends LwM2mResponse>>();
    private final AtomicLong idGenerator = new AtomicLong(0L);

    public JavaCoapServerEndpoint(Protocol protocol, String endpointDescription, CoapServer coapServer, ServerCoapMessageTranslator translator, ServerEndpointToolbox toolbox) {
        this.supportedProtocol = protocol;
        this.endpointDescription = endpointDescription;
        this.coapServer = coapServer;
        this.translator = translator;
        this.toolbox = toolbox;
    }

    public Protocol getProtocol() {
        return this.supportedProtocol;
    }

    public String getDescription() {
        return this.endpointDescription;
    }

    public URI getURI() {
        return EndpointUriUtil.createUri((String)this.getProtocol().getUriScheme(), (InetSocketAddress)this.coapServer.getLocalSocketAddress());
    }

    public <T extends LwM2mResponse> T send(ClientProfile destination, DownlinkRequest<T> request, LowerLayerConfig lowerLayerConfig, long timeoutInMs) throws InterruptedException {
        CompletableFuture<T> lwm2mResponseFuture = this.sendLwM2mRequest(destination, request, lowerLayerConfig);
        try {
            return (T)((LwM2mResponse)lwm2mResponseFuture.get(timeoutInMs, TimeUnit.MILLISECONDS));
        }
        catch (CancellationException | CompletionException | ExecutionException exception) {
            if (lwm2mResponseFuture.isCancelled()) {
                throw new RequestCanceledException();
            }
            if (exception.getCause() instanceof CoapTimeoutException) {
                return null;
            }
            throw new SendFailedException("Unable to send request  " + exception.getCause(), (Throwable)exception);
        }
        catch (TimeoutException e) {
            lwm2mResponseFuture.cancel(true);
            return null;
        }
    }

    public <T extends LwM2mResponse> void send(ClientProfile destination, DownlinkRequest<T> request, ResponseCallback<T> responseCallback, ErrorCallback errorCallback, LowerLayerConfig lowerLayerConfig, long timeoutInMs) {
        CompletableFuture<T> lwm2mResponseFuture = this.sendLwM2mRequest(destination, request, lowerLayerConfig);
        lwm2mResponseFuture.whenComplete((lwM2mResponse, exception) -> {
            if (exception != null) {
                if (exception instanceof CancellationException) {
                    errorCallback.onError((Exception)new RequestCanceledException());
                } else if (exception instanceof TimeoutException) {
                    errorCallback.onError((Exception)new org.eclipse.leshan.core.request.exception.TimeoutException(TimeoutException.Type.RESPONSE_TIMEOUT, exception.getCause(), "LWM2M response Timeout", new Object[0]));
                } else if (exception instanceof CompletionException && exception.getCause() instanceof CoapTimeoutException) {
                    errorCallback.onError((Exception)new org.eclipse.leshan.core.request.exception.TimeoutException(TimeoutException.Type.COAP_TIMEOUT, exception.getCause(), "Coap Timeout", new Object[0]));
                } else {
                    errorCallback.onError((Exception)new SendFailedException("Unable to send request " + exception.getCause(), exception.getCause()));
                }
            } else {
                responseCallback.onResponse(lwM2mResponse);
            }
        });
        this.timeoutAfter(lwm2mResponseFuture, timeoutInMs);
    }

    protected <T extends LwM2mResponse> CompletableFuture<T> sendLwM2mRequest(ClientProfile destination, DownlinkRequest<T> lwm2mRequest, LowerLayerConfig lowerLayerConfig) {
        CoapRequest coapRequest = this.translator.createCoapRequest(destination, lwm2mRequest, this.toolbox);
        this.applyUserConfig(lowerLayerConfig, coapRequest);
        CompletableFuture coapResponseFuture = (CompletableFuture)this.coapServer.clientService().apply((Object)coapRequest);
        CompletionStage lwm2mResponseFuture = coapResponseFuture.thenApply(coapResponse -> this.translator.createLwM2mResponse(destination, lwm2mRequest, (CoapResponse)coapResponse, coapRequest, this.toolbox));
        this.addOngoingRequest(destination.getRegistrationId(), (CompletableFuture<? extends LwM2mResponse>)lwm2mResponseFuture);
        return lwm2mResponseFuture;
    }

    public void timeoutAfter(CompletableFuture<?> future, long timeoutInMs) {
        ScheduledFuture<?> timeoutTask = this.executor.schedule(() -> {
            if (future != null && !future.isDone()) {
                future.completeExceptionally(new TimeoutException());
            }
        }, timeoutInMs, TimeUnit.MILLISECONDS);
        future.whenComplete((r, e) -> {
            if (e == null && timeoutTask != null && !timeoutTask.isDone()) {
                timeoutTask.cancel(false);
            }
        });
    }

    public void cancelRequests(String sessionID) {
        Validate.notNull((Object)sessionID);
        SortedMap requests = this.ongoingRequests.subMap((Object)JavaCoapServerEndpoint.getFloorKey(sessionID), (Object)JavaCoapServerEndpoint.getCeilingKey(sessionID));
        for (CompletableFuture request : requests.values()) {
            request.cancel(false);
        }
        requests.clear();
    }

    public void cancelObservation(Observation observation) {
    }

    private static String getFloorKey(String sessionID) {
        return sessionID + '#';
    }

    private static String getCeilingKey(String sessionID) {
        return sessionID + "#A";
    }

    private static String getKey(String sessionID, long requestId) {
        return sessionID + '#' + requestId;
    }

    private void addOngoingRequest(String sessionID, CompletableFuture<? extends LwM2mResponse> coapRequest) {
        if (sessionID != null) {
            String key = JavaCoapServerEndpoint.getKey(sessionID, this.idGenerator.incrementAndGet());
            this.ongoingRequests.put(key, coapRequest);
            coapRequest.whenComplete((r, e) -> this.ongoingRequests.remove(key));
        }
    }

    private void applyUserConfig(LowerLayerConfig lowerLayerConfig, CoapRequest request) {
        if (lowerLayerConfig != null) {
            lowerLayerConfig.apply((Object)request);
        }
    }
}

