/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.transport.javacoap.server.endpoint;

import com.mbed.coap.packet.CoapRequest;
import com.mbed.coap.packet.CoapResponse;
import com.mbed.coap.server.CoapServer;
import com.mbed.coap.server.CoapServerBuilder;
import com.mbed.coap.server.filter.TokenGeneratorFilter;
import com.mbed.coap.server.observe.NotificationsReceiver;
import com.mbed.coap.server.observe.ObservationsStore;
import com.mbed.coap.transport.CoapTransport;
import com.mbed.coap.transport.udp.DatagramSocketTransport;
import com.mbed.coap.utils.Filter;
import com.mbed.coap.utils.Service;
import java.net.InetSocketAddress;
import org.eclipse.leshan.core.endpoint.Protocol;
import org.eclipse.leshan.server.security.SecurityStore;
import org.eclipse.leshan.server.security.ServerSecurityInfo;
import org.eclipse.leshan.transport.javacoap.identity.DefaultCoapIdentityHandler;
import org.eclipse.leshan.transport.javacoap.identity.IdentityHandler;
import org.eclipse.leshan.transport.javacoap.server.endpoint.AbstractJavaCoapServerEndpointsProvider;

public class JavaCoapServerEndpointsProvider
extends AbstractJavaCoapServerEndpointsProvider {
    public JavaCoapServerEndpointsProvider(InetSocketAddress localAddress) {
        super(Protocol.COAP, "CoAP over UDP endpoint based on java-coap library", localAddress, (IdentityHandler)new DefaultCoapIdentityHandler());
    }

    @Override
    protected CoapServer createCoapServer(InetSocketAddress localAddress, ServerSecurityInfo serverSecurityInfo, SecurityStore securityStore, Service<CoapRequest, CoapResponse> resources, NotificationsReceiver notificationReceiver, ObservationsStore observationsStore) {
        return this.createCoapServer().transport((CoapTransport)new DatagramSocketTransport(localAddress)).route(resources).notificationsReceiver(notificationReceiver).observationsStore(observationsStore).build();
    }

    protected CoapServerBuilder createCoapServer() {
        return CoapServer.builder().outboundFilter((Filter.SimpleFilter)TokenGeneratorFilter.RANDOM);
    }
}

