/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.transport.javacoap.server.endpoint;

import com.mbed.coap.packet.CoapRequest;
import com.mbed.coap.packet.CoapResponse;
import org.eclipse.leshan.core.request.DownlinkRequest;
import org.eclipse.leshan.core.request.DownlinkRequestVisitor;
import org.eclipse.leshan.core.response.LwM2mResponse;
import org.eclipse.leshan.server.endpoint.ServerEndpointToolbox;
import org.eclipse.leshan.server.profile.ClientProfile;
import org.eclipse.leshan.transport.javacoap.identity.IdentityHandler;
import org.eclipse.leshan.transport.javacoap.server.request.CoapRequestBuilder;
import org.eclipse.leshan.transport.javacoap.server.request.LwM2mResponseBuilder;

public class ServerCoapMessageTranslator {
    private final IdentityHandler identityHandler;

    public ServerCoapMessageTranslator(IdentityHandler identityHandler) {
        this.identityHandler = identityHandler;
    }

    public CoapRequest createCoapRequest(ClientProfile clientProfile, DownlinkRequest<? extends LwM2mResponse> lwm2mRequest, ServerEndpointToolbox toolbox) {
        CoapRequestBuilder builder = new CoapRequestBuilder(clientProfile.getRegistration(), clientProfile.getTransportData(), clientProfile.getRootPath(), clientProfile.getModel(), toolbox.getEncoder(), this.identityHandler);
        lwm2mRequest.accept((DownlinkRequestVisitor)builder);
        return builder.getRequest();
    }

    public <T extends LwM2mResponse> T createLwM2mResponse(ClientProfile clientProfile, DownlinkRequest<T> lwm2mRequest, CoapResponse coapResponse, CoapRequest coapRequest, ServerEndpointToolbox toolbox) {
        LwM2mResponseBuilder builder = new LwM2mResponseBuilder(coapResponse, coapRequest, clientProfile.getEndpoint(), clientProfile.getModel(), toolbox.getDecoder(), toolbox.getLinkParser());
        lwm2mRequest.accept(builder);
        return builder.getResponse();
    }
}

