/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.transport.javacoap.server.observation;

import com.mbed.coap.packet.CoapResponse;
import com.mbed.coap.packet.Code;
import com.mbed.coap.packet.SeparateResponse;
import com.mbed.coap.server.CoapServer;
import com.mbed.coap.server.observe.NotificationsReceiver;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.eclipse.leshan.core.ResponseCode;
import org.eclipse.leshan.core.node.TimestampedLwM2mNode;
import org.eclipse.leshan.core.node.TimestampedLwM2mNodes;
import org.eclipse.leshan.core.node.codec.CodecException;
import org.eclipse.leshan.core.node.codec.LwM2mDecoder;
import org.eclipse.leshan.core.observation.CompositeObservation;
import org.eclipse.leshan.core.observation.Observation;
import org.eclipse.leshan.core.observation.ObservationIdentifier;
import org.eclipse.leshan.core.observation.SingleObservation;
import org.eclipse.leshan.core.peer.IpPeer;
import org.eclipse.leshan.core.peer.LwM2mPeer;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.request.exception.InvalidResponseException;
import org.eclipse.leshan.core.response.AbstractLwM2mResponse;
import org.eclipse.leshan.core.response.ObserveCompositeResponse;
import org.eclipse.leshan.core.response.ObserveResponse;
import org.eclipse.leshan.server.model.LwM2mModelProvider;
import org.eclipse.leshan.server.observation.LwM2mNotificationReceiver;
import org.eclipse.leshan.server.profile.ClientProfile;
import org.eclipse.leshan.server.registration.Registration;
import org.eclipse.leshan.server.registration.RegistrationStore;
import org.eclipse.leshan.transport.javacoap.request.ResponseCodeUtil;
import org.eclipse.leshan.transport.javacoap.server.observation.ObservationUtil;

public class CoapNotificationReceiver
implements NotificationsReceiver {
    private final CoapServer coapServer;
    private final LwM2mNotificationReceiver notificationReceiver;
    private final RegistrationStore registrationStore;
    private final LwM2mModelProvider modelProvider;
    private final LwM2mDecoder decoder;

    public CoapNotificationReceiver(CoapServer coapServer, LwM2mNotificationReceiver notificationReceiver, RegistrationStore registrationStore, LwM2mModelProvider modelProvider, LwM2mDecoder decoder) {
        this.coapServer = coapServer;
        this.notificationReceiver = notificationReceiver;
        this.registrationStore = registrationStore;
        this.modelProvider = modelProvider;
        this.decoder = decoder;
    }

    public boolean onObservation(String resourceUriPath, SeparateResponse coapResponse) {
        InetSocketAddress peerAddress = coapResponse.getPeerAddress();
        IpPeer sender = new IpPeer(peerAddress);
        ObservationIdentifier observationId = new ObservationIdentifier(coapResponse.getToken().getBytes());
        Observation observation = this.registrationStore.getObservation(observationId);
        if (observation == null) {
            return false;
        }
        Optional<String> observationPath = ObservationUtil.getPath(observation);
        if (!observationPath.filter(p -> p.equals(resourceUriPath)).isPresent()) {
            throw new IllegalStateException(String.format("Observation path %s does not match reponse path %s ", observationPath.orElse("null"), resourceUriPath));
        }
        CompletableFuture payload = NotificationsReceiver.retrieveRemainingBlocks((String)resourceUriPath, (SeparateResponse)coapResponse, req -> (CompletableFuture)this.coapServer.clientService().apply(req));
        payload.whenComplete((p, e) -> {
            block8: {
                Registration registration = this.registrationStore.getRegistration(observation.getRegistrationId());
                if (registration == null) {
                    throw new IllegalStateException(String.format("No registration with Id %s", observation.getRegistrationId()));
                }
                ClientProfile clientProfile = new ClientProfile(registration, this.modelProvider.getObjectModel(registration));
                try {
                    if (e != null) {
                        this.notificationReceiver.onError(observation, (LwM2mPeer)sender, clientProfile, e instanceof Exception ? (Exception)e : new Exception((Throwable)e));
                        break block8;
                    }
                    if (p != null) {
                        AbstractLwM2mResponse observeResponse = this.createLwM2mResponseForNotification(observation, coapResponse.asResponse(), clientProfile);
                        if (observation instanceof SingleObservation) {
                            this.notificationReceiver.onNotification((SingleObservation)observation, (LwM2mPeer)sender, clientProfile, (ObserveResponse)observeResponse);
                            break block8;
                        }
                        if (observation instanceof CompositeObservation) {
                            this.notificationReceiver.onNotification((CompositeObservation)observation, (LwM2mPeer)sender, clientProfile, (ObserveCompositeResponse)observeResponse);
                            break block8;
                        }
                        throw new IllegalStateException(String.format("Unexpected observation :  %s is not supported", observation.getClass().getSimpleName()));
                    }
                    throw new IllegalStateException("unexpected behavior when handling notification");
                }
                catch (CodecException exception) {
                    this.notificationReceiver.onError(observation, (LwM2mPeer)sender, clientProfile, (Exception)new InvalidResponseException((Throwable)exception, "Unable to decode notification payload  of observation %s", new Object[]{observation}));
                }
                catch (Exception exception) {
                    this.notificationReceiver.onError(observation, (LwM2mPeer)sender, clientProfile, exception);
                }
            }
        });
        return true;
    }

    public AbstractLwM2mResponse createLwM2mResponseForNotification(Observation observation, CoapResponse coapResponse, ClientProfile profile) {
        ResponseCode responseCode = ResponseCodeUtil.toLwM2mResponseCode((Code)coapResponse.getCode());
        if (observation instanceof SingleObservation) {
            SingleObservation singleObservation = (SingleObservation)observation;
            ContentFormat contentFormat = ContentFormat.fromCode((int)coapResponse.options().getContentFormat().shortValue());
            List timestampedNodes = this.decoder.decodeTimestampedData(coapResponse.getPayload().getBytes(), contentFormat, singleObservation.getPath(), profile.getModel());
            if (timestampedNodes.size() == 1 && !((TimestampedLwM2mNode)timestampedNodes.get(0)).isTimestamped()) {
                return new ObserveResponse(responseCode, ((TimestampedLwM2mNode)timestampedNodes.get(0)).getNode(), null, null, singleObservation, null, (Object)coapResponse);
            }
            return new ObserveResponse(responseCode, null, null, timestampedNodes, singleObservation, null, (Object)coapResponse);
        }
        if (observation instanceof CompositeObservation) {
            CompositeObservation compositeObservation = (CompositeObservation)observation;
            ContentFormat contentFormat = ContentFormat.fromCode((int)coapResponse.options().getContentFormat().shortValue());
            TimestampedLwM2mNodes timestampedNodes = this.decoder.decodeTimestampedNodes(coapResponse.getPayload().getBytes(), contentFormat, compositeObservation.getPaths(), profile.getModel());
            if (timestampedNodes.getTimestamps().size() == 1 && timestampedNodes.getTimestamps().iterator().next() == null) {
                return new ObserveCompositeResponse(responseCode, timestampedNodes.getNodes(), null, compositeObservation, null, (Object)coapResponse);
            }
            return new ObserveCompositeResponse(responseCode, null, timestampedNodes, compositeObservation, null, (Object)coapResponse);
        }
        return null;
    }
}

