/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.transport.javacoap.server.observation;

import com.mbed.coap.packet.CoapRequest;
import com.mbed.coap.packet.SeparateResponse;
import com.mbed.coap.server.observe.ObservationsStore;
import java.util.Collection;
import java.util.Optional;
import org.eclipse.leshan.core.observation.Observation;
import org.eclipse.leshan.core.observation.ObservationIdentifier;
import org.eclipse.leshan.core.peer.LwM2mIdentity;
import org.eclipse.leshan.core.peer.LwM2mPeer;
import org.eclipse.leshan.server.observation.LwM2mNotificationReceiver;
import org.eclipse.leshan.server.registration.Registration;
import org.eclipse.leshan.server.registration.RegistrationStore;
import org.eclipse.leshan.transport.javacoap.identity.IdentityHandler;
import org.eclipse.leshan.transport.javacoap.server.observation.LwM2mKeys;
import org.eclipse.leshan.transport.javacoap.server.observation.ObservationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LwM2mObservationsStore
implements ObservationsStore {
    private static final Logger LOG = LoggerFactory.getLogger(LwM2mObservationsStore.class);
    private final RegistrationStore store;
    private final LwM2mNotificationReceiver notificationReceiver;
    private final IdentityHandler identityHandler;

    public LwM2mObservationsStore(RegistrationStore store, LwM2mNotificationReceiver notificationReceiver, IdentityHandler identityHandler) {
        this.store = store;
        this.notificationReceiver = notificationReceiver;
        this.identityHandler = identityHandler;
    }

    public void add(CoapRequest obsReq) {
        Observation observation = (Observation)obsReq.getTransContext(LwM2mKeys.LESHAN_OBSERVATION);
        if (observation == null) {
            String errMessage = "missing LESHAN_OBSERVATION key in coap request transport context";
            LOG.warn(errMessage);
            throw new IllegalStateException(errMessage);
        }
        Registration registration = (Registration)obsReq.getTransContext(LwM2mKeys.LESHAN_REGISTRATION);
        if (registration == null) {
            String errMessage = "missing LESHAN_REGISTRATION key in coap request transport context";
            LOG.warn(errMessage);
            throw new IllegalStateException(errMessage);
        }
        Collection removed = null;
        try {
            LOG.debug("Add new Observation for registration {} : {} ", (Object)registration.getId(), (Object)observation);
            removed = this.store.addObservation(registration.getId(), observation, false);
        }
        catch (Exception e) {
            LOG.warn("Unable to add observation {}", (Object)observation, (Object)e);
            throw e;
        }
        if (removed != null && !removed.isEmpty()) {
            for (Observation obsRemoved : removed) {
                this.notificationReceiver.cancelled(obsRemoved);
            }
        }
        this.notificationReceiver.newObservation(observation, registration);
    }

    public Optional<String> resolveUriPath(SeparateResponse obs) {
        ObservationIdentifier observationIdentifier = new ObservationIdentifier(obs.getToken().getBytes());
        LOG.debug("Search observation for  identifier {} ", (Object)observationIdentifier);
        Observation observation = this.store.getObservation(observationIdentifier);
        if (observation == null) {
            LOG.debug("Observation not found");
            return Optional.empty();
        }
        Registration registration = this.store.getRegistration(observation.getRegistrationId());
        if (registration == null) {
            LOG.debug("No registration for observation {}, {}", (Object)observationIdentifier, (Object)observation);
            return Optional.empty();
        }
        LwM2mPeer notificationIdentity = this.identityHandler.getIdentity((Object)obs);
        LwM2mIdentity registrationIdentity = registration.getClientTransportData().getIdentity();
        if (!registrationIdentity.equals(notificationIdentity.getIdentity())) {
            LOG.debug("Notification reveiced from peer with unexpected identity : should be {} but was {}", (Object)registrationIdentity, (Object)notificationIdentity.getIdentity());
            return Optional.empty();
        }
        return ObservationUtil.getPath(observation);
    }

    public void remove(SeparateResponse obs) {
        Observation removedObservation;
        ObservationIdentifier observationIdentifier = new ObservationIdentifier(obs.getToken().getBytes());
        Observation observation = this.store.getObservation(observationIdentifier);
        if (observation != null && (removedObservation = this.store.removeObservation(observation.getRegistrationId(), observationIdentifier)) != null) {
            this.notificationReceiver.cancelled(removedObservation);
        }
    }
}

