/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.transport.javacoap.server.request;

import com.mbed.coap.packet.CoapRequest;
import com.mbed.coap.packet.Opaque;
import com.mbed.coap.transport.TransportContext;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.leshan.core.model.LwM2mModel;
import org.eclipse.leshan.core.node.LwM2mIncompletePath;
import org.eclipse.leshan.core.node.LwM2mNode;
import org.eclipse.leshan.core.node.LwM2mObject;
import org.eclipse.leshan.core.node.LwM2mObjectInstance;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.core.node.codec.LwM2mEncoder;
import org.eclipse.leshan.core.observation.CompositeObservation;
import org.eclipse.leshan.core.observation.ObservationIdentifier;
import org.eclipse.leshan.core.observation.SingleObservation;
import org.eclipse.leshan.core.peer.IpPeer;
import org.eclipse.leshan.core.peer.LwM2mPeer;
import org.eclipse.leshan.core.request.BootstrapDeleteRequest;
import org.eclipse.leshan.core.request.BootstrapDiscoverRequest;
import org.eclipse.leshan.core.request.BootstrapFinishRequest;
import org.eclipse.leshan.core.request.BootstrapReadRequest;
import org.eclipse.leshan.core.request.BootstrapWriteRequest;
import org.eclipse.leshan.core.request.CancelCompositeObservationRequest;
import org.eclipse.leshan.core.request.CancelObservationRequest;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.request.CreateRequest;
import org.eclipse.leshan.core.request.DeleteRequest;
import org.eclipse.leshan.core.request.DiscoverRequest;
import org.eclipse.leshan.core.request.DownlinkRequestVisitor;
import org.eclipse.leshan.core.request.ExecuteRequest;
import org.eclipse.leshan.core.request.ObserveCompositeRequest;
import org.eclipse.leshan.core.request.ObserveRequest;
import org.eclipse.leshan.core.request.ReadCompositeRequest;
import org.eclipse.leshan.core.request.ReadRequest;
import org.eclipse.leshan.core.request.WriteAttributesRequest;
import org.eclipse.leshan.core.request.WriteCompositeRequest;
import org.eclipse.leshan.core.request.WriteRequest;
import org.eclipse.leshan.server.registration.Registration;
import org.eclipse.leshan.transport.javacoap.identity.IdentityHandler;
import org.eclipse.leshan.transport.javacoap.request.RandomTokenGenerator;
import org.eclipse.leshan.transport.javacoap.server.observation.LwM2mKeys;

public class CoapRequestBuilder
implements DownlinkRequestVisitor {
    private CoapRequest.Builder coapRequestBuilder;
    private final LwM2mPeer destination;
    private final Registration registration;
    private final String rootPath;
    private final LwM2mEncoder encoder;
    private final LwM2mModel model;
    private final IdentityHandler identityHandler;
    private final RandomTokenGenerator tokenGenerator = new RandomTokenGenerator(8);

    public CoapRequestBuilder(Registration registration, LwM2mPeer destination, String rootPath, LwM2mModel model, LwM2mEncoder encoder, IdentityHandler identityHandler) {
        this.registration = registration;
        this.destination = destination;
        this.rootPath = rootPath;
        this.model = model;
        this.encoder = encoder;
        this.identityHandler = identityHandler;
    }

    public void visit(ReadRequest request) {
        this.coapRequestBuilder = CoapRequest.get((String)this.getURI(request.getPath()));
        this.addDefaultContext(this.coapRequestBuilder);
        if (request.getContentFormat() != null) {
            this.coapRequestBuilder.accept(Short.valueOf((short)request.getContentFormat().getCode()));
        }
    }

    public void visit(DiscoverRequest request) {
        this.coapRequestBuilder = CoapRequest.get((String)this.getURI(request.getPath())).accept(Short.valueOf((short)40));
        this.addDefaultContext(this.coapRequestBuilder);
    }

    public void visit(WriteRequest request) {
        this.coapRequestBuilder = request.isReplaceRequest() ? CoapRequest.put((String)this.getURI(request.getPath())) : CoapRequest.post((String)this.getURI(request.getPath()));
        this.addDefaultContext(this.coapRequestBuilder);
        ContentFormat format = request.getContentFormat();
        this.coapRequestBuilder.contentFormat(Short.valueOf((short)format.getCode())).payload(Opaque.of((byte[])this.encoder.encode((LwM2mNode)request.getNode(), format, request.getPath(), this.model)));
    }

    public void visit(WriteAttributesRequest request) {
        this.coapRequestBuilder = CoapRequest.put((String)this.getURI(request.getPath())).query(request.getAttributes().toString());
        this.addDefaultContext(this.coapRequestBuilder);
    }

    public void visit(ExecuteRequest request) {
        this.coapRequestBuilder = CoapRequest.post((String)this.getURI(request.getPath()));
        this.addDefaultContext(this.coapRequestBuilder);
        String payload = request.getArguments().serialize();
        if (payload != null) {
            this.coapRequestBuilder.payload(payload).contentFormat(Short.valueOf((short)0));
        }
    }

    public void visit(CreateRequest request) {
        Object node = request.unknownObjectInstanceId() ? new LwM2mObjectInstance((Collection)request.getResources()) : new LwM2mObject(request.getPath().getObjectId().intValue(), (Collection)request.getObjectInstances());
        this.coapRequestBuilder = CoapRequest.post((String)this.getURI(request.getPath())).contentFormat(Short.valueOf((short)request.getContentFormat().getCode())).payload(Opaque.of((byte[])this.encoder.encode((LwM2mNode)node, request.getContentFormat(), request.getPath(), this.model)));
        this.addDefaultContext(this.coapRequestBuilder);
    }

    public void visit(DeleteRequest request) {
        this.coapRequestBuilder = CoapRequest.delete((String)this.getURI(request.getPath()));
        this.addDefaultContext(this.coapRequestBuilder);
    }

    public void visit(ObserveRequest request) {
        this.coapRequestBuilder = CoapRequest.observe((String)this.getURI(request.getPath()));
        this.addDefaultContext(this.coapRequestBuilder);
        if (request.getContentFormat() != null) {
            this.coapRequestBuilder.accept(Short.valueOf((short)request.getContentFormat().getCode()));
        }
        Opaque token = this.tokenGenerator.createToken();
        SingleObservation observation = new SingleObservation(new ObservationIdentifier(token.getBytes()), this.registration.getId(), request.getPath(), request.getContentFormat(), request.getContext(), Collections.emptyMap());
        TransportContext extendedContext = TransportContext.EMPTY.with(LwM2mKeys.LESHAN_OBSERVATION, (Object)observation).with(LwM2mKeys.LESHAN_REGISTRATION, (Object)this.registration);
        this.coapRequestBuilder.context(extendedContext).token(token);
    }

    public void visit(CancelObservationRequest request) {
        this.coapRequestBuilder = CoapRequest.observe((String)this.getURI(request.getPath())).token(Opaque.of((byte[])request.getObservation().getId().getBytes())).deregisterObserve();
        this.addDefaultContext(this.coapRequestBuilder);
        if (request.getContentFormat() != null) {
            this.coapRequestBuilder.accept(Short.valueOf((short)request.getContentFormat().getCode()));
        }
    }

    public void visit(ReadCompositeRequest request) {
        this.coapRequestBuilder = CoapRequest.fetch((String)this.getURI(LwM2mPath.ROOTPATH)).contentFormat(Short.valueOf((short)request.getRequestContentFormat().getCode())).payload(Opaque.of((byte[])this.encoder.encodePaths(request.getPaths(), request.getRequestContentFormat())));
        this.addDefaultContext(this.coapRequestBuilder);
        if (request.getResponseContentFormat() != null) {
            this.coapRequestBuilder.accept(Short.valueOf((short)request.getResponseContentFormat().getCode()));
        }
    }

    public void visit(ObserveCompositeRequest request) {
        this.coapRequestBuilder = CoapRequest.fetch((String)this.getURI(LwM2mPath.ROOTPATH)).contentFormat(Short.valueOf((short)request.getRequestContentFormat().getCode())).payload(Opaque.of((byte[])this.encoder.encodePaths(request.getPaths(), request.getRequestContentFormat()))).observe();
        this.addDefaultContext(this.coapRequestBuilder);
        if (request.getResponseContentFormat() != null) {
            this.coapRequestBuilder.accept(Short.valueOf((short)request.getResponseContentFormat().getCode()));
        }
        Opaque token = this.tokenGenerator.createToken();
        CompositeObservation observation = new CompositeObservation(new ObservationIdentifier(token.getBytes()), this.registration.getId(), request.getPaths(), request.getRequestContentFormat(), request.getResponseContentFormat(), request.getContext(), Collections.emptyMap());
        this.coapRequestBuilder.addContext(LwM2mKeys.LESHAN_OBSERVATION, (Object)observation).addContext(LwM2mKeys.LESHAN_REGISTRATION, (Object)this.registration).token(token);
    }

    public void visit(CancelCompositeObservationRequest request) {
        this.coapRequestBuilder = CoapRequest.fetch((String)this.getURI(LwM2mPath.ROOTPATH)).token(Opaque.of((byte[])request.getObservation().getId().getBytes())).contentFormat(Short.valueOf((short)request.getRequestContentFormat().getCode())).payload(Opaque.of((byte[])this.encoder.encodePaths(request.getPaths(), request.getRequestContentFormat()))).deregisterObserve();
        this.addDefaultContext(this.coapRequestBuilder);
        if (request.getResponseContentFormat() != null) {
            this.coapRequestBuilder.accept(Short.valueOf((short)request.getResponseContentFormat().getCode()));
        }
    }

    public void visit(WriteCompositeRequest request) {
        this.coapRequestBuilder = CoapRequest.iPatch((String)this.getURI(LwM2mPath.ROOTPATH)).contentFormat(Short.valueOf((short)request.getContentFormat().getCode())).payload(Opaque.of((byte[])this.encoder.encodeNodes(request.getNodes(), request.getContentFormat(), this.model)));
        this.addDefaultContext(this.coapRequestBuilder);
    }

    public void visit(BootstrapWriteRequest request) {
        this.coapRequestBuilder = CoapRequest.put((String)this.getURI(request.getPath()));
        this.addDefaultContext(this.coapRequestBuilder);
        ContentFormat format = request.getContentFormat();
        this.coapRequestBuilder.contentFormat(Short.valueOf((short)format.getCode())).payload(Opaque.of((byte[])this.encoder.encode((LwM2mNode)request.getNode(), format, request.getPath(), this.model)));
    }

    public void visit(BootstrapReadRequest request) {
        this.coapRequestBuilder = CoapRequest.get((String)this.getURI(request.getPath()));
        this.addDefaultContext(this.coapRequestBuilder);
        if (request.getContentFormat() != null) {
            this.coapRequestBuilder.accept(Short.valueOf((short)request.getContentFormat().getCode()));
        }
    }

    public void visit(BootstrapDiscoverRequest request) {
        this.coapRequestBuilder = CoapRequest.get((String)this.getURI(request.getPath())).accept(Short.valueOf((short)40));
        this.addDefaultContext(this.coapRequestBuilder);
    }

    public void visit(BootstrapDeleteRequest request) {
        this.coapRequestBuilder = CoapRequest.delete((String)this.getURI(request.getPath()));
        this.addDefaultContext(this.coapRequestBuilder);
    }

    public void visit(BootstrapFinishRequest request) {
        this.coapRequestBuilder = CoapRequest.post((String)"bs");
        this.addDefaultContext(this.coapRequestBuilder);
    }

    protected InetSocketAddress getAddress() {
        if (this.destination instanceof IpPeer) {
            return ((IpPeer)this.destination).getSocketAddress();
        }
        throw new IllegalStateException(String.format("Unsupported Peer : %s", this.destination));
    }

    protected String getURI(LwM2mPath path) {
        if (path instanceof LwM2mIncompletePath) {
            throw new IllegalStateException("Incomplete path can not be used to create request");
        }
        StringBuilder uri = new StringBuilder();
        if (this.rootPath != null && !"/".equals(this.rootPath)) {
            uri.append(this.rootPath);
        }
        uri.append(path.toString());
        return uri.toString();
    }

    public CoapRequest getRequest() {
        this.coapRequestBuilder.address(this.getAddress());
        return this.coapRequestBuilder.build();
    }

    public void addDefaultContext(CoapRequest.Builder builder) {
        builder.context(this.identityHandler.createTransportContext(this.destination, false));
    }
}

