/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.transport.javacoap.server.request;

import com.mbed.coap.packet.CoapRequest;
import com.mbed.coap.packet.CoapResponse;
import com.mbed.coap.packet.Code;
import java.util.List;
import java.util.Map;
import org.eclipse.leshan.core.ResponseCode;
import org.eclipse.leshan.core.link.LinkParseException;
import org.eclipse.leshan.core.link.lwm2m.LwM2mLink;
import org.eclipse.leshan.core.link.lwm2m.LwM2mLinkParser;
import org.eclipse.leshan.core.model.LwM2mModel;
import org.eclipse.leshan.core.node.LwM2mNode;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.core.node.TimestampedLwM2mNode;
import org.eclipse.leshan.core.node.codec.CodecException;
import org.eclipse.leshan.core.node.codec.LwM2mDecoder;
import org.eclipse.leshan.core.observation.CompositeObservation;
import org.eclipse.leshan.core.observation.Observation;
import org.eclipse.leshan.core.observation.SingleObservation;
import org.eclipse.leshan.core.request.BootstrapDeleteRequest;
import org.eclipse.leshan.core.request.BootstrapDiscoverRequest;
import org.eclipse.leshan.core.request.BootstrapFinishRequest;
import org.eclipse.leshan.core.request.BootstrapReadRequest;
import org.eclipse.leshan.core.request.BootstrapWriteRequest;
import org.eclipse.leshan.core.request.CancelCompositeObservationRequest;
import org.eclipse.leshan.core.request.CancelObservationRequest;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.request.CreateRequest;
import org.eclipse.leshan.core.request.DeleteRequest;
import org.eclipse.leshan.core.request.DiscoverRequest;
import org.eclipse.leshan.core.request.DownlinkRequestVisitor;
import org.eclipse.leshan.core.request.ExecuteRequest;
import org.eclipse.leshan.core.request.LwM2mRequest;
import org.eclipse.leshan.core.request.ObserveCompositeRequest;
import org.eclipse.leshan.core.request.ObserveRequest;
import org.eclipse.leshan.core.request.ReadCompositeRequest;
import org.eclipse.leshan.core.request.ReadRequest;
import org.eclipse.leshan.core.request.WriteAttributesRequest;
import org.eclipse.leshan.core.request.WriteCompositeRequest;
import org.eclipse.leshan.core.request.WriteRequest;
import org.eclipse.leshan.core.request.exception.InvalidResponseException;
import org.eclipse.leshan.core.response.BootstrapDeleteResponse;
import org.eclipse.leshan.core.response.BootstrapDiscoverResponse;
import org.eclipse.leshan.core.response.BootstrapFinishResponse;
import org.eclipse.leshan.core.response.BootstrapReadResponse;
import org.eclipse.leshan.core.response.BootstrapWriteResponse;
import org.eclipse.leshan.core.response.CancelCompositeObservationResponse;
import org.eclipse.leshan.core.response.CancelObservationResponse;
import org.eclipse.leshan.core.response.CreateResponse;
import org.eclipse.leshan.core.response.DeleteResponse;
import org.eclipse.leshan.core.response.DiscoverResponse;
import org.eclipse.leshan.core.response.ExecuteResponse;
import org.eclipse.leshan.core.response.LwM2mResponse;
import org.eclipse.leshan.core.response.ObserveCompositeResponse;
import org.eclipse.leshan.core.response.ObserveResponse;
import org.eclipse.leshan.core.response.ReadCompositeResponse;
import org.eclipse.leshan.core.response.ReadResponse;
import org.eclipse.leshan.core.response.WriteAttributesResponse;
import org.eclipse.leshan.core.response.WriteCompositeResponse;
import org.eclipse.leshan.core.response.WriteResponse;
import org.eclipse.leshan.core.util.Hex;
import org.eclipse.leshan.transport.javacoap.request.ResponseCodeUtil;
import org.eclipse.leshan.transport.javacoap.server.observation.LwM2mKeys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LwM2mResponseBuilder<T extends LwM2mResponse>
implements DownlinkRequestVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(LwM2mResponseBuilder.class);
    private LwM2mResponse lwM2mresponse;
    private final CoapResponse coapResponse;
    private final CoapRequest coapRequest;
    private final String clientEndpoint;
    private final LwM2mModel model;
    private final LwM2mDecoder decoder;
    private final LwM2mLinkParser linkParser;

    public LwM2mResponseBuilder(CoapResponse coapResponse, CoapRequest coapRequest, String clientEndpoint, LwM2mModel model, LwM2mDecoder decoder, LwM2mLinkParser linkParser) {
        this.coapResponse = coapResponse;
        this.coapRequest = coapRequest;
        this.clientEndpoint = clientEndpoint;
        this.model = model;
        this.decoder = decoder;
        this.linkParser = linkParser;
    }

    public void visit(ReadRequest request) {
        if (this.coapResponse.getCode().getHttpCode() >= 400) {
            this.lwM2mresponse = new ReadResponse(LwM2mResponseBuilder.toLwM2mResponseCode(this.coapResponse.getCode()), null, null, this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeContent()) {
            TimestampedLwM2mNode timestampedNode = this.decodeCoapTimestampedResponse(request.getPath(), this.coapResponse, (LwM2mRequest<?>)request, this.clientEndpoint);
            this.lwM2mresponse = new ReadResponse(ResponseCode.CONTENT, null, timestampedNode, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(DiscoverRequest request) {
        if (this.coapResponse.getCode().getHttpCode() >= 400) {
            this.lwM2mresponse = new DiscoverResponse(LwM2mResponseBuilder.toLwM2mResponseCode(this.coapResponse.getCode()), null, this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeContent()) {
            LwM2mLink[] links;
            if (40 != this.coapResponse.options().getContentFormat()) {
                throw new InvalidResponseException("Client [%s] returned unexpected content format [%s] for [%s]", new Object[]{this.clientEndpoint, this.coapResponse.options().getContentFormat(), request});
            }
            try {
                String rootpath = null;
                links = this.linkParser.parseLwM2mLinkFromCoreLinkFormat(this.coapResponse.getPayload().getBytes(), rootpath);
            }
            catch (LinkParseException e) {
                throw new InvalidResponseException((Throwable)e, "Unable to decode response payload of request [%s] from client [%s]", new Object[]{request, this.clientEndpoint});
            }
            this.lwM2mresponse = new DiscoverResponse(ResponseCode.CONTENT, links, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(WriteRequest request) {
        if (this.coapResponse.getCode().getHttpCode() >= 400) {
            this.lwM2mresponse = new WriteResponse(LwM2mResponseBuilder.toLwM2mResponseCode(this.coapResponse.getCode()), this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeChanged()) {
            this.lwM2mresponse = new WriteResponse(ResponseCode.CHANGED, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(WriteAttributesRequest request) {
        if (this.coapResponse.getCode().getHttpCode() >= 400) {
            this.lwM2mresponse = new WriteAttributesResponse(LwM2mResponseBuilder.toLwM2mResponseCode(this.coapResponse.getCode()), this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeChanged()) {
            this.lwM2mresponse = new WriteAttributesResponse(ResponseCode.CHANGED, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(ExecuteRequest request) {
        if (this.coapResponse.getCode().getHttpCode() >= 400) {
            this.lwM2mresponse = new ExecuteResponse(LwM2mResponseBuilder.toLwM2mResponseCode(this.coapResponse.getCode()), this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeChanged()) {
            this.lwM2mresponse = new ExecuteResponse(ResponseCode.CHANGED, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(CreateRequest request) {
        if (this.coapResponse.getCode().getHttpCode() >= 400) {
            this.lwM2mresponse = new CreateResponse(LwM2mResponseBuilder.toLwM2mResponseCode(this.coapResponse.getCode()), null, this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.coapResponse.getCode() == Code.C201_CREATED) {
            String locationPath = this.coapResponse.options().getLocationPath();
            if (locationPath == null || locationPath.equals("/")) {
                locationPath = null;
            } else if (locationPath.startsWith("/")) {
                locationPath = locationPath.substring(1);
            }
            this.lwM2mresponse = new CreateResponse(ResponseCode.CREATED, locationPath, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(DeleteRequest request) {
        if (this.coapResponse.getCode().getHttpCode() >= 400) {
            this.lwM2mresponse = new DeleteResponse(LwM2mResponseBuilder.toLwM2mResponseCode(this.coapResponse.getCode()), this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.coapResponse.getCode() == Code.C202_DELETED) {
            this.lwM2mresponse = new DeleteResponse(ResponseCode.DELETED, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visit(ObserveRequest request) {
        if (this.coapResponse.getCode().getHttpCode() >= 400) {
            this.lwM2mresponse = new ObserveResponse(LwM2mResponseBuilder.toLwM2mResponseCode(this.coapResponse.getCode()), null, null, null, null, this.coapResponse.getPayloadString(), (Object)this.coapResponse);
            return;
        } else if (this.isResponseCodeContent() || this.isResponseCodeChanged()) {
            TimestampedLwM2mNode timestampedNode = this.decodeCoapTimestampedResponse(request.getPath(), this.coapResponse, (LwM2mRequest<?>)request, this.clientEndpoint);
            if (this.coapResponse.options().getObserve() != null) {
                Observation observation = (Observation)this.coapRequest.getTransContext().get(LwM2mKeys.LESHAN_OBSERVATION);
                if (!(observation instanceof SingleObservation)) throw new IllegalStateException(String.format("A Single Observation is expected in coapRequest transport Context, but was %s", observation == null ? "null" : observation.getClass().getSimpleName()));
                this.lwM2mresponse = new ObserveResponse(LwM2mResponseBuilder.toLwM2mResponseCode(this.coapResponse.getCode()), null, timestampedNode, null, (SingleObservation)observation, null, (Object)this.coapResponse);
                return;
            } else {
                this.lwM2mresponse = new ObserveResponse(LwM2mResponseBuilder.toLwM2mResponseCode(this.coapResponse.getCode()), null, timestampedNode, null, null, null, (Object)this.coapResponse);
            }
            return;
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(CancelObservationRequest request) {
        if (this.coapResponse.getCode().getHttpCode() >= 400) {
            this.lwM2mresponse = new CancelObservationResponse(LwM2mResponseBuilder.toLwM2mResponseCode(this.coapResponse.getCode()), null, null, null, null, this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeContent() || this.isResponseCodeChanged()) {
            TimestampedLwM2mNode timestampedNode = this.decodeCoapTimestampedResponse(request.getPath(), this.coapResponse, (LwM2mRequest<?>)request, this.clientEndpoint);
            this.lwM2mresponse = new CancelObservationResponse(LwM2mResponseBuilder.toLwM2mResponseCode(this.coapResponse.getCode()), null, timestampedNode, null, null, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(ReadCompositeRequest request) {
        if (this.coapResponse.getCode().getHttpCode() >= 400) {
            this.lwM2mresponse = new ReadCompositeResponse(LwM2mResponseBuilder.toLwM2mResponseCode(this.coapResponse.getCode()), null, this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeContent()) {
            Map<LwM2mPath, LwM2mNode> content = this.decodeCompositeCoapResponse(request.getPaths(), this.coapResponse, (LwM2mRequest<?>)request, this.clientEndpoint);
            this.lwM2mresponse = new ReadCompositeResponse(ResponseCode.CONTENT, content, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visit(ObserveCompositeRequest request) {
        if (this.coapResponse.getCode().getHttpCode() >= 400) {
            this.lwM2mresponse = new ObserveCompositeResponse(LwM2mResponseBuilder.toLwM2mResponseCode(this.coapResponse.getCode()), null, null, null, this.coapResponse.getPayloadString(), (Object)this.coapResponse);
            return;
        } else if (this.isResponseCodeContent()) {
            Map<LwM2mPath, LwM2mNode> content = this.decodeCompositeCoapResponse(request.getPaths(), this.coapResponse, (LwM2mRequest<?>)request, this.clientEndpoint);
            if (this.coapResponse.options().getObserve() != null) {
                Observation observation = (Observation)this.coapRequest.getTransContext().get(LwM2mKeys.LESHAN_OBSERVATION);
                if (!(observation instanceof CompositeObservation)) throw new IllegalStateException(String.format("A Composite Observation is expected in coapRequest transport Context, but was %s", observation == null ? "null" : observation.getClass().getSimpleName()));
                this.lwM2mresponse = new ObserveCompositeResponse(LwM2mResponseBuilder.toLwM2mResponseCode(this.coapResponse.getCode()), content, null, (CompositeObservation)observation, null, (Object)this.coapResponse);
                return;
            } else {
                this.lwM2mresponse = new ObserveCompositeResponse(LwM2mResponseBuilder.toLwM2mResponseCode(this.coapResponse.getCode()), content, null, null, null, (Object)this.coapResponse);
            }
            return;
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(CancelCompositeObservationRequest request) {
        if (this.coapResponse.getCode().getHttpCode() >= 400) {
            this.lwM2mresponse = new CancelCompositeObservationResponse(LwM2mResponseBuilder.toLwM2mResponseCode(this.coapResponse.getCode()), null, null, null, this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeContent() || this.isResponseCodeChanged()) {
            Map<LwM2mPath, LwM2mNode> content = this.decodeCompositeCoapResponse(request.getPaths(), this.coapResponse, (LwM2mRequest<?>)request, this.clientEndpoint);
            this.lwM2mresponse = new CancelCompositeObservationResponse(LwM2mResponseBuilder.toLwM2mResponseCode(this.coapResponse.getCode()), content, null, null, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(WriteCompositeRequest request) {
        if (this.coapResponse.getCode().getHttpCode() >= 400) {
            this.lwM2mresponse = new WriteCompositeResponse(LwM2mResponseBuilder.toLwM2mResponseCode(this.coapResponse.getCode()), this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeChanged()) {
            this.lwM2mresponse = new WriteCompositeResponse(ResponseCode.CHANGED, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(BootstrapDiscoverRequest request) {
        if (this.coapResponse.getCode().getHttpCode() >= 400) {
            this.lwM2mresponse = new BootstrapDiscoverResponse(LwM2mResponseBuilder.toLwM2mResponseCode(this.coapResponse.getCode()), null, this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeContent()) {
            LwM2mLink[] links;
            if (40 != this.coapResponse.options().getContentFormat()) {
                throw new InvalidResponseException("Client [%s] returned unexpected content format [%s] for [%s]", new Object[]{this.clientEndpoint, this.coapResponse.options().getContentFormat(), request});
            }
            try {
                links = this.linkParser.parseLwM2mLinkFromCoreLinkFormat(this.coapResponse.getPayload().getBytes(), null);
            }
            catch (LinkParseException e) {
                throw new InvalidResponseException((Throwable)e, "Unable to decode response payload of request [%s] from client [%s]", new Object[]{request, this.clientEndpoint});
            }
            this.lwM2mresponse = new BootstrapDiscoverResponse(ResponseCode.CONTENT, links, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(BootstrapWriteRequest request) {
        if (this.coapResponse.getCode().getHttpCode() >= 400) {
            this.lwM2mresponse = new BootstrapWriteResponse(LwM2mResponseBuilder.toLwM2mResponseCode(this.coapResponse.getCode()), this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeChanged()) {
            this.lwM2mresponse = new BootstrapWriteResponse(ResponseCode.CHANGED, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(BootstrapReadRequest request) {
        if (this.coapResponse.getCode().getHttpCode() >= 400) {
            this.lwM2mresponse = new BootstrapReadResponse(LwM2mResponseBuilder.toLwM2mResponseCode(this.coapResponse.getCode()), null, this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeContent()) {
            LwM2mNode content = this.decodeCoapResponse(request.getPath(), this.coapResponse, (LwM2mRequest<?>)request, this.clientEndpoint);
            this.lwM2mresponse = new BootstrapReadResponse(ResponseCode.CONTENT, content, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(BootstrapDeleteRequest request) {
        if (this.coapResponse.getCode().getHttpCode() >= 400) {
            this.lwM2mresponse = new BootstrapDeleteResponse(LwM2mResponseBuilder.toLwM2mResponseCode(this.coapResponse.getCode()), this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.coapResponse.getCode() == Code.C202_DELETED) {
            this.lwM2mresponse = new BootstrapDeleteResponse(ResponseCode.DELETED, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(BootstrapFinishRequest request) {
        if (this.coapResponse.getCode().getHttpCode() >= 400) {
            this.lwM2mresponse = new BootstrapFinishResponse(LwM2mResponseBuilder.toLwM2mResponseCode(this.coapResponse.getCode()), this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeChanged()) {
            this.lwM2mresponse = new BootstrapFinishResponse(ResponseCode.CHANGED, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    private boolean isResponseCodeContent() {
        return this.coapResponse.getCode() == Code.C205_CONTENT;
    }

    private boolean isResponseCodeChanged() {
        return this.coapResponse.getCode() == Code.C204_CHANGED;
    }

    public static ResponseCode toLwM2mResponseCode(Code coapResponseCode) {
        return ResponseCodeUtil.toLwM2mResponseCode((Code)coapResponseCode);
    }

    private LwM2mNode decodeCoapResponse(LwM2mPath path, CoapResponse coapResponse, LwM2mRequest<?> request, String endpoint) {
        try {
            return this.decoder.decode(coapResponse.getPayload().getBytes(), this.getContentFormat(coapResponse), path, this.model);
        }
        catch (CodecException e) {
            this.handleCodecException(e, request, coapResponse, endpoint);
            return null;
        }
    }

    private Map<LwM2mPath, LwM2mNode> decodeCompositeCoapResponse(List<LwM2mPath> paths, CoapResponse coapResponse, LwM2mRequest<?> request, String endpoint) {
        try {
            return this.decoder.decodeNodes(coapResponse.getPayload().getBytes(), this.getContentFormat(coapResponse), paths, this.model);
        }
        catch (CodecException e) {
            this.handleCodecException(e, request, coapResponse, endpoint);
            return null;
        }
    }

    private TimestampedLwM2mNode decodeCoapTimestampedResponse(LwM2mPath path, CoapResponse coapResponse, LwM2mRequest<?> request, String endpoint) {
        List timestampedNodes = null;
        try {
            timestampedNodes = this.decoder.decodeTimestampedData(coapResponse.getPayload().getBytes(), this.getContentFormat(coapResponse), path, this.model);
            if (timestampedNodes.size() != 1) {
                throw new InvalidResponseException("Unable to decode response payload of request [%s] from client [%s] : should receive only 1 timestamped node but received %s", new Object[]{request, endpoint, timestampedNodes.size()});
            }
            return (TimestampedLwM2mNode)timestampedNodes.get(0);
        }
        catch (CodecException e) {
            this.handleCodecException(e, request, coapResponse, endpoint);
            return null;
        }
    }

    private ContentFormat getContentFormat(CoapResponse coapResponse) {
        ContentFormat contentFormat = null;
        if (coapResponse.options().getContentFormat() != null) {
            contentFormat = ContentFormat.fromCode((int)coapResponse.options().getContentFormat().shortValue());
        }
        return contentFormat;
    }

    private void handleCodecException(CodecException e, LwM2mRequest<?> request, CoapResponse coapResponse, String endpoint) {
        if (LOG.isDebugEnabled()) {
            byte[] payload = coapResponse.getPayload() == null ? new byte[]{} : coapResponse.getPayload().getBytes();
            LOG.debug(String.format("Unable to decode response payload of request [%s] from client [%s] [payload:%s]", request, endpoint, Hex.encodeHexString((byte[])payload)));
        }
        throw new InvalidResponseException((Throwable)e, "Unable to decode response payload of request [%s] from client [%s]", new Object[]{request, endpoint});
    }

    public T getResponse() {
        return (T)this.lwM2mresponse;
    }

    private void handleUnexpectedResponseCode(String clientEndpoint, LwM2mRequest<?> request, CoapResponse coapResponse) {
        throw new InvalidResponseException("Client [%s] returned unexpected response code [%s] for [%s]", new Object[]{clientEndpoint, coapResponse.getCode(), request});
    }
}

