/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.transport.javacoap.server.resource;

import com.mbed.coap.packet.CoapRequest;
import com.mbed.coap.packet.CoapResponse;
import com.mbed.coap.packet.Code;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.leshan.core.ResponseCode;
import org.eclipse.leshan.core.link.Link;
import org.eclipse.leshan.core.link.LinkParseException;
import org.eclipse.leshan.core.link.LinkParser;
import org.eclipse.leshan.core.peer.IpPeer;
import org.eclipse.leshan.core.peer.LwM2mPeer;
import org.eclipse.leshan.core.request.BindingMode;
import org.eclipse.leshan.core.request.DeregisterRequest;
import org.eclipse.leshan.core.request.RegisterRequest;
import org.eclipse.leshan.core.request.UpdateRequest;
import org.eclipse.leshan.core.request.UplinkRequest;
import org.eclipse.leshan.core.response.DeregisterResponse;
import org.eclipse.leshan.core.response.RegisterResponse;
import org.eclipse.leshan.core.response.SendableResponse;
import org.eclipse.leshan.core.response.UpdateResponse;
import org.eclipse.leshan.server.request.UplinkRequestReceiver;
import org.eclipse.leshan.transport.javacoap.identity.IdentityHandler;
import org.eclipse.leshan.transport.javacoap.request.ResponseCodeUtil;
import org.eclipse.leshan.transport.javacoap.resource.LwM2mCoapResource;
import org.eclipse.leshan.transport.javacoap.server.endpoint.EndpointUriProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistrationResource
extends LwM2mCoapResource {
    private static final Logger LOG = LoggerFactory.getLogger(RegistrationResource.class);
    private static final String QUERY_PARAM_ENDPOINT = "ep";
    private static final String QUERY_PARAM_BINDING_MODE = "b";
    private static final String QUERY_PARAM_LWM2M_VERSION = "lwm2m";
    private static final String QUERY_PARAM_SMS = "sms";
    private static final String QUERY_PARAM_LIFETIME = "lt";
    private static final String QUERY_PARAM_QUEUEMMODE = "Q";
    public static final String RESOURCE_NAME = "rd";
    public static final String RESOURCE_URI = "/rd/*";
    private final UplinkRequestReceiver receiver;
    private final LinkParser linkParser;
    private final EndpointUriProvider endpointUriProvider;

    public RegistrationResource(UplinkRequestReceiver receiver, LinkParser linkParser, EndpointUriProvider endpointUriProvider, IdentityHandler identityHandler) {
        super(RESOURCE_URI, identityHandler);
        this.receiver = receiver;
        this.linkParser = linkParser;
        this.endpointUriProvider = endpointUriProvider;
    }

    public CompletableFuture<CoapResponse> handlePOST(CoapRequest coapRequest) {
        LOG.trace("POST received : {}", (Object)coapRequest);
        List uri = this.getUriPart(coapRequest);
        if (uri == null || uri.size() == 0 || !RESOURCE_NAME.equals(uri.get(0))) {
            return this.handleInvalidRequest(coapRequest, "Bad URI");
        }
        if (uri.size() == 1) {
            return this.handleRegister(coapRequest);
        }
        if (uri.size() == 2) {
            return this.handleUpdate(coapRequest, (String)uri.get(1));
        }
        return this.handleInvalidRequest(coapRequest, "Bad URI");
    }

    public CompletableFuture<CoapResponse> handleDELETE(CoapRequest coapRequest) {
        LOG.trace("DELETE received : {}", (Object)coapRequest);
        List uri = this.getUriPart(coapRequest);
        if (uri != null && uri.size() == 2 && RESOURCE_NAME.equals(uri.get(0))) {
            return this.handleDeregister(coapRequest, (String)uri.get(1));
        }
        return this.handleInvalidRequest(coapRequest, "Bad URI");
    }

    protected CompletableFuture<CoapResponse> handleRegister(CoapRequest coapRequest) {
        Link[] objectLinks;
        IpPeer sender = this.getForeignPeerIdentity(coapRequest);
        String endpoint = null;
        Long lifetime = null;
        String smsNumber = null;
        String lwVersion = null;
        EnumSet binding = null;
        Boolean queueMode = null;
        try {
            objectLinks = this.linkParser.parseCoreLinkFormat(coapRequest.getPayload().getBytes());
        }
        catch (LinkParseException e) {
            return this.handleInvalidRequest(coapRequest, e.getMessage() != null ? e.getMessage() : "Invalid Links", e);
        }
        HashMap<String, String> additionalParams = new HashMap<String, String>();
        try {
            for (Map.Entry entry : coapRequest.options().getUriQueryMap().entrySet()) {
                if (((String)entry.getKey()).equals(QUERY_PARAM_ENDPOINT)) {
                    endpoint = (String)entry.getValue();
                    continue;
                }
                if (((String)entry.getKey()).equals(QUERY_PARAM_LIFETIME)) {
                    lifetime = Long.valueOf((String)entry.getValue());
                    continue;
                }
                if (((String)entry.getKey()).equals(QUERY_PARAM_SMS)) {
                    smsNumber = (String)entry.getValue();
                    continue;
                }
                if (((String)entry.getKey()).equals(QUERY_PARAM_LWM2M_VERSION)) {
                    lwVersion = (String)entry.getValue();
                    continue;
                }
                if (((String)entry.getKey()).equals(QUERY_PARAM_BINDING_MODE)) {
                    binding = BindingMode.parse((String)((String)entry.getValue()));
                    continue;
                }
                if (((String)entry.getKey()).equals(QUERY_PARAM_QUEUEMMODE)) {
                    queueMode = true;
                    continue;
                }
                additionalParams.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (IllegalArgumentException e) {
            return this.handleInvalidRequest(coapRequest, e.getMessage() != null ? e.getMessage() : "Uri Query", e);
        }
        RegisterRequest registerRequest = new RegisterRequest(endpoint, lifetime, lwVersion, binding, queueMode, smsNumber, objectLinks, additionalParams, (Object)coapRequest);
        SendableResponse sendableResponse = this.receiver.requestReceived((LwM2mPeer)sender, null, (UplinkRequest)registerRequest, this.endpointUriProvider.getEndpointUri());
        RegisterResponse response = (RegisterResponse)sendableResponse.getResponse();
        sendableResponse.sent();
        if (response.getCode() == ResponseCode.CREATED) {
            CoapResponse coapResponse = CoapResponse.of((Code)Code.C201_CREATED);
            coapResponse.options().setLocationPath("rd/" + response.getRegistrationID());
            return CompletableFuture.completedFuture(coapResponse);
        }
        return this.errorMessage(response.getCode(), response.getErrorMessage());
    }

    protected CompletableFuture<CoapResponse> handleUpdate(CoapRequest coapRequest, String registrationId) {
        IpPeer sender = this.getForeignPeerIdentity(coapRequest);
        Long lifetime = null;
        String smsNumber = null;
        EnumSet binding = null;
        Link[] objectLinks = null;
        HashMap<String, String> additionalParams = new HashMap<String, String>();
        try {
            for (Map.Entry entry : coapRequest.options().getUriQueryMap().entrySet()) {
                if (((String)entry.getKey()).equals(QUERY_PARAM_LIFETIME)) {
                    lifetime = Long.valueOf((String)entry.getValue());
                    continue;
                }
                if (((String)entry.getKey()).equals(QUERY_PARAM_SMS)) {
                    smsNumber = (String)entry.getValue();
                    continue;
                }
                if (((String)entry.getKey()).equals(QUERY_PARAM_BINDING_MODE)) {
                    binding = BindingMode.parse((String)((String)entry.getValue()));
                    continue;
                }
                additionalParams.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (IllegalArgumentException e) {
            return this.handleInvalidRequest(coapRequest, e.getMessage() != null ? e.getMessage() : "Uri Query", e);
        }
        if (coapRequest.getPayload() != null && coapRequest.getPayload().size() > 0) {
            try {
                objectLinks = this.linkParser.parseCoreLinkFormat(coapRequest.getPayload().getBytes());
            }
            catch (LinkParseException e) {
                return this.handleInvalidRequest(coapRequest, e.getMessage() != null ? e.getMessage() : "Invalid Links", e);
            }
        }
        UpdateRequest updateRequest = new UpdateRequest(registrationId, lifetime, smsNumber, binding, objectLinks, additionalParams, (Object)coapRequest);
        SendableResponse sendableResponse = this.receiver.requestReceived((LwM2mPeer)sender, null, (UplinkRequest)updateRequest, this.endpointUriProvider.getEndpointUri());
        UpdateResponse updateResponse = (UpdateResponse)sendableResponse.getResponse();
        sendableResponse.sent();
        if (updateResponse.getCode().isError()) {
            return this.errorMessage(updateResponse.getCode(), updateResponse.getErrorMessage());
        }
        return CompletableFuture.completedFuture(CoapResponse.of((Code)ResponseCodeUtil.toCoapResponseCode((ResponseCode)updateResponse.getCode())));
    }

    protected CompletableFuture<CoapResponse> handleDeregister(CoapRequest coapRequest, String registrationId) {
        IpPeer sender = this.getForeignPeerIdentity(coapRequest);
        DeregisterRequest deregisterRequest = new DeregisterRequest(registrationId, (Object)coapRequest);
        SendableResponse sendableResponse = this.receiver.requestReceived((LwM2mPeer)sender, null, (UplinkRequest)deregisterRequest, this.endpointUriProvider.getEndpointUri());
        DeregisterResponse deregisterResponse = (DeregisterResponse)sendableResponse.getResponse();
        sendableResponse.sent();
        if (deregisterResponse.getCode().isError()) {
            return this.errorMessage(deregisterResponse.getCode(), deregisterResponse.getErrorMessage());
        }
        return CompletableFuture.completedFuture(CoapResponse.of((Code)ResponseCodeUtil.toCoapResponseCode((ResponseCode)deregisterResponse.getCode())));
    }
}

