/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.transport.javacoap.server.resource;

import com.mbed.coap.packet.CoapRequest;
import com.mbed.coap.packet.CoapResponse;
import com.mbed.coap.packet.Code;
import java.util.concurrent.CompletableFuture;
import org.eclipse.leshan.core.ResponseCode;
import org.eclipse.leshan.core.node.TimestampedLwM2mNodes;
import org.eclipse.leshan.core.node.codec.CodecException;
import org.eclipse.leshan.core.node.codec.LwM2mDecoder;
import org.eclipse.leshan.core.peer.IpPeer;
import org.eclipse.leshan.core.peer.LwM2mPeer;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.request.SendRequest;
import org.eclipse.leshan.core.request.UplinkRequest;
import org.eclipse.leshan.core.request.exception.InvalidRequestException;
import org.eclipse.leshan.core.response.SendResponse;
import org.eclipse.leshan.core.response.SendableResponse;
import org.eclipse.leshan.server.profile.ClientProfile;
import org.eclipse.leshan.server.profile.ClientProfileProvider;
import org.eclipse.leshan.server.request.UplinkRequestReceiver;
import org.eclipse.leshan.transport.javacoap.identity.IdentityHandler;
import org.eclipse.leshan.transport.javacoap.request.ResponseCodeUtil;
import org.eclipse.leshan.transport.javacoap.resource.LwM2mCoapResource;
import org.eclipse.leshan.transport.javacoap.server.endpoint.EndpointUriProvider;

public class SendResource
extends LwM2mCoapResource {
    public static final String RESOURCE_NAME = "dp";
    public static final String RESOURCE_URI = "/dp/*";
    private final LwM2mDecoder decoder;
    private final UplinkRequestReceiver receiver;
    private final ClientProfileProvider profileProvider;
    private final EndpointUriProvider endpointUriProvider;

    public SendResource(UplinkRequestReceiver receiver, LwM2mDecoder decoder, ClientProfileProvider profileProvider, EndpointUriProvider endpointUriProvider, IdentityHandler identityHandler) {
        super(RESOURCE_URI, identityHandler);
        this.decoder = decoder;
        this.receiver = receiver;
        this.profileProvider = profileProvider;
        this.endpointUriProvider = endpointUriProvider;
    }

    public CompletableFuture<CoapResponse> handlePOST(CoapRequest coapRequest) {
        IpPeer sender = this.getForeignPeerIdentity(coapRequest);
        ClientProfile clientProfile = this.profileProvider.getProfile(sender.getIdentity());
        if (clientProfile == null) {
            return this.errorMessage(ResponseCode.BAD_REQUEST, "no registration found");
        }
        try {
            byte[] payload = coapRequest.getPayload().getBytes();
            ContentFormat contentFormat = ContentFormat.fromCode((int)coapRequest.options().getContentFormat().shortValue());
            if (!this.decoder.isSupported(contentFormat)) {
                this.receiver.onError((LwM2mPeer)sender, clientProfile, (Exception)new InvalidRequestException("Unsupported content format [%s] in [%s] from [%s]", new Object[]{contentFormat, coapRequest, sender}), SendRequest.class, this.endpointUriProvider.getEndpointUri());
                return this.errorMessage(ResponseCode.BAD_REQUEST, "Unsupported content format");
            }
            TimestampedLwM2mNodes data = this.decoder.decodeTimestampedNodes(payload, contentFormat, null, clientProfile.getModel());
            SendRequest sendRequest = new SendRequest(contentFormat, data, (Object)coapRequest);
            SendableResponse sendableResponse = this.receiver.requestReceived((LwM2mPeer)sender, clientProfile, (UplinkRequest)sendRequest, this.endpointUriProvider.getEndpointUri());
            SendResponse response = (SendResponse)sendableResponse.getResponse();
            sendableResponse.sent();
            if (response.isSuccess()) {
                return CompletableFuture.completedFuture(CoapResponse.of((Code)ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode())));
            }
            return this.errorMessage(response.getCode(), response.getErrorMessage());
        }
        catch (CodecException e) {
            this.receiver.onError((LwM2mPeer)sender, clientProfile, (Exception)new InvalidRequestException((Throwable)e, "Invalid payload in [%s] from [%s]", new Object[]{coapRequest, sender}), SendRequest.class, this.endpointUriProvider.getEndpointUri());
            return this.errorMessage(ResponseCode.BAD_REQUEST, "Invalid Payload");
        }
        catch (RuntimeException e) {
            this.receiver.onError((LwM2mPeer)sender, clientProfile, (Exception)e, SendRequest.class, this.endpointUriProvider.getEndpointUri());
            throw e;
        }
    }
}

