/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.io.IOException;
import java.util.Vector;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.trace.Trace;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubComp;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;

public class CommsCallback
implements Runnable {
    private static int INBOUND_QUEUE_SIZE = 10;
    private MqttCallback mqttCallback;
    private ClientComms clientComms;
    private Vector messageQueue;
    private Vector completeQueue;
    private boolean running = false;
    private boolean quiescing = false;
    private Object lifecycle = new Object();
    private Thread callbackThread;
    private Object workAvailable = new Object();
    private Object spaceAvailable = new Object();
    private boolean invoking = false;
    private Trace trace;

    CommsCallback(Trace trace, ClientComms clientComms) {
        this.trace = trace;
        this.clientComms = clientComms;
        this.messageQueue = new Vector(INBOUND_QUEUE_SIZE);
        this.completeQueue = new Vector(INBOUND_QUEUE_SIZE);
    }

    public void start() {
        if (!this.running) {
            this.running = true;
            this.quiescing = false;
            this.callbackThread = new Thread((Runnable)this, "MQTT Client Callback");
            this.callbackThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IOException {
        if (this.running) {
            this.trace.trace((byte)1, 700);
            this.running = false;
            if (!Thread.currentThread().equals(this.callbackThread)) {
                try {
                    Object object = this.lifecycle;
                    synchronized (object) {
                        Object object2 = this.workAvailable;
                        synchronized (object2) {
                            this.trace.trace((byte)1, 701);
                            this.workAvailable.notifyAll();
                        }
                        this.trace.trace((byte)1, 702);
                        this.lifecycle.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.trace.trace((byte)1, 703);
        }
    }

    public void setCallback(MqttCallback mqttCallback) {
        this.mqttCallback = mqttCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        while (this.running) {
            try {
                object = this.workAvailable;
                synchronized (object) {
                    if (this.messageQueue.isEmpty() && this.completeQueue.isEmpty()) {
                        this.trace.trace((byte)1, 704);
                        this.workAvailable.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.running) {
                if (!this.completeQueue.isEmpty() && this.mqttCallback != null) {
                    MqttDeliveryToken token = (MqttDeliveryToken)this.completeQueue.elementAt(0);
                    this.completeQueue.removeElementAt(0);
                    if (this.trace.isOn()) {
                        this.trace.trace((byte)1, 705, new Object[]{token});
                    }
                    this.mqttCallback.deliveryComplete(token);
                }
                if (!this.messageQueue.isEmpty()) {
                    if (this.quiescing) {
                        this.messageQueue.clear();
                    } else if (this.clientComms.isConnected()) {
                        this.invoking = true;
                        MqttPublish message = (MqttPublish)this.messageQueue.elementAt(0);
                        this.messageQueue.removeElementAt(0);
                        this.handleMessage(message);
                        this.invoking = false;
                    }
                }
            }
            object = this.spaceAvailable;
            synchronized (object) {
                this.trace.trace((byte)1, 706);
                this.spaceAvailable.notifyAll();
            }
        }
        this.messageQueue.clear();
        object = this.lifecycle;
        synchronized (object) {
            this.trace.trace((byte)1, 707);
            this.lifecycle.notifyAll();
        }
    }

    public void connectionLost(Throwable cause) {
        if (this.mqttCallback != null) {
            this.trace.trace((byte)1, 708, null, cause);
            this.mqttCallback.connectionLost(cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageArrived(MqttPublish sendMessage) {
        if (this.mqttCallback != null) {
            Object object = this.spaceAvailable;
            synchronized (object) {
                if (!this.quiescing && this.messageQueue.size() >= INBOUND_QUEUE_SIZE) {
                    try {
                        this.trace.trace((byte)1, 709);
                        this.spaceAvailable.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (!this.quiescing) {
                this.messageQueue.addElement(sendMessage);
                object = this.workAvailable;
                synchronized (object) {
                    this.trace.trace((byte)1, 710);
                    this.workAvailable.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiesce() {
        this.quiescing = true;
        Object object = this.spaceAvailable;
        synchronized (object) {
            this.trace.trace((byte)1, 711);
            this.spaceAvailable.notifyAll();
        }
        object = this.spaceAvailable;
        synchronized (object) {
            if (this.invoking) {
                try {
                    this.trace.trace((byte)1, 712);
                    this.spaceAvailable.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private void handleMessage(MqttPublish publishMessage) {
        if (this.clientComms.isConnected() && this.mqttCallback != null) {
            try {
                String destName = publishMessage.getTopicName();
                MqttTopic destination = null;
                if (destName != null) {
                    destination = this.clientComms.getTopic(destName);
                }
                if (this.trace.isOn()) {
                    this.trace.trace((byte)1, 713, new Object[]{destination.getName(), new Integer(publishMessage.getMessageId())});
                }
                this.mqttCallback.messageArrived(destination, publishMessage.getMessage());
                if (publishMessage.getMessage().getQos() == 1) {
                    this.clientComms.sendNoWait(new MqttPubAck(publishMessage));
                } else if (publishMessage.getMessage().getQos() == 2) {
                    this.clientComms.deliveryComplete(publishMessage);
                    MqttPubComp pubComp = new MqttPubComp(publishMessage);
                    this.clientComms.sendNoWait(pubComp);
                }
            }
            catch (Exception ex) {
                this.trace.trace((byte)1, 714, null, ex);
                this.clientComms.shutdownConnection(new MqttException(ex));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliveryComplete(MqttDeliveryToken token) {
        if (this.mqttCallback != null) {
            this.completeQueue.addElement(token);
            Object object = this.workAvailable;
            synchronized (object) {
                if (this.trace.isOn()) {
                    this.trace.trace((byte)1, 715, new Object[]{token});
                }
                this.workAvailable.notifyAll();
            }
        }
    }

    protected Thread getThread() {
        return this.callbackThread;
    }
}

