/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.client;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import org.eclipse.paho.mqttv5.client.internal.NetworkModuleService;
import org.eclipse.paho.mqttv5.client.util.Debug;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.eclipse.paho.mqttv5.common.packet.UserProperty;
import org.eclipse.paho.mqttv5.common.util.MqttTopicValidator;

public class MqttConnectionOptions {
    private static final String CLIENT_ID_PREFIX = "paho";
    private String[] serverURIs = null;
    private boolean automaticReconnect = false;
    private int automaticReconnectMinDelay = 1;
    private int automaticReconnectMaxDelay = 120;
    private boolean useSubscriptionIdentifiers = true;
    private int keepAliveInterval = 60;
    private int connectionTimeout = 30;
    private boolean httpsHostnameVerificationEnabled = true;
    private int maxReconnectDelay = 128000;
    private boolean sendReasonMessages = false;
    MqttProperties willMessageProperties = new MqttProperties();
    private int mqttVersion = 5;
    private boolean cleanStart = true;
    private String willDestination = null;
    private MqttMessage willMessage = null;
    private String userName;
    private byte[] password;
    private Long sessionExpiryInterval = null;
    private Integer receiveMaximum = null;
    private Long maximumPacketSize = null;
    private Integer topicAliasMaximum = null;
    private Boolean requestResponseInfo = null;
    private Boolean requestProblemInfo = null;
    private List<UserProperty> userProperties = null;
    private String authMethod = null;
    private byte[] authData = null;
    private SocketFactory socketFactory;
    private Properties sslClientProps = null;
    private HostnameVerifier sslHostnameVerifier = null;
    private Map<String, String> customWebSocketHeaders;
    private int executorServiceTimeout = 1;

    public MqttProperties getConnectionProperties() {
        MqttProperties connectionProperties = new MqttProperties();
        connectionProperties.setSessionExpiryInterval(this.sessionExpiryInterval);
        connectionProperties.setReceiveMaximum(this.receiveMaximum);
        connectionProperties.setMaximumPacketSize(this.maximumPacketSize);
        connectionProperties.setTopicAliasMaximum(this.topicAliasMaximum);
        connectionProperties.setRequestResponseInfo(this.requestResponseInfo);
        connectionProperties.setRequestProblemInfo(this.requestProblemInfo);
        connectionProperties.setUserProperties(this.userProperties);
        connectionProperties.setAuthenticationMethod(this.authMethod);
        connectionProperties.setAuthenticationData(this.authData);
        return connectionProperties;
    }

    public MqttProperties getWillMessageProperties() {
        return this.willMessageProperties;
    }

    public void setWillMessageProperties(MqttProperties willMessageProperties) {
        this.willMessageProperties = willMessageProperties;
    }

    public int getMqttVersion() {
        return this.mqttVersion;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public byte[] getPassword() {
        return this.password;
    }

    public void setPassword(byte[] password) {
        this.password = password;
    }

    public String getWillDestination() {
        return this.willDestination;
    }

    public MqttMessage getWillMessage() {
        return this.willMessage;
    }

    public void setWill(String topic, MqttMessage message) {
        if (topic == null || message == null || message.getPayload() == null) {
            throw new IllegalArgumentException();
        }
        MqttTopicValidator.validate(topic, false, true);
        this.willDestination = topic;
        this.willMessage = message;
        this.willMessage.setMutable(false);
    }

    public boolean isCleanStart() {
        return this.cleanStart;
    }

    public void setCleanStart(boolean cleanStart) {
        this.cleanStart = cleanStart;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public void setKeepAliveInterval(int keepAliveInterval) {
        if (keepAliveInterval < 0) {
            throw new IllegalArgumentException();
        }
        this.keepAliveInterval = keepAliveInterval;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        if (connectionTimeout < 0) {
            throw new IllegalArgumentException();
        }
        this.connectionTimeout = connectionTimeout;
    }

    public int getMaxReconnectDelay() {
        return this.maxReconnectDelay;
    }

    public void setMaxReconnectDelay(int maxReconnectDelay) {
        this.maxReconnectDelay = maxReconnectDelay;
    }

    public String[] getServerURIs() {
        return this.serverURIs;
    }

    public void setServerURIs(String[] serverURIs) {
        String[] stringArray = serverURIs;
        int n = serverURIs.length;
        int n2 = 0;
        while (n2 < n) {
            String serverURI = stringArray[n2];
            NetworkModuleService.validateURI(serverURI);
            ++n2;
        }
        this.serverURIs = (String[])serverURIs.clone();
    }

    public boolean isAutomaticReconnect() {
        return this.automaticReconnect;
    }

    public void setAutomaticReconnect(boolean automaticReconnect) {
        this.automaticReconnect = automaticReconnect;
    }

    public void setAutomaticReconnectDelay(int minDelay, int maxDelay) {
        this.automaticReconnectMinDelay = minDelay;
        this.automaticReconnectMaxDelay = maxDelay;
    }

    public int getAutomaticReconnectMinDelay() {
        return this.automaticReconnectMinDelay;
    }

    public int getAutomaticReconnectMaxDelay() {
        return this.automaticReconnectMaxDelay;
    }

    public Long getSessionExpiryInterval() {
        return this.sessionExpiryInterval;
    }

    public void setSessionExpiryInterval(Long sessionExpiryInterval) {
        this.sessionExpiryInterval = sessionExpiryInterval;
    }

    public Integer getReceiveMaximum() {
        return this.receiveMaximum;
    }

    public void setReceiveMaximum(Integer receiveMaximum) {
        if (receiveMaximum != null && (receiveMaximum == 0 || receiveMaximum > 65535)) {
            throw new IllegalArgumentException();
        }
        this.receiveMaximum = receiveMaximum;
    }

    public Long getMaximumPacketSize() {
        return this.maximumPacketSize;
    }

    public void setMaximumPacketSize(Long maximumPacketSize) {
        this.maximumPacketSize = maximumPacketSize;
    }

    public Integer getTopicAliasMaximum() {
        return this.topicAliasMaximum;
    }

    public void setTopicAliasMaximum(Integer topicAliasMaximum) {
        if (topicAliasMaximum != null && topicAliasMaximum > 65535) {
            throw new IllegalArgumentException();
        }
        this.topicAliasMaximum = topicAliasMaximum;
    }

    public Boolean getRequestResponseInfo() {
        return this.requestResponseInfo;
    }

    public void setRequestResponseInfo(boolean requestResponseInfo) {
        this.requestResponseInfo = requestResponseInfo;
    }

    public Boolean getRequestProblemInfo() {
        return this.requestProblemInfo;
    }

    public void setRequestProblemInfo(boolean requestProblemInfo) {
        this.requestProblemInfo = requestProblemInfo;
    }

    public List<UserProperty> getUserProperties() {
        return this.userProperties;
    }

    public void setUserProperties(List<UserProperty> userProperties) {
        this.userProperties = userProperties;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public byte[] getAuthData() {
        return this.authData;
    }

    public void setAuthData(byte[] authData) {
        this.authData = authData;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public Properties getSSLProperties() {
        return this.sslClientProps;
    }

    public void setSSLProperties(Properties props) {
        this.sslClientProps = props;
    }

    public HostnameVerifier getSSLHostnameVerifier() {
        return this.sslHostnameVerifier;
    }

    public void setSSLHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.sslHostnameVerifier = hostnameVerifier;
    }

    public boolean useSubscriptionIdentifiers() {
        return this.useSubscriptionIdentifiers;
    }

    public void setUseSubscriptionIdentifiers(boolean useSubscriptionIdentifiers) {
        this.useSubscriptionIdentifiers = useSubscriptionIdentifiers;
    }

    public boolean isHttpsHostnameVerificationEnabled() {
        return this.httpsHostnameVerificationEnabled;
    }

    public void setHttpsHostnameVerificationEnabled(boolean httpsHostnameVerificationEnabled) {
        this.httpsHostnameVerificationEnabled = httpsHostnameVerificationEnabled;
    }

    public Properties getDebug() {
        Properties p = new Properties();
        p.put("MqttVersion", (Object)this.getMqttVersion());
        p.put("CleanStart", (Object)this.isCleanStart());
        p.put("ConTimeout", (Object)this.getConnectionTimeout());
        p.put("KeepAliveInterval", (Object)this.getKeepAliveInterval());
        p.put("UserName", this.getUserName() == null ? "null" : this.getUserName());
        p.put("WillDestination", this.getWillDestination() == null ? "null" : this.getWillDestination());
        if (this.getSocketFactory() == null) {
            p.put("SocketFactory", "null");
        } else {
            p.put("SocketFactory", this.getSocketFactory());
        }
        if (this.getSSLProperties() == null) {
            p.put("SSLProperties", "null");
        } else {
            p.put("SSLProperties", this.getSSLProperties());
        }
        return p;
    }

    public void setCustomWebSocketHeaders(Map<String, String> headers) {
        this.customWebSocketHeaders = Collections.unmodifiableMap(headers);
    }

    public Map<String, String> getCustomWebSocketHeaders() {
        return this.customWebSocketHeaders;
    }

    public String toString() {
        return Debug.dumpProperties(this.getDebug(), "Connection options");
    }

    public boolean isSendReasonMessages() {
        return this.sendReasonMessages;
    }

    public void setSendReasonMessages(boolean sendReasonMessages) {
        this.sendReasonMessages = sendReasonMessages;
    }

    public int getExecutorServiceTimeout() {
        return this.executorServiceTimeout;
    }

    public void setExecutorServiceTimeout(int executorServiceTimeout) {
        this.executorServiceTimeout = executorServiceTimeout;
    }
}

