/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.client.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.internal.ExceptionHelper;
import org.eclipse.paho.mqttv5.client.internal.NetworkModule;
import org.eclipse.paho.mqttv5.client.internal.SSLNetworkModule;
import org.eclipse.paho.mqttv5.client.security.SSLSocketFactoryFactory;
import org.eclipse.paho.mqttv5.client.spi.NetworkModuleFactory;
import org.eclipse.paho.mqttv5.common.MqttException;

public class SSLNetworkModuleFactory
implements NetworkModuleFactory {
    @Override
    public Set<String> getSupportedUriSchemes() {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("ssl")));
    }

    @Override
    public void validateURI(URI brokerUri) throws IllegalArgumentException {
        String path = brokerUri.getPath();
        if (path != null && !path.isEmpty()) {
            throw new IllegalArgumentException(brokerUri.toString());
        }
    }

    @Override
    public NetworkModule createNetworkModule(URI brokerUri, MqttConnectionOptions options, String clientId) throws MqttException {
        String[] enabledCiphers;
        String path;
        String host = brokerUri.getHost();
        int port = brokerUri.getPort();
        if (port == -1) {
            port = 8883;
        }
        if ((path = brokerUri.getPath()) != null && !path.isEmpty()) {
            throw new IllegalArgumentException(brokerUri.toString());
        }
        SocketFactory factory = options.getSocketFactory();
        SSLSocketFactoryFactory factoryFactory = null;
        if (factory == null) {
            factoryFactory = new SSLSocketFactoryFactory();
            Properties sslClientProps = options.getSSLProperties();
            if (sslClientProps != null) {
                factoryFactory.initialize(sslClientProps, null);
            }
            factory = factoryFactory.createSocketFactory(null);
        } else if (!(factory instanceof SSLSocketFactory)) {
            throw ExceptionHelper.createMqttException(32105);
        }
        SSLNetworkModule netModule = new SSLNetworkModule((SSLSocketFactory)factory, host, port, clientId);
        netModule.setSSLhandshakeTimeout(options.getConnectionTimeout());
        netModule.setSSLHostnameVerifier(options.getSSLHostnameVerifier());
        netModule.setHttpsHostnameVerificationEnabled(options.isHttpsHostnameVerificationEnabled());
        if (factoryFactory != null && (enabledCiphers = factoryFactory.getEnabledCipherSuites(null)) != null) {
            netModule.setEnabledCiphers(enabledCiphers);
        }
        return netModule;
    }
}

