/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.client.logging;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.MemoryHandler;
import org.eclipse.paho.mqttv5.client.logging.Logger;

public class JSR47Logger
implements Logger {
    private java.util.logging.Logger julLogger = null;
    private ResourceBundle logMessageCatalog = null;
    private ResourceBundle traceMessageCatalog = null;
    private String catalogID = null;
    private String resourceName = null;
    private String loggerName = null;

    @Override
    public void initialise(ResourceBundle logMsgCatalog, String loggerID, String resourceContext) {
        this.traceMessageCatalog = this.logMessageCatalog;
        this.resourceName = resourceContext;
        this.loggerName = loggerID;
        this.julLogger = java.util.logging.Logger.getLogger(this.loggerName);
        this.logMessageCatalog = logMsgCatalog;
        this.traceMessageCatalog = logMsgCatalog;
        this.catalogID = this.logMessageCatalog.getString("0");
    }

    @Override
    public void setResourceName(String logContext) {
        this.resourceName = logContext;
    }

    @Override
    public boolean isLoggable(int level) {
        return this.julLogger.isLoggable(this.mapJULLevel(level));
    }

    @Override
    public void severe(String sourceClass, String sourceMethod, String msg) {
        this.log(1, sourceClass, sourceMethod, msg, null, null);
    }

    @Override
    public void severe(String sourceClass, String sourceMethod, String msg, Object[] inserts) {
        this.log(1, sourceClass, sourceMethod, msg, inserts, null);
    }

    @Override
    public void severe(String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable thrown) {
        this.log(1, sourceClass, sourceMethod, msg, inserts, thrown);
    }

    @Override
    public void warning(String sourceClass, String sourceMethod, String msg) {
        this.log(2, sourceClass, sourceMethod, msg, null, null);
    }

    @Override
    public void warning(String sourceClass, String sourceMethod, String msg, Object[] inserts) {
        this.log(2, sourceClass, sourceMethod, msg, inserts, null);
    }

    @Override
    public void warning(String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable thrown) {
        this.log(2, sourceClass, sourceMethod, msg, inserts, thrown);
    }

    @Override
    public void info(String sourceClass, String sourceMethod, String msg) {
        this.log(3, sourceClass, sourceMethod, msg, null, null);
    }

    @Override
    public void info(String sourceClass, String sourceMethod, String msg, Object[] inserts) {
        this.log(3, sourceClass, sourceMethod, msg, inserts, null);
    }

    @Override
    public void info(String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable thrown) {
        this.log(3, sourceClass, sourceMethod, msg, inserts, thrown);
    }

    @Override
    public void config(String sourceClass, String sourceMethod, String msg) {
        this.log(4, sourceClass, sourceMethod, msg, null, null);
    }

    @Override
    public void config(String sourceClass, String sourceMethod, String msg, Object[] inserts) {
        this.log(4, sourceClass, sourceMethod, msg, inserts, null);
    }

    @Override
    public void config(String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable thrown) {
        this.log(4, sourceClass, sourceMethod, msg, inserts, thrown);
    }

    @Override
    public void log(int level, String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable thrown) {
        Level julLevel = this.mapJULLevel(level);
        if (this.julLogger.isLoggable(julLevel)) {
            this.logToJsr47(julLevel, sourceClass, sourceMethod, this.catalogID, this.logMessageCatalog, msg, inserts, thrown);
        }
    }

    @Override
    public void fine(String sourceClass, String sourceMethod, String msg) {
        this.trace(5, sourceClass, sourceMethod, msg, null, null);
    }

    @Override
    public void fine(String sourceClass, String sourceMethod, String msg, Object[] inserts) {
        this.trace(5, sourceClass, sourceMethod, msg, inserts, null);
    }

    @Override
    public void fine(String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable ex) {
        this.trace(5, sourceClass, sourceMethod, msg, inserts, ex);
    }

    @Override
    public void finer(String sourceClass, String sourceMethod, String msg) {
        this.trace(6, sourceClass, sourceMethod, msg, null, null);
    }

    @Override
    public void finer(String sourceClass, String sourceMethod, String msg, Object[] inserts) {
        this.trace(6, sourceClass, sourceMethod, msg, inserts, null);
    }

    @Override
    public void finer(String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable ex) {
        this.trace(6, sourceClass, sourceMethod, msg, inserts, ex);
    }

    @Override
    public void finest(String sourceClass, String sourceMethod, String msg) {
        this.trace(7, sourceClass, sourceMethod, msg, null, null);
    }

    @Override
    public void finest(String sourceClass, String sourceMethod, String msg, Object[] inserts) {
        this.trace(7, sourceClass, sourceMethod, msg, inserts, null);
    }

    @Override
    public void finest(String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable ex) {
        this.trace(7, sourceClass, sourceMethod, msg, inserts, ex);
    }

    @Override
    public void trace(int level, String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable ex) {
        Level julLevel = this.mapJULLevel(level);
        boolean isJULLoggable = this.julLogger.isLoggable(julLevel);
        if (isJULLoggable) {
            this.logToJsr47(julLevel, sourceClass, sourceMethod, this.catalogID, this.traceMessageCatalog, msg, inserts, ex);
        }
    }

    private String getResourceMessage(ResourceBundle messageCatalog, String msg) {
        String message;
        try {
            message = messageCatalog.getString(msg);
        }
        catch (MissingResourceException missingResourceException) {
            message = msg;
        }
        return message;
    }

    private void logToJsr47(Level julLevel, String sourceClass, String sourceMethod, String catalogName, ResourceBundle messageCatalog, String msg, Object[] inserts, Throwable thrown) {
        String formattedWithArgs = msg;
        if (!msg.contains("=====")) {
            formattedWithArgs = MessageFormat.format(this.getResourceMessage(messageCatalog, msg), inserts);
        }
        LogRecord logRecord = new LogRecord(julLevel, String.valueOf(this.resourceName) + ": " + formattedWithArgs);
        logRecord.setSourceClassName(sourceClass);
        logRecord.setSourceMethodName(sourceMethod);
        logRecord.setLoggerName(this.loggerName);
        if (thrown != null) {
            logRecord.setThrown(thrown);
        }
        this.julLogger.log(logRecord);
    }

    private Level mapJULLevel(int level) {
        Level julLevel = null;
        switch (level) {
            case 1: {
                julLevel = Level.SEVERE;
                break;
            }
            case 2: {
                julLevel = Level.WARNING;
                break;
            }
            case 3: {
                julLevel = Level.INFO;
                break;
            }
            case 4: {
                julLevel = Level.CONFIG;
                break;
            }
            case 5: {
                julLevel = Level.FINE;
                break;
            }
            case 6: {
                julLevel = Level.FINER;
                break;
            }
            case 7: {
                julLevel = Level.FINEST;
            }
        }
        return julLevel;
    }

    @Override
    public String formatMessage(String msg, Object[] inserts) {
        String formatString;
        try {
            formatString = this.logMessageCatalog.getString(msg);
        }
        catch (MissingResourceException missingResourceException) {
            formatString = msg;
        }
        return formatString;
    }

    @Override
    public void dumpTrace() {
        JSR47Logger.dumpMemoryTrace47(this.julLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void dumpMemoryTrace47(java.util.logging.Logger logger) {
        MemoryHandler mHand = null;
        if (logger != null) {
            Handler[] handlers;
            Handler[] handlerArray = handlers = logger.getHandlers();
            int n = handlers.length;
            int n2 = 0;
            while (n2 < n) {
                Handler handler = handlerArray[n2];
                if (handler instanceof MemoryHandler) {
                    Handler handler2 = handler;
                    synchronized (handler2) {
                        mHand = (MemoryHandler)handler;
                        mHand.push();
                        return;
                    }
                }
                ++n2;
            }
            JSR47Logger.dumpMemoryTrace47(logger.getParent());
        }
    }
}

