/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.common.packet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.packet.MqttDataTypes;
import org.eclipse.paho.mqttv5.common.packet.MqttPersistableWireMessage;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.eclipse.paho.mqttv5.common.packet.util.CountingInputStream;

public class MqttPublish
extends MqttPersistableWireMessage {
    private static final Byte[] validProperties = new Byte[]{(byte)1, (byte)2, (byte)35, (byte)8, (byte)9, (byte)38, (byte)3, (byte)126, (byte)11};
    private MqttProperties properties;
    private byte[] payload;
    private int qos = 1;
    private boolean retained = false;
    private boolean dup = false;
    private String topicName;

    public MqttPublish(String topic, MqttMessage message, MqttProperties properties) {
        super((byte)3);
        this.topicName = topic;
        this.payload = message.getPayload();
        this.qos = message.getQos();
        this.dup = message.isDuplicate();
        this.retained = message.isRetained();
        this.properties = properties != null ? properties : new MqttProperties();
        this.properties.setValidProperties(validProperties);
    }

    public MqttPublish(byte info, byte[] data) throws MqttException, IOException {
        super((byte)3);
        this.properties = new MqttProperties(validProperties);
        this.qos = info >> 1 & 3;
        if ((info & 1) == 1) {
            this.retained = true;
        }
        if ((info & 8) == 8) {
            this.dup = true;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        CountingInputStream counter = new CountingInputStream(bais);
        DataInputStream dis = new DataInputStream(counter);
        this.topicName = MqttDataTypes.decodeUTF8(dis);
        if (this.qos > 0) {
            this.msgId = dis.readUnsignedShort();
        }
        this.properties.decodeProperties(dis);
        this.payload = new byte[data.length - counter.getCounter()];
        dis.readFully(this.payload);
        dis.close();
    }

    @Override
    protected byte[] getVariableHeader() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            if (this.topicName != null) {
                MqttDataTypes.encodeUTF8(dos, this.topicName);
            } else {
                MqttDataTypes.encodeUTF8(dos, "");
            }
            if (this.qos > 0) {
                dos.writeShort(this.msgId);
            }
            byte[] identifierValueFieldsArray = this.properties.encodeProperties();
            dos.write(identifierValueFieldsArray);
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new MqttException(ioe);
        }
    }

    @Override
    protected byte getMessageInfo() {
        byte info = (byte)(this.qos << 1);
        if (this.retained) {
            info = (byte)(info | 1);
        }
        if (this.dup || this.duplicate) {
            info = (byte)(info | 8);
        }
        return info;
    }

    @Override
    public byte[] getPayload() {
        return this.payload;
    }

    @Override
    public int getPayloadLength() {
        if (this.payload != null) {
            return this.payload.length;
        }
        return 0;
    }

    @Override
    public boolean isMessageIdRequired() {
        return true;
    }

    public MqttMessage getMessage() {
        MqttMessage message = new MqttMessage(this.payload, this.qos, this.retained, this.properties);
        return message;
    }

    public void setMessage(MqttMessage message) {
        this.payload = message.getPayload();
        this.qos = message.getQos();
        this.dup = message.isDuplicate();
        this.retained = message.isRetained();
    }

    public String getTopicName() {
        return this.topicName;
    }

    public int getQoS() {
        return this.qos;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    @Override
    public MqttProperties getProperties() {
        return this.properties;
    }

    @Override
    public String toString() {
        StringBuilder hex = new StringBuilder();
        int limit = Math.min(this.payload.length, 20);
        int i = 0;
        while (i < limit) {
            byte b = this.payload[i];
            String ch = Integer.toHexString(b);
            if (ch.length() == 1) {
                ch = "0" + ch;
            }
            hex.append(ch);
            ++i;
        }
        String string = null;
        try {
            string = new String(this.payload, 0, limit, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = "?";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("MqttPublish [");
        sb.append(", qos=").append(this.qos);
        if (this.qos > 0) {
            sb.append(", messageId=").append(this.msgId);
        }
        sb.append(", retained=").append(this.retained);
        sb.append(", duplicate=").append(this.duplicate);
        sb.append(", topic=").append(this.topicName);
        sb.append(", payload=[hex=").append((CharSequence)hex);
        sb.append(", utf8=").append(string);
        sb.append(", length=").append(this.payload.length).append("]");
        sb.append(", properties=").append(this.properties.toString());
        return sb.toString();
    }
}

