/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.build;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.persistence.build.PackagerMojo;

final class DescriptorGenerator {
    private static Templates puTemplate;
    private static Templates ejbTemplate;
    private boolean generateEJB;
    private boolean generatePU;
    private final Log log;
    private final Path sourcePu;

    DescriptorGenerator(Path sourcePu, Log log) {
        this.log = log;
        this.sourcePu = sourcePu;
        this.generatePU = true;
        this.generateEJB = true;
    }

    void ejbDescriptor(boolean generateEJB) {
        this.generateEJB = generateEJB;
    }

    void persistenceDescriptor(boolean generatePU) {
        this.generatePU = generatePU;
    }

    void generate(Path destDir, Map<String, Object> options) throws IOException, TransformerException {
        Path dest;
        if (!this.generatePU && !this.generateEJB) {
            this.log.info((CharSequence)"Not generating server-side descriptors...");
            return;
        }
        if (this.generatePU) {
            dest = destDir.resolve(PackagerMojo.PERSISTENCE_DESC);
            this.log.info((CharSequence)String.format("Generating %s to: %s", PackagerMojo.PERSISTENCE_DESC.getFileName(), dest));
            this.createDescriptor(dest, options, this.getPersistenceTransformer());
        } else {
            this.log.info((CharSequence)String.format("Not generating %s...", PackagerMojo.PERSISTENCE_DESC.getFileName()));
        }
        if (this.generateEJB) {
            dest = destDir.resolve(PackagerMojo.EJB_DESC);
            this.log.info((CharSequence)String.format("Generating %s to: %s", PackagerMojo.EJB_DESC.getFileName(), dest));
            this.createDescriptor(dest, options, this.getEJBTransformer());
        } else {
            this.log.info((CharSequence)String.format("Not generating %s...", PackagerMojo.EJB_DESC.getFileName()));
        }
    }

    private void createDescriptor(Path output, Map<String, Object> options, Transformer transformer) throws TransformerException, IOException {
        Map<String, Object> opts = Objects.requireNonNull(options);
        Path dest = Objects.requireNonNull(output);
        Transformer t = Objects.requireNonNull(transformer);
        opts.forEach(transformer::setParameter);
        Files.createDirectories(dest.getParent(), new FileAttribute[0]);
        if (Files.exists(dest, new LinkOption[0])) {
            Files.delete(dest);
        }
        try (BufferedReader r = Files.newBufferedReader(this.sourcePu);
             BufferedWriter w = Files.newBufferedWriter(Files.createFile(dest, new FileAttribute[0]), new OpenOption[0]);){
            t.transform(new StreamSource(r), new StreamResult(w));
        }
    }

    private Transformer getEJBTransformer() throws TransformerConfigurationException {
        if (ejbTemplate == null) {
            this.initialize();
        }
        return ejbTemplate.newTransformer();
    }

    private Transformer getPersistenceTransformer() throws TransformerConfigurationException {
        if (puTemplate == null) {
            this.initialize();
        }
        return puTemplate.newTransformer();
    }

    private synchronized void initialize() throws TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        puTemplate = transformerFactory.newTemplates(new StreamSource(DescriptorGenerator.class.getResourceAsStream("pu.xsl")));
        ejbTemplate = transformerFactory.newTemplates(new StreamSource(DescriptorGenerator.class.getResourceAsStream("ejb.xsl")));
    }
}

