/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.build;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.interpolation.ValueSource;
import org.eclipse.persistence.build.PackagerMojo;
import org.eclipse.persistence.build.PropertiesValueSource;

final class Packager {
    private final MavenArchiver archiver = new MavenArchiver();
    private final Log log;
    private File confDir;
    private final List<Path> resources;

    Packager(Packager p) {
        this(p.archiver.getArchiver(), p.log);
        File f = p.archiver.getArchiver().getDestFile();
        this.archiver.getArchiver().addFile(f, f.getName());
    }

    Packager(JarArchiver jarArchiver, Log log) {
        this.archiver.setCreatedBy("EclipseLink Build Plugin", "org.eclipse.persistence", "eclipselink-testbuild-plugin");
        this.archiver.setArchiver(jarArchiver);
        this.log = log;
        this.resources = new ArrayList<Path>(1);
    }

    public void setTarget(File destFile) {
        this.archiver.setOutputFile(destFile);
        this.archiver.getArchiver().setDestFile(destFile);
    }

    public void setOutputTimestamp(String outputTimestamp) {
        this.archiver.configureReproducible(outputTimestamp);
    }

    public void setConfDir(File confDir) {
        this.confDir = confDir;
    }

    public void addFile(File file) {
        this.addFile(file, "");
    }

    public void addFile(File file, String prefix) {
        if (file.exists() && file.isFile()) {
            String destName = this.stripVersion(file.getName());
            this.archiver.getArchiver().addFile(file, prefix + destName);
            this.log.debug((CharSequence)("adding file: " + prefix + file.getName()));
        } else {
            this.log.debug((CharSequence)("skipping file: " + prefix + file.getName()));
        }
    }

    public void addExpanded(File archive) {
        this.addExpanded(archive, null);
    }

    public void addExpanded(File archive, String exclusionFilter) {
        if (archive.exists() && archive.isFile()) {
            String[] stringArray;
            JarArchiver jarArchiver = this.archiver.getArchiver();
            if (exclusionFilter == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = exclusionFilter;
            }
            jarArchiver.addArchivedFileSet(archive, null, stringArray);
            this.log.debug((CharSequence)("adding expanded archive: " + archive.getName() + ", exclusions: " + exclusionFilter));
        } else {
            this.log.debug((CharSequence)("skipping expanded archive: " + archive.getName() + ", exclusions: " + exclusionFilter));
        }
    }

    public void addClasses(File root) {
        this.addClasses(root, null);
    }

    public void addClasses(File root, String[] exclusionFilter) {
        if (root.exists() && root.isDirectory()) {
            this.archiver.getArchiver().addDirectory(root, null, exclusionFilter);
            this.log.debug((CharSequence)("adding directory: " + root.getName() + ", exclusions: " + Arrays.toString(exclusionFilter)));
        } else {
            this.log.debug((CharSequence)("skipping directory: " + root.getName() + ", exclusions: " + Arrays.toString(exclusionFilter)));
        }
    }

    public void addResources(Path resourceDir) {
        this.resources.add(resourceDir);
    }

    public void addTemplate(String template) {
        File t = new File(this.confDir, template);
        if (t.exists() && t.isFile()) {
            this.archiver.getArchiver().addFile(t, "META-INF/templates/" + t.getName());
            this.log.debug((CharSequence)("adding template: " + t.getName()));
        } else {
            this.log.debug((CharSequence)("skipping template: " + t.getName()));
        }
    }

    public void createArchive(MavenProject project, MavenSession session, MavenResourcesFiltering filtering, MavenArchiveConfiguration archive) throws MavenFilteringException, DependencyResolutionRequiredException, IOException, ManifestException {
        List<Resource> res = this.getResources();
        if (res.isEmpty()) {
            this.log.debug((CharSequence)("skipping directory: " + this.confDir.getName()));
        } else {
            this.log.debug((CharSequence)("filtering resources: " + this.confDir.getName()));
            File filtered = this.filterResources(project, session, filtering, res);
            this.log.debug((CharSequence)("adding resources: " + filtered.getName()));
            this.archiver.getArchiver().addDirectory(filtered);
        }
        this.archiver.createArchive(session, project, archive);
    }

    private File filterResources(MavenProject project, MavenSession session, MavenResourcesFiltering filtering, List<Resource> resources) throws MavenFilteringException {
        File destDir = Paths.get(project.getBuild().getDirectory(), new String[0]).resolve(PackagerMojo.WORK_DIR.resolve(this.confDir.getName())).toFile();
        MavenResourcesExecution resourceExec = new MavenResourcesExecution(resources, destDir, project, project.getProperties().getProperty("project.build.sourceEncoding"), Collections.emptyList(), List.of("gar"), session);
        resourceExec.addFilerWrapperWithEscaping((ValueSource)new PropertiesValueSource(project.getProperties()), "@", "@", "\\", true);
        filtering.filterResources(resourceExec);
        return destDir;
    }

    private String stripVersion(String s) {
        int x = s.indexOf(45);
        if (x > 1 && s.contains("member_")) {
            int y = s.lastIndexOf(45) + 1;
            return s.substring(0, x) + "_" + s.substring(y);
        }
        return s;
    }

    private List<Resource> getResources() {
        ArrayList<Resource> res = new ArrayList<Resource>();
        if (this.confDir.exists() && this.confDir.isDirectory()) {
            res.add(this.createResource(this.confDir));
        }
        this.resources.forEach(path -> res.add(this.createResource(path.toFile())));
        return res;
    }

    private Resource createResource(File dir) {
        Resource r = new Resource();
        r.setDirectory(dir.getAbsolutePath());
        r.setFiltering(true);
        return r;
    }
}

