/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.build;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.transform.TransformerException;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.persistence.build.DependencyResolver;
import org.eclipse.persistence.build.DescriptorGenerator;
import org.eclipse.persistence.build.Packager;
import org.eclipse.persistence.build.PropertiesValueSource;

@Mojo(name="package-testapp", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public final class PackagerMojo
extends AbstractMojo {
    static final Path EJB_DESC = Path.of("META-INF", "ejb-jar.xml");
    static final Path PERSISTENCE_DESC = Path.of("META-INF", "persistence.xml");
    static final Path WORK_DIR = Path.of("eclipselink-packager", new String[0]);
    private static final String SINGLE_PU_RUNNER_FILTER = "%regex[.*TestRunner[0-9].*]";
    private static final String ALL_PU_RUNNERS_FILTER = "%regex[.*TestRunner.*Bean.*]";
    static final String PLUGIN_GROUP_ID = "org.eclipse.persistence";
    static final String PLUGIN_ARTIFACT_ID = "eclipselink-testbuild-plugin";
    private static final Map<String, String> RUNNERS = Map.of("org/eclipse/persistence/testing/framework/jpa/server/TestRunner.class", "", "org/eclipse/persistence/testing/framework/jpa/server/GenericTestRunner.class", "GenericTestRunner", "org/eclipse/persistence/testing/framework/jpa/server/SingleUnitTestRunnerBean.class", "SingleUnitTestRunner", "org/eclipse/persistence/testing/framework/jpa/server/TestRunner1Bean.class", "TestRunner1", "org/eclipse/persistence/testing/framework/jpa/server/TestRunner2Bean.class", "TestRunner2", "org/eclipse/persistence/testing/framework/jpa/server/TestRunner3Bean.class", "TestRunner3", "org/eclipse/persistence/testing/framework/jpa/server/TestRunner4Bean.class", "TestRunner4", "org/eclipse/persistence/testing/framework/jpa/server/TestRunner5Bean.class", "TestRunner5", "org/eclipse/persistence/testing/framework/jpa/server/TestRunner6Bean.class", "TestRunner6");
    private static final Map<String, String> RUNNERS_CACHE = new ConcurrentHashMap<String, String>(2);
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver archiver;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File classesDirectory;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", required=true)
    private File testClassesDirectory;
    @Parameter(property="el.fwk.skip")
    private boolean skip;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    private String outputTimestamp;
    @Parameter(defaultValue="${project.basedir}/src/main/resources-ejb")
    private File ejbConf;
    @Parameter(defaultValue="${project.basedir}/src/main/resources-ear")
    private File earConf;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true)
    private String finalName;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Component
    private MavenResourcesFiltering mavenResourcesFiltering;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;
    @Parameter
    private List<String> libs;
    @Parameter(property="el.packager.mode", defaultValue="EAR")
    private String mode;
    @Parameter(property="el.packager.descriptors", defaultValue="true")
    private boolean generateDescriptors;
    @Parameter(property="el.packager.fwk.exclusionFilter")
    private String fwkExclusionFilter;
    @Component
    private MavenProjectHelper helper;

    /*
     * WARNING - void declaration
     */
    public void execute() throws MojoExecutionException {
        Packager p;
        File destJar;
        block38: {
            if ("pom".equals(this.project.getPackaging())) {
                this.getLog().info((CharSequence)"pom projects not supported, skipping...");
                return;
            }
            boolean testSkip = Boolean.getBoolean(this.project.getProperties().getProperty("maven.test.skip"));
            if (testSkip) {
                this.getLog().info((CharSequence)"required tests were not built, skipping...");
                return;
            }
            if (this.skip) {
                this.getLog().info((CharSequence)"skipping...");
                return;
            }
            destJar = new File(this.outputDirectory, this.finalName + "_ejb.jar");
            p = new Packager(this.archiver, this.getLog());
            p.setTarget(destJar);
            p.setOutputTimestamp(this.outputTimestamp);
            p.setConfDir(this.ejbConf);
            try {
                void var6_15;
                File fwk = this.getResolved("org.eclipse.persistence.jpa.test.framework");
                if (fwk == null) {
                    throw new MojoExecutionException("cannot find dependency on org.eclipse.persistence.jpa.test.framework");
                }
                Path puXml = Paths.get(((Resource)this.project.getResources().get(0)).getDirectory(), new String[0]).resolve(PERSISTENCE_DESC);
                String string = this.fwkExclusionFilter;
                if (string == null || string.isBlank()) {
                    if (!Files.isRegularFile(puXml, new LinkOption[0])) {
                        String string2 = ALL_PU_RUNNERS_FILTER;
                    } else {
                        try (Stream<String> lines = Files.lines(puXml);){
                            if (lines.filter(line -> line.contains("<persistence-unit ") && !line.contains("--")).count() == 1L) {
                                String string3 = SINGLE_PU_RUNNER_FILTER;
                            } else {
                                String string4 = ALL_PU_RUNNERS_FILTER;
                            }
                        }
                    }
                }
                this.getLog().debug((CharSequence)("exclusion filter: " + (String)var6_15));
                p.addExpanded(fwk, (String)var6_15);
                if (!this.generateDescriptors) break block38;
                DescriptorGenerator gen = new DescriptorGenerator(puXml, this.getLog());
                gen.ejbDescriptor(Files.notExists(this.ejbConf.toPath().resolve(EJB_DESC), new LinkOption[0]));
                gen.persistenceDescriptor(Files.notExists(this.ejbConf.toPath().resolve(PERSISTENCE_DESC), new LinkOption[0]));
                PropertiesValueSource props = new PropertiesValueSource(this.project.getProperties());
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("generator.id", String.format("EclipseLink Build Plugin (%s:%s:%s)", PLUGIN_GROUP_ID, PLUGIN_ARTIFACT_ID, this.getPluginVersion()));
                options.put("data-source-type", props.getValue("persistence-unit.data-source-type"));
                options.put("data-source-name", props.getValue("persistence-unit.data-source-name"));
                options.put("db.platform", props.getValue("db.platform"));
                options.put("server.platform", props.getValue("server.platform"));
                options.put("server.weaving", props.getValue("persistence-unit.server-weaving"));
                try {
                    options.put("testRunners", this.getRunners(fwk, (String)var6_15));
                }
                catch (UnsupportedOperationException uoe) {
                    gen.ejbDescriptor(false);
                    this.getLog().warn((CharSequence)uoe.getMessage());
                }
                Path generatedFolder = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve(WORK_DIR.resolve("generated"));
                gen.generate(generatedFolder, options);
                p.addResources(generatedFolder);
            }
            catch (IOException | TransformerException | ArtifactResolutionException e) {
                throw new MojoExecutionException(e);
            }
        }
        Dependency memberDep = this.getMemberArtifact();
        if (memberDep != null) {
            try {
                Artifact member = DependencyResolver.resolveArtifact(memberDep, this.remoteRepos, this.repoSystem, this.repoSession);
                p.addExpanded(member.getFile());
            }
            catch (Throwable t) {
                throw new MojoExecutionException(t.getMessage(), t);
            }
        }
        for (Dependency dependency : this.getTestArtifacts()) {
            try {
                Artifact tests = DependencyResolver.resolveArtifact(dependency, this.remoteRepos, this.repoSystem, this.repoSession);
                p.addExpanded(tests.getFile(), "%regex[.*META-INF/.*]");
            }
            catch (Throwable t) {
                throw new MojoExecutionException(t.getMessage(), t);
            }
        }
        p.addClasses(this.classesDirectory, new String[]{"META-INF/persistence.xml", "META-INF/sessions.xml", "*.jar"});
        p.addClasses(this.testClassesDirectory);
        p.addTemplate("META-INF/persistence.xml");
        p.addTemplate("META-INF/sessions.xml");
        try {
            p.createArchive(this.project, this.session, this.mavenResourcesFiltering, this.archive);
        }
        catch (Throwable t) {
            throw new MojoExecutionException(t.getMessage(), t);
        }
        this.helper.attachArtifact(this.project, "jar", "ejb", destJar);
        if ("EAR".equalsIgnoreCase(this.mode)) {
            p = new Packager(p);
            destJar = new File(this.outputDirectory, this.finalName + ".ear");
            p.setTarget(destJar);
            p.setOutputTimestamp(this.outputTimestamp);
            p.setConfDir(this.earConf);
            try {
                File f = this.getResolved("org.eclipse.persistence.core.test.framework");
                if (f == null) {
                    throw new MojoExecutionException("cannot find dependency on org.eclipse.persistence.core.test.framework");
                }
                p.addFile(f, "lib/");
                f = this.getResolved("junit");
                if (f == null) {
                    throw new MojoExecutionException("cannot find dependency on junit");
                }
                p.addFile(f, "lib/");
            }
            catch (ArtifactResolutionException e) {
                throw new RuntimeException(e);
            }
            List<Dependency> memberDeps = this.getMemberArtifacts();
            for (Dependency member : memberDeps) {
                try {
                    Artifact m = DependencyResolver.resolveArtifact(member, this.remoteRepos, this.repoSystem, this.repoSession);
                    p.addFile(m.getFile());
                }
                catch (Throwable t) {
                    throw new MojoExecutionException(t.getMessage(), t);
                }
            }
            try {
                p.createArchive(this.project, this.session, this.mavenResourcesFiltering, this.archive);
            }
            catch (Throwable throwable) {
                throw new MojoExecutionException(throwable.getMessage(), throwable);
            }
            this.helper.attachArtifact(this.project, "jar", "ear", destJar);
        }
    }

    private Dependency getArtifact(String artifactId) {
        for (Dependency dependency : this.project.getDependencies()) {
            if (!dependency.getArtifactId().equals(artifactId)) continue;
            return dependency;
        }
        return null;
    }

    private Dependency getMemberArtifact() {
        for (Dependency dependency : this.project.getDependencies()) {
            String classifier = dependency.getClassifier();
            if (classifier == null || !classifier.contains("member")) continue;
            return dependency;
        }
        return null;
    }

    private List<Dependency> getMemberArtifacts() {
        ArrayList<Dependency> members = new ArrayList<Dependency>();
        for (Dependency dependency : this.project.getDependencies()) {
            if (!dependency.getArtifactId().contains("member")) continue;
            dependency.setClassifier("ejb");
            members.add(dependency);
        }
        return members;
    }

    private List<Dependency> getTestArtifacts() {
        ArrayList<Dependency> tests = new ArrayList<Dependency>();
        for (Dependency dependency : this.project.getDependencies()) {
            if (!"test-jar".equals(dependency.getType()) && !"model".equals(dependency.getClassifier())) continue;
            tests.add(dependency);
        }
        return tests;
    }

    private File getResolved(String artifactId) throws ArtifactResolutionException {
        Dependency dep = this.getArtifact(artifactId);
        if (dep != null) {
            return DependencyResolver.resolveArtifact(dep, this.remoteRepos, this.repoSystem, this.repoSession).getFile();
        }
        return null;
    }

    private String getRunners(File file, String filter) {
        return RUNNERS_CACHE.computeIfAbsent(filter, f -> {
            HashSet result;
            block14: {
                result = new HashSet();
                if (f.startsWith("%regex[")) {
                    Pattern pattern = Pattern.compile(f.substring(7, f.lastIndexOf(93)));
                    try (JarFile jf = new JarFile(file);
                         Stream<JarEntry> stream = jf.stream();){
                        stream.filter(x -> x.getName().contains("TestRunner")).filter(x -> !pattern.matcher(x.getName()).matches()).map(x -> RUNNERS.getOrDefault(x.getName(), x.getName().substring(x.getName().lastIndexOf(47) + 1, x.getName().lastIndexOf(46)))).collect(Collectors.toCollection(() -> result));
                        break block14;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                throw new UnsupportedOperationException("non-regex filters are not supported yet, ejb-jar.xml won't be generated.");
            }
            return String.join((CharSequence)" ", result).trim();
        });
    }

    private String getPluginVersion() {
        for (Plugin p : this.project.getBuildPlugins()) {
            if (!PLUGIN_GROUP_ID.equals(p.getGroupId()) || !PLUGIN_ARTIFACT_ID.equals(p.getArtifactId())) continue;
            return p.getVersion();
        }
        return "unknown";
    }
}

