/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.build.embedmongo;

import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.mongo.distribution.Versions;
import de.flapdoodle.embed.mongo.packageresolver.Feature;
import de.flapdoodle.embed.process.io.ProcessOutput;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.eclipse.persistence.build.embedmongo.StartMojo;
import org.eclipse.persistence.build.embedmongo.log.Loggers;

public abstract class AbstractEmbeddedMongoMojo
extends AbstractMojo {
    private static final String PACKAGE_NAME = StartMojo.class.getPackage().getName();
    public static final String MONGOD_CONTEXT_PROPERTY_NAME = PACKAGE_NAME + ".mongod";
    @Parameter(property="el.embedmongo.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="el.embedmongo.port", defaultValue="27017")
    private int port;
    @Parameter(property="el.embedmongo.version", defaultValue="7.0.0")
    private String version;
    @Parameter(property="el.embedmongo.features")
    private String features;
    @Parameter(property="el.embedmongo.logging", defaultValue="console")
    private String logging;
    @Parameter(property="el.embedmongo.logFile", defaultValue="embedmongo.log")
    private String logFile;
    @Parameter(property="el.embedmongo.logFileEncoding", defaultValue="utf-8")
    private String logFileEncoding;
    @Parameter(property="el.embedmongo.downloadPath", defaultValue="http://fastdl.mongodb.org/")
    private String downloadPath;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;

    public abstract void execute() throws MojoExecutionException, MojoFailureException;

    protected void onSkip() {
    }

    public String getFeatures() {
        return this.features;
    }

    protected IFeatureAwareVersion getVersion() {
        Object versionEnumName = this.version.toUpperCase().replaceAll("\\.", "_");
        if (((String)versionEnumName).charAt(0) != 'V') {
            versionEnumName = "V" + (String)versionEnumName;
        }
        Feature[] features = new Feature[]{};
        if (this.features != null) {
            try {
                features = (Feature[])Stream.of(this.features.split(",")).map(String::trim).map(String::toUpperCase).map(Feature::valueOf).toArray(Feature[]::new);
            }
            catch (IllegalArgumentException e) {
                this.getLog().warn((CharSequence)("Unrecognised feature '" + this.features + ". Attempting download anyway..."));
            }
        }
        try {
            return Versions.withFeatures((de.flapdoodle.embed.process.distribution.Version)Version.valueOf((String)versionEnumName));
        }
        catch (IllegalArgumentException e) {
            this.getLog().warn((CharSequence)("Unrecognised MongoDB version '" + this.version + "', this might be a new version that we don't yet know about. Attempting download anyway..."));
            return Versions.withFeatures(() -> this.version);
        }
    }

    protected Integer getPort() {
        String portStr = this.project.getProperties().getProperty("el.embedmongo.port");
        if (StringUtils.isNotBlank((CharSequence)portStr)) {
            return Integer.valueOf(portStr);
        }
        return this.port;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public String getDownloadPath() {
        return this.downloadPath;
    }

    protected ProcessOutput getOutputConfig() throws MojoFailureException {
        Loggers.LoggingOutput loggingOutput = Loggers.LoggingOutput.valueOf(this.logging.toUpperCase());
        switch (loggingOutput) {
            case CONSOLE: {
                return Loggers.console();
            }
            case FILE: {
                return Loggers.file(this.logFile, this.logFileEncoding);
            }
            case NONE: {
                return Loggers.none();
            }
        }
        throw new MojoFailureException("Unexpected logging output specified: \"" + this.logging + "\" -> " + loggingOutput);
    }
}

