/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.build.embedmongo.log;

import de.flapdoodle.embed.process.io.StreamProcessor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class FileOutputStreamProcessor
implements StreamProcessor {
    private static OutputStreamWriter stream;
    private String logFile;
    private String encoding;

    public FileOutputStreamProcessor(String logFile, String encoding) {
        this.setLogFile(logFile);
        this.setEncoding(encoding);
    }

    public synchronized void process(String block) {
        try {
            if (stream == null) {
                stream = new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFile), this.encoding);
            }
            stream.write(block);
            stream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void onProcessed() {
        this.process("\n");
    }

    private void setLogFile(String logFile) {
        if (logFile == null || logFile.trim().length() == 0) {
            throw new IllegalArgumentException("no logFile given");
        }
        this.logFile = logFile;
    }

    private void setEncoding(String encoding) {
        if (encoding == null || encoding.trim().length() == 0) {
            throw new IllegalArgumentException("no encoding given");
        }
        this.encoding = encoding;
    }
}

