<?xml version="1.0" encoding="UTF-8"?>
<!--

    Copyright (c) 2022 Oracle and/or its affiliates. All rights reserved.

    This program and the accompanying materials are made available under the
    terms of the Eclipse Public License v. 2.0 which is available at
    http://www.eclipse.org/legal/epl-2.0,
    or the Eclipse Distribution License v. 1.0 which is available at
    http://www.eclipse.org/org/documents/edl-v10.php.

    SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause

-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
                xmlns="https://jakarta.ee/xml/ns/jakartaee">
    <xsl:output xmlns:xalan="http://xml.apache.org/xalan" method="xml" encoding="UTF-8" indent="yes"
                xalan:indent-amount="4"/>

    <xsl:param name="separator" select="' '"/>
    <!-- '$separator' delimited lists -->
    <xsl:param name="testRunners" select="''"/>
    <xsl:param name="generator.id" select="'UNDEFINED'"/>

    <xsl:variable name="persistenceUnits" select="*[local-name() = 'persistence']/*[@name]"/>

    <xsl:template match="/">
        <!-- generator marker -->
        <xsl:text>&#10;</xsl:text><xsl:comment>This file was generated by <xsl:value-of select="$generator.id"/>.</xsl:comment><xsl:text>&#10;</xsl:text>
        <ejb-jar xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                 version="4.0"
                 xsi:schemaLocation="https://jakarta.ee/xml/ns/jakartaee https://jakarta.ee/xml/ns/jakartaee/ejb-jar_4_0.xsd">
            <enterprise-beans>
                <xsl:call-template name="tokenize">
                    <xsl:with-param name="text" select="normalize-space($testRunners)"/>
                </xsl:call-template>
            </enterprise-beans>
        </ejb-jar>
    </xsl:template>

    <!-- create session -->
    <xsl:template name="runner">
        <xsl:param name="runnerName"/>
        <xsl:param name="pus"/>
        <session>
            <ejb-name><xsl:value-of select="normalize-space($runnerName)"/></ejb-name>
            <xsl:apply-templates select="$pus" mode="ctx"/>
            <xsl:apply-templates select="$pus" mode="unit"/>
        </session>
    </xsl:template>

    <!-- create persistence-context-ref -->
    <xsl:template match="*[local-name() = 'persistence-unit']" mode="ctx">
        <xsl:call-template name="ref">
            <xsl:with-param name="puName" select="@name"/>
            <xsl:with-param name="refType" select="'context'"/>
            <xsl:with-param name="type" select="'entity-manager'"/>
        </xsl:call-template>
    </xsl:template>

    <!-- create persistence-unit-ref -->
    <xsl:template match="*[local-name() = 'persistence-unit']" mode="unit">
        <xsl:call-template name="ref">
            <xsl:with-param name="puName" select="@name"/>
            <xsl:with-param name="refType" select="'unit'"/>
            <xsl:with-param name="type" select="'factory'"/>
        </xsl:call-template>
    </xsl:template>

    <!-- create persistence-${refType}-ref element -->
    <xsl:template name="ref">
        <xsl:param name="puName"/>
        <xsl:param name="refType"/>
        <xsl:param name="type"/>
        <xsl:variable name="elName" select="concat('persistence-', $refType, '-ref')"/>
        <xsl:element name="{$elName}">
            <xsl:element name="{concat($elName, '-name')}">persistence/<xsl:value-of select="normalize-space($puName)"/>/<xsl:value-of
                    select="normalize-space($type)"/>
            </xsl:element>
            <persistence-unit-name>
                <xsl:value-of select="$puName"/>
            </persistence-unit-name>
        </xsl:element>
    </xsl:template>

    <xsl:template name="tokenize">
        <xsl:param name="text"/>
        <xsl:param name="s" select="$separator"/>
        <xsl:if test="$text != ''">
            <xsl:choose>
                <xsl:when test="not(contains($text, $s))">
                    <xsl:if test="not(//*[@path=$text])">
                        <xsl:call-template name="runner">
                            <xsl:with-param name="runnerName" select="normalize-space($text)"/>
                            <xsl:with-param name="pus" select="$persistenceUnits"/>
                        </xsl:call-template>
                    </xsl:if>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="norm" select="normalize-space(substring-before($text, $s))"/>
                    <xsl:if test="not(//*[@path=$norm])">
                        <xsl:call-template name="runner">
                            <xsl:with-param name="runnerName" select="$norm"/>
                            <xsl:with-param name="pus" select="$persistenceUnits"/>
                        </xsl:call-template>
                    </xsl:if>
                    <xsl:call-template name="tokenize">
                        <xsl:with-param name="text" select="normalize-space(substring-after($text, $s))"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>
