/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis;

import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.resource.cci.RecordFactory;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.eis.EISPlatform;
import org.eclipse.persistence.eis.interactions.EISInteraction;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.databaseaccess.DatasourceAccessor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.Call;

public class EISAccessor
extends DatasourceAccessor {
    protected Connection cciConnection;
    protected RecordFactory recordFactory;

    protected void basicBeginTransaction(AbstractSession session) throws EISException {
        try {
            if (this.getEISPlatform().supportsLocalTransactions()) {
                this.getCCIConnection().getLocalTransaction().begin();
            }
        }
        catch (ResourceException exception) {
            throw EISException.resourceException(exception, this, session);
        }
    }

    protected void closeDatasourceConnection() {
        try {
            this.getCCIConnection().close();
        }
        catch (ResourceException exception) {
            throw EISException.resourceException(exception, this, null);
        }
    }

    protected void basicCommitTransaction(AbstractSession session) throws EISException {
        try {
            if (this.getEISPlatform().supportsLocalTransactions()) {
                this.getCCIConnection().getLocalTransaction().commit();
            }
        }
        catch (ResourceException exception) {
            throw EISException.resourceException(exception, this, session);
        }
    }

    protected void buildConnectLog(AbstractSession session) {
        try {
            if (session.shouldLog(4, "connection")) {
                ConnectionMetaData metaData = this.getCCIConnection().getMetaData();
                Object[] args = new Object[]{metaData.getUserName(), metaData.getEISProductName(), metaData.getEISProductVersion(), Helper.cr(), "\t"};
                session.log(4, "connection", "connected_user_database", args, this);
            }
        }
        catch (ResourceException exception) {
            session.warning("JDBC_driver_does_not_support_meta_data", "connection");
        }
    }

    public Object executeCall(Call call, AbstractRecord translationRow, AbstractSession session) throws DatabaseException {
        return this.basicExecuteCall(call, translationRow, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object basicExecuteCall(Call call, AbstractRecord translationRow, AbstractSession session) throws DatabaseException {
        boolean autoCommit;
        if (this.getLogin() == null) {
            throw DatabaseException.databaseAccessorNotConnected();
        }
        Interaction interaction = null;
        Object var5_5 = null;
        EISInteraction eisCall = null;
        try {
            eisCall = (EISInteraction)call;
        }
        catch (ClassCastException e) {
            throw QueryException.invalidDatabaseCall(call);
        }
        boolean bl = autoCommit = !this.isInTransaction() && this.getEISPlatform().requiresAutoCommit();
        if (autoCommit) {
            this.beginTransaction(session);
        }
        try {
            if (session.shouldLog(3, "sql")) {
                session.log(3, "sql", call.getLogString(this), null, this, false);
            }
            this.incrementCallCount(session);
            session.startOperationProfile("Timer:SqlPrepare", eisCall.getQuery(), Integer.MAX_VALUE);
            Record input = null;
            Record output = null;
            try {
                interaction = this.getCCIConnection().createInteraction();
                input = this.getEISPlatform().createInputRecord(eisCall, this);
                output = this.getEISPlatform().createOutputRecord(eisCall, this);
                Object var11_23 = null;
                session.endOperationProfile("Timer:SqlPrepare", eisCall.getQuery(), Integer.MAX_VALUE);
            }
            catch (Throwable throwable) {
                Object var11_24 = null;
                session.endOperationProfile("Timer:SqlPrepare", eisCall.getQuery(), Integer.MAX_VALUE);
                throw throwable;
            }
            session.startOperationProfile("Timer:StatementExecute", eisCall.getQuery(), Integer.MAX_VALUE);
            try {
                InteractionSpec interactionSpec = this.getEISPlatform().buildInteractionSpec(eisCall);
                if (output == null) {
                    output = interaction.execute(interactionSpec, input);
                } else {
                    interaction.execute(interactionSpec, input, output);
                }
                session.log(1, "query", "adapter_result", output);
                if (eisCall.isNothingReturned()) {
                    AbstractRecord outputRow;
                    Integer n = 1;
                    if (output != null && (outputRow = this.getEISPlatform().buildRow(output, eisCall, this)) != null) {
                        eisCall.getQuery().setProperty("output", outputRow);
                        if (session.hasEventManager()) {
                            session.getEventManager().outputParametersDetected(outputRow, eisCall);
                        }
                    }
                } else if (eisCall.isOneRowReturned()) {
                    AbstractRecord abstractRecord = this.getEISPlatform().buildRow(output, eisCall, this);
                } else {
                    Vector vector = this.getEISPlatform().buildRows(output, eisCall, this);
                }
                session.log(1, "query", "data_access_result", output);
                Object var13_30 = null;
                session.endOperationProfile("Timer:StatementExecute", eisCall.getQuery(), Integer.MAX_VALUE);
            }
            catch (Throwable throwable) {
                Object var13_31 = null;
                session.endOperationProfile("Timer:StatementExecute", eisCall.getQuery(), Integer.MAX_VALUE);
                throw throwable;
            }
        }
        catch (ResourceException exception) {
            try {
                interaction.close();
            }
            catch (Exception closeException) {
                // empty catch block
            }
            try {
                this.decrementCallCount();
            }
            catch (Exception closeException) {
                // empty catch block
            }
            try {
                if (!autoCommit) throw EISException.resourceException(exception, call, this, session);
                this.commitTransaction(session);
                throw EISException.resourceException(exception, call, this, session);
            }
            catch (Exception closeException) {
                // empty catch block
            }
            throw EISException.resourceException(exception, call, this, session);
        }
        catch (RuntimeException exception) {
            try {
                try {
                    interaction.close();
                    Object var15_33 = null;
                    if (!autoCommit) throw exception;
                }
                catch (Throwable throwable) {
                    Object var15_34 = null;
                    if (!autoCommit) throw throwable;
                    this.commitTransaction(session);
                    throw throwable;
                }
                this.commitTransaction(session);
                {
                    throw exception;
                }
            }
            catch (Exception closeException) {
                // empty catch block
            }
            throw exception;
        }
        boolean transactionCommitted = false;
        boolean countDecremented = false;
        try {
            void var5_9;
            interaction.close();
            if (autoCommit) {
                this.commitTransaction(session);
            }
            transactionCommitted = true;
            this.decrementCallCount();
            return var5_9;
        }
        catch (ResourceException exception) {
            try {
                if (!transactionCommitted && autoCommit) {
                    this.commitTransaction(session);
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                if (countDecremented) throw EISException.resourceException(exception, this, session);
                this.decrementCallCount();
                throw EISException.resourceException(exception, this, session);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw EISException.resourceException(exception, this, session);
        }
    }

    public Connection getCCIConnection() {
        return (Connection)this.getDatasourceConnection();
    }

    public EISPlatform getEISPlatform() {
        return (EISPlatform)this.getDatasourcePlatform();
    }

    public RecordFactory getRecordFactory() {
        return this.recordFactory;
    }

    public void setRecordFactory(RecordFactory recordFactory) {
        this.recordFactory = recordFactory;
    }

    public void basicRollbackTransaction(AbstractSession session) throws DatabaseException {
        try {
            if (this.getEISPlatform().supportsLocalTransactions()) {
                this.getCCIConnection().getLocalTransaction().rollback();
            }
        }
        catch (ResourceException exception) {
            throw EISException.resourceException(exception, this, session);
        }
    }

    protected boolean isDatasourceConnected() {
        return this.isConnected;
    }
}

