/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLUnionField;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;

public class TypeNodeValue
extends NodeValue {
    private AbstractDirectMapping directMapping;

    public boolean isOwningNode(XPathFragment xPathFragment) {
        return null != xPathFragment && xPathFragment.isAttribute();
    }

    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver) {
        return this.marshal(xPathFragment, marshalRecord, object, session, namespaceResolver, ObjectMarshalContext.getInstance());
    }

    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        Object objectValue = this.directMapping.getAttributeValueFromObject(object);
        return this.marshalSingleValue(xPathFragment, marshalRecord, object, objectValue, session, namespaceResolver, marshalContext);
    }

    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object objectValue, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        Object fieldValue = this.directMapping.getFieldValue(objectValue, session);
        if (null == fieldValue || null == namespaceResolver) {
            return false;
        }
        XMLField xmlField = (XMLField)this.directMapping.getField();
        QName schemaType = this.getSchemaType(xmlField, fieldValue, session);
        if (null == schemaType) {
            return false;
        }
        if (xmlField.getSchemaType() == null ? schemaType.equals(XMLConstants.STRING_QNAME) : xmlField.isSchemaType(schemaType)) {
            return false;
        }
        XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
        String typeQName = namespaceResolver.resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance") + ':' + "type";
        String schemaTypePrefix = namespaceResolver.resolveNamespaceURI(schemaType.getNamespaceURI());
        if (schemaTypePrefix == null) {
            schemaTypePrefix = "http://www.w3.org/2001/XMLSchema".equals(schemaType.getNamespaceURI()) ? namespaceResolver.generatePrefix("xsd") : namespaceResolver.generatePrefix();
            marshalRecord.namespaceDeclaration(schemaTypePrefix, schemaType.getNamespaceURI());
        }
        marshalRecord.attribute("http://www.w3.org/2001/XMLSchema-instance", "type", typeQName, schemaTypePrefix + ':' + schemaType.getLocalPart());
        marshalRecord.closeStartGroupingElements(groupingFragment);
        return true;
    }

    public AbstractDirectMapping getDirectMapping() {
        return this.directMapping;
    }

    public void setDirectMapping(AbstractDirectMapping directMapping) {
        this.directMapping = directMapping;
    }

    private QName getSchemaType(XMLField xmlField, Object value, AbstractSession session) {
        QName schemaType = null;
        if (xmlField.isTypedTextField()) {
            schemaType = xmlField.getXMLType(value.getClass());
        } else {
            if (xmlField.isUnionField()) {
                return this.getSchemaTypeForUnion((XMLUnionField)xmlField, value, session);
            }
            if (xmlField.getSchemaType() != null) {
                schemaType = xmlField.getSchemaType();
            }
        }
        return schemaType;
    }

    private QName getSchemaTypeForUnion(XMLUnionField xmlField, Object value, AbstractSession session) {
        ArrayList schemaTypes = xmlField.getSchemaTypes();
        QName schemaType = null;
        for (int i = 0; i < schemaTypes.size(); ++i) {
            QName nextQName = (QName)xmlField.getSchemaTypes().get(i);
            try {
                if (nextQName == null) continue;
                Class javaClass = xmlField.getJavaClass(nextQName);
                value = ((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(value, javaClass, nextQName);
                schemaType = nextQName;
                break;
            }
            catch (ConversionException ce) {
                if (i != schemaTypes.size() - 1) continue;
                schemaType = nextQName;
            }
        }
        return schemaType;
    }

    public void attribute(UnmarshalRecord unmarshalRecord, String namespaceURI, String localName, String value) {
        if (value != null) {
            String namespace = null;
            int colonIndex = value.indexOf(58);
            if (colonIndex > -1) {
                String prefix = value.substring(0, colonIndex);
                namespace = unmarshalRecord.resolveNamespacePrefix(prefix);
                value = value.substring(colonIndex + 1);
            }
            unmarshalRecord.setTypeQName(new QName(namespace, value));
        }
    }
}

