/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.queries.DatabaseQueryMechanism;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.UpdateAllQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;

public class DatasourceCallQueryMechanism
extends DatabaseQueryMechanism {
    protected DatasourceCall call;
    protected Vector calls;

    public DatasourceCallQueryMechanism(DatabaseQuery query) {
        super(query);
    }

    public DatasourceCallQueryMechanism(DatabaseQuery query, DatasourceCall call) {
        super(query);
        this.call = call;
        call.setQuery(query);
    }

    public void addCall(DatasourceCall call) {
        this.getCalls().addElement(call);
        call.setQuery(this.getQuery());
    }

    public DatabaseCall cursorSelectAllRows() throws DatabaseException {
        try {
            return (DatabaseCall)this.executeCall();
        }
        catch (ClassCastException e) {
            throw QueryException.mustUseCursorStreamPolicy();
        }
    }

    public Integer deleteAll() throws DatabaseException {
        if (((DeleteAllQuery)this.query).isPreparedUsingTempStorage()) {
            return this.deleteAllUsingTempTables();
        }
        if (this.hasMultipleCalls()) {
            Integer returnedRowCount = null;
            for (int index = this.getCalls().size() - 1; index >= 0; --index) {
                DatasourceCall databseCall = (DatasourceCall)this.getCalls().elementAt(index);
                returnedRowCount = (Integer)this.executeCall(databseCall);
            }
            return returnedRowCount;
        }
        return (Integer)this.executeCall();
    }

    public Integer deleteAllUsingTempTables() throws DatabaseException {
        DatasourceCall databseCall;
        DatabaseException ex = null;
        Integer returnedRowCount = null;
        try {
            databseCall = (DatasourceCall)this.getCalls().elementAt(this.getCalls().size() - 1);
            this.executeCall(databseCall);
        }
        catch (DatabaseException databaseEx) {
            // empty catch block
        }
        if (ex == null) {
            try {
                databseCall = (DatasourceCall)this.getCalls().elementAt(this.getCalls().size() - 2);
                this.executeCall(databseCall);
            }
            catch (DatabaseException databaseEx) {
                ex = databaseEx;
            }
        }
        for (int index = this.getCalls().size() - 3; index >= 1 && ex == null; --index) {
            DatasourceCall databseCall2 = (DatasourceCall)this.getCalls().elementAt(index);
            try {
                returnedRowCount = (Integer)this.executeCall(databseCall2);
                continue;
            }
            catch (DatabaseException databaseEx) {
                ex = databaseEx;
            }
        }
        try {
            DatasourceCall databseCall3 = (DatasourceCall)this.getCalls().elementAt(0);
            this.executeCall(databseCall3);
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
        if (ex != null) {
            throw ex;
        }
        return returnedRowCount;
    }

    public Integer deleteObject() throws DatabaseException {
        if (this.hasMultipleCalls()) {
            Integer returnedRowCount = null;
            for (int index = this.getCalls().size() - 1; index >= 0; --index) {
                DatasourceCall databseCall = (DatasourceCall)this.getCalls().elementAt(index);
                Integer rowCount = (Integer)this.executeCall(databseCall);
                if (index != this.getCalls().size() - 1 && rowCount > 0) continue;
                returnedRowCount = rowCount;
            }
            return returnedRowCount;
        }
        return (Integer)this.executeCall();
    }

    protected Object executeCall() throws DatabaseException {
        return this.executeCall(this.call);
    }

    protected Object executeCall(DatasourceCall databaseCall) throws DatabaseException {
        AbstractSession sessionToUse = this.query.getExecutionSession();
        DatasourceCall clonedCall = (DatasourceCall)databaseCall.clone();
        clonedCall.setQuery(this.query);
        clonedCall.translate(this.query.getTranslationRow(), this.getModifyRow(), sessionToUse);
        return sessionToUse.executeCall(clonedCall, this.query.getTranslationRow(), this.query);
    }

    public Integer executeNoSelect() throws DatabaseException {
        return this.executeNoSelectCall();
    }

    public Integer executeNoSelectCall() throws DatabaseException {
        if (this.hasMultipleCalls()) {
            Integer returnedRowCount = null;
            for (int index = 0; index < this.getCalls().size(); ++index) {
                DatasourceCall databseCall = (DatasourceCall)this.getCalls().elementAt(index);
                Integer rowCount = (Integer)this.executeCall(databseCall);
                if (index != 0 && rowCount > 0) continue;
                returnedRowCount = rowCount;
            }
            return returnedRowCount;
        }
        return (Integer)this.executeCall();
    }

    public Vector executeSelect() throws DatabaseException {
        return this.executeSelectCall();
    }

    public Vector executeSelectCall() throws DatabaseException {
        if (this.hasMultipleCalls()) {
            Vector results = new Vector();
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatasourceCall databseCall = (DatasourceCall)callsEnum.nextElement();
                Helper.addAllToVector(results, (Vector)this.executeCall(databseCall));
            }
            return results;
        }
        return (Vector)this.executeCall();
    }

    public DatasourceCall getCall() {
        return this.call;
    }

    public Vector getCalls() {
        if (this.calls == null) {
            this.calls = NonSynchronizedVector.newInstance(3);
        }
        return this.calls;
    }

    public boolean hasMultipleCalls() {
        return this.calls != null && !this.calls.isEmpty();
    }

    public void insertObject() throws DatabaseException {
        ClassDescriptor descriptor = this.getDescriptor();
        boolean usesSequencing = descriptor.usesSequenceNumbers();
        boolean shouldAcquireValueAfterInsert = false;
        if (usesSequencing) {
            shouldAcquireValueAfterInsert = descriptor.getSequence().shouldAcquireValueAfterInsert();
        }
        Collection<DatabaseField> returnFields = null;
        if (descriptor.hasReturningPolicy()) {
            returnFields = descriptor.getReturningPolicy().getFieldsToMergeInsert();
        }
        if (usesSequencing && !shouldAcquireValueAfterInsert && this.getWriteObjectQuery().getObjectChangeSet() == null) {
            this.updateObjectAndRowWithSequenceNumber();
        }
        if (this.hasMultipleCalls()) {
            int size = this.calls.size();
            for (int index = 0; index < size; ++index) {
                DatasourceCall databseCall = (DatasourceCall)this.calls.get(index);
                if (index > 0 && this.isExpressionQueryMechanism() && this.query.shouldCascadeOnlyDependentParts() && !descriptor.hasMultipleTableConstraintDependecy()) {
                    DatabaseTable table = descriptor.getMultipleTableInsertOrder().get(index);
                    this.query.getSession().getCommitManager().addDeferredCall(table, databseCall, this);
                    continue;
                }
                Object result = this.executeCall(databseCall);
                if (result instanceof AbstractRecord) {
                    this.query.setProperty("output", result);
                }
                if (returnFields != null) {
                    this.updateObjectAndRowWithReturnRow(returnFields, index == 0);
                }
                if (index != 0 || !usesSequencing || !shouldAcquireValueAfterInsert) continue;
                this.updateObjectAndRowWithSequenceNumber();
            }
        } else {
            Object result = this.executeCall();
            if (result instanceof AbstractRecord) {
                this.query.setProperty("output", result);
            }
            if (returnFields != null) {
                this.updateObjectAndRowWithReturnRow(returnFields, true);
            }
            if (usesSequencing && shouldAcquireValueAfterInsert) {
                this.updateObjectAndRowWithSequenceNumber();
            }
        }
        AbstractSession executionSession = this.query.getExecutionSession();
        for (Accessor accessor : executionSession.getAccessors()) {
            accessor.flushSelectCalls(executionSession);
        }
    }

    public void executeDeferredCall(DatasourceCall call) {
        Object result = this.executeCall(call);
        if (result instanceof AbstractRecord) {
            this.query.setProperty("output", result);
        }
        Collection<DatabaseField> returnFields = null;
        if (this.query.getDescriptor().hasReturningPolicy()) {
            returnFields = this.query.getDescriptor().getReturningPolicy().getFieldsToMergeInsert();
        }
        if (returnFields != null) {
            this.updateObjectAndRowWithReturnRow(returnFields, false);
        }
    }

    public boolean isCallQueryMechanism() {
        return true;
    }

    public void prepare() {
        if (!this.hasMultipleCalls() && this.getCall() == null) {
            throw QueryException.sqlStatementNotSetProperly(this.getQuery());
        }
    }

    public void prepareCall() throws QueryException {
        DatabaseQuery query = this.getQuery();
        AbstractSession executionSession = query.getExecutionSession();
        if (this.hasMultipleCalls()) {
            for (DatasourceCall call : this.getCalls()) {
                call.prepare(executionSession);
            }
        } else if (this.getCall() != null) {
            this.getCall().prepare(executionSession);
        }
    }

    public void prepareCursorSelectAllRows() throws QueryException {
        this.getCall().returnCursor();
        this.prepareCall();
    }

    public void prepareDeleteAll() {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatasourceCall call = (DatasourceCall)callsEnum.nextElement();
                call.returnNothing();
            }
        } else {
            this.getCall().returnNothing();
        }
        this.prepareCall();
    }

    public void prepareDeleteObject() {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatasourceCall call = (DatasourceCall)callsEnum.nextElement();
                call.returnNothing();
            }
        } else {
            this.getCall().returnNothing();
        }
        this.prepareCall();
    }

    public void prepareDoesExist(DatabaseField field) {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                ((DatasourceCall)callsEnum.nextElement()).returnOneRow();
            }
        } else {
            this.getCall().returnOneRow();
        }
        this.prepareCall();
    }

    public void prepareExecuteNoSelect() {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                ((DatasourceCall)callsEnum.nextElement()).returnNothing();
            }
        } else {
            this.getCall().returnNothing();
        }
        this.prepareCall();
    }

    public void prepareExecuteSelect() {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatasourceCall databseCall = (DatasourceCall)callsEnum.nextElement();
                databseCall.returnManyRows();
            }
        } else {
            this.getCall().returnManyRows();
        }
        this.prepareCall();
    }

    public void prepareInsertObject() {
        if (this.hasMultipleCalls()) {
            int size = this.calls.size();
            for (int index = 0; index < size; ++index) {
                DatabaseCall call = (DatabaseCall)this.calls.get(index);
                if (call.isReturnSet()) continue;
                call.returnNothing();
            }
        } else if (!this.call.isReturnSet()) {
            this.call.returnNothing();
        }
        this.prepareCall();
    }

    protected void prepareReportQueryItems() {
        ReportQuery query = (ReportQuery)this.getQuery();
        int itemOffset = query.getQueryExpressions().size();
        for (ReportItem item : query.getItems()) {
            item.setResultIndex(itemOffset);
            if (item.getAttributeExpression() == null) continue;
            if (item.hasJoining()) {
                itemOffset = item.getJoinedAttributeManager().computeJoiningMappingIndexes(true, this.getSession(), itemOffset);
                continue;
            }
            if (item.getDescriptor() != null) {
                itemOffset += item.getDescriptor().getAllFields().size();
                continue;
            }
            ++itemOffset;
        }
    }

    public void prepareReportQuerySelectAllRows() {
        this.prepareReportQueryItems();
        this.prepareExecuteSelect();
    }

    public void prepareReportQuerySubSelect() {
        this.prepareReportQueryItems();
        this.prepareCall();
    }

    public void prepareSelectAllRows() {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatasourceCall databseCall = (DatasourceCall)callsEnum.nextElement();
                databseCall.returnManyRows();
            }
        } else {
            this.getCall().returnManyRows();
        }
        this.prepareCall();
    }

    public void prepareSelectOneRow() {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatasourceCall databseCall = (DatasourceCall)callsEnum.nextElement();
                databseCall.returnOneRow();
            }
        } else {
            this.getCall().returnOneRow();
        }
        this.prepareCall();
    }

    public void prepareUpdateObject() {
        if (this.hasMultipleCalls()) {
            int size = this.calls.size();
            for (int index = 0; index < size; ++index) {
                DatabaseCall call = (DatabaseCall)this.calls.get(index);
                if (call.isReturnSet()) continue;
                call.returnNothing();
            }
        } else if (this.getCall() != null && !this.call.isReturnSet()) {
            this.call.returnNothing();
        }
        this.prepareCall();
    }

    public void prepareUpdateAll() {
        if (this.getCall() != null) {
            this.getCall().returnNothing();
        }
        this.prepareCall();
    }

    public Vector selectAllReportQueryRows() throws DatabaseException {
        return this.executeSelect();
    }

    public Vector selectAllRows() throws DatabaseException {
        return this.executeSelectCall();
    }

    public AbstractRecord selectOneRow() throws DatabaseException {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatasourceCall databaseCall = (DatasourceCall)callsEnum.nextElement();
                AbstractRecord result = (AbstractRecord)this.executeCall(databaseCall);
                if (result == null) continue;
                return result;
            }
            return null;
        }
        return (AbstractRecord)this.executeCall();
    }

    public AbstractRecord selectRowForDoesExist(DatabaseField field) throws DatabaseException {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatasourceCall databaseCall = (DatasourceCall)callsEnum.nextElement();
                AbstractRecord result = (AbstractRecord)this.executeCall(databaseCall);
                if (result == null) continue;
                return result;
            }
            return null;
        }
        return (AbstractRecord)this.executeCall();
    }

    public void setCall(DatasourceCall call) {
        this.call = call;
        if (call != null) {
            call.setQuery(this.getQuery());
        }
    }

    protected void setCalls(Vector calls) {
        this.calls = calls;
    }

    public Integer updateObject() throws DatabaseException {
        Collection<DatabaseField> returnFields = null;
        ClassDescriptor descriptor = this.getDescriptor();
        if (descriptor.hasReturningPolicy()) {
            returnFields = descriptor.getReturningPolicy().getFieldsToMergeUpdate();
        }
        Integer returnedRowCount = null;
        if (this.hasMultipleCalls()) {
            int size = this.calls.size();
            for (int index = 0; index < size; ++index) {
                Integer rowCount;
                DatasourceCall databseCall = (DatasourceCall)this.calls.get(index);
                if (index > 0 && this.isExpressionQueryMechanism() && this.query.shouldCascadeOnlyDependentParts() && !descriptor.hasMultipleTableConstraintDependecy()) {
                    DatabaseTable table = descriptor.getMultipleTableInsertOrder().get(index);
                    this.query.getSession().getCommitManager().addDeferredCall(table, databseCall, this);
                    continue;
                }
                Object result = this.executeCall(databseCall);
                if (result instanceof AbstractRecord) {
                    this.query.setProperty("output", result);
                    rowCount = 1;
                } else {
                    rowCount = (Integer)result;
                }
                if (index == 0 || rowCount <= 0) {
                    returnedRowCount = rowCount;
                }
                if (returnFields == null) continue;
                this.updateObjectAndRowWithReturnRow(returnFields, false);
            }
        } else {
            Object result = this.executeCall();
            if (result instanceof AbstractRecord) {
                this.query.setProperty("output", result);
                returnedRowCount = 1;
            } else {
                returnedRowCount = (Integer)result;
            }
            if (returnFields != null) {
                this.updateObjectAndRowWithReturnRow(returnFields, false);
            }
        }
        AbstractSession executionSession = this.query.getExecutionSession();
        for (Accessor accessor : executionSession.getAccessors()) {
            accessor.flushSelectCalls(executionSession);
        }
        return returnedRowCount;
    }

    public Integer updateAll() throws DatabaseException {
        if (((UpdateAllQuery)this.query).isPreparedUsingTempStorage() && this.getExecutionSession().getPlatform().supportsTempTables()) {
            return this.updateAllUsingTempTables();
        }
        Integer rowCount = this.executeNoSelectCall();
        if (((UpdateAllQuery)this.query).isPreparedUsingTempStorage()) {
            AbstractRecord outputRow = (AbstractRecord)this.query.getProperty("output");
            rowCount = (Integer)outputRow.get("ROW_COUNT");
        }
        return rowCount;
    }

    public Integer updateAllUsingTempTables() throws DatabaseException {
        DatasourceCall databseCall;
        int index;
        int nTables = this.getCalls().size() / 4;
        DatabaseException ex = null;
        Integer returnedRowCount = null;
        for (index = 0; index < nTables; ++index) {
            try {
                databseCall = (DatasourceCall)this.getCalls().elementAt(index);
                this.executeCall(databseCall);
                continue;
            }
            catch (DatabaseException databaseEx) {
                // empty catch block
            }
        }
        for (index = nTables; index < nTables * 2 && ex == null; ++index) {
            try {
                databseCall = (DatasourceCall)this.getCalls().elementAt(index);
                this.executeCall(databseCall);
                continue;
            }
            catch (DatabaseException databaseEx) {
                ex = databaseEx;
            }
        }
        for (index = nTables * 2; index < nTables * 3 && ex == null; ++index) {
            try {
                databseCall = (DatasourceCall)this.getCalls().elementAt(index);
                Integer rowCount = (Integer)this.executeCall(databseCall);
                if (index != nTables * 2 && rowCount > 0) continue;
                returnedRowCount = rowCount;
                continue;
            }
            catch (DatabaseException databaseEx) {
                ex = databaseEx;
            }
        }
        for (index = nTables * 3; index < nTables * 4; ++index) {
            try {
                databseCall = (DatasourceCall)this.getCalls().elementAt(index);
                this.executeCall(databseCall);
                continue;
            }
            catch (DatabaseException databaseEx) {
                // empty catch block
            }
        }
        if (ex != null) {
            throw ex;
        }
        return returnedRowCount;
    }

    protected void updateForeignKeyFieldAfterInsert(WriteObjectQuery writeQuery) {
        writeQuery.setModifyRow(this.getDescriptor().getObjectBuilder().buildRow(writeQuery.getObject(), this.getSession(), DatabaseMapping.WriteType.INSERT));
        AbstractSession sessionToUse = this.query.getExecutionSession();
        Vector calls = ((DatasourceCallQueryMechanism)this.getDescriptor().getQueryManager().getUpdateQuery().getQueryMechanism()).getCalls();
        Enumeration stream = calls.elements();
        while (stream.hasMoreElements()) {
            DatasourceCall call = (DatasourceCall)((DatasourceCall)stream.nextElement()).clone();
            call.setQuery(writeQuery);
            sessionToUse.executeCall(call, this.getTranslationRow(), writeQuery);
        }
    }
}

