/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.FetchType;
import javax.persistence.MapKey;
import javax.persistence.MapKeyClass;
import javax.persistence.MapKeyColumn;
import javax.persistence.MapKeyEnumerated;
import javax.persistence.MapKeyJoinColumn;
import javax.persistence.MapKeyJoinColumns;
import javax.persistence.MapKeyTemporal;
import javax.persistence.OrderBy;
import javax.persistence.OrderColumn;
import org.eclipse.persistence.annotations.MapKeyConvert;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappedKeyMapAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.RelationshipAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.OrderColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.EnumeratedMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.TemporalMetadata;
import org.eclipse.persistence.internal.jpa.metadata.mappings.MapKeyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.mappings.OrderByMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.JoinTableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.EmbeddableMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionAccessor
extends RelationshipAccessor
implements MappedKeyMapAccessor {
    private ColumnMetadata m_mapKeyColumn;
    private EnumeratedMetadata m_mapKeyEnumerated;
    private List<AssociationOverrideMetadata> m_mapKeyAssociationOverrides = new ArrayList<AssociationOverrideMetadata>();
    private List<AttributeOverrideMetadata> m_mapKeyAttributeOverrides = new ArrayList<AttributeOverrideMetadata>();
    private List<JoinColumnMetadata> m_mapKeyJoinColumns = new ArrayList<JoinColumnMetadata>();
    private MapKeyMetadata m_mapKey;
    private MetadataClass m_mapKeyClass;
    private OrderByMetadata m_orderBy;
    private OrderColumnMetadata m_orderColumn;
    private String m_mapKeyConvert;
    private String m_mapKeyClassName;
    private TemporalMetadata m_mapKeyTemporal;

    protected CollectionAccessor(String xmlElement) {
        super(xmlElement);
    }

    protected CollectionAccessor(MetadataAnnotation annotation, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(annotation, accessibleObject, classAccessor);
        this.setMappedBy(annotation == null ? "" : (String)annotation.getAttribute("mappedBy"));
        if (this.isAnnotationPresent(OrderBy.class)) {
            this.m_orderBy = new OrderByMetadata(this.getAnnotation(OrderBy.class), this);
        }
        if (this.isAnnotationPresent(MapKey.class)) {
            this.m_mapKey = new MapKeyMetadata(this.getAnnotation(MapKey.class), this);
        }
        if (this.isAnnotationPresent(MapKeyClass.class)) {
            this.m_mapKeyClass = this.getMetadataClass((String)this.getAnnotation(MapKeyClass.class).getAttribute("value"));
        }
        if (this.isAnnotationPresent(MapKeyColumn.class)) {
            this.m_mapKeyColumn = new ColumnMetadata(this.getAnnotation(MapKeyColumn.class), this);
        }
        if (this.isAnnotationPresent(MapKeyJoinColumns.class)) {
            for (Object jColumn : (Object[])this.getAnnotation(MapKeyJoinColumns.class).getAttributeArray("value")) {
                this.m_mapKeyJoinColumns.add(new JoinColumnMetadata((MetadataAnnotation)jColumn, this));
            }
        }
        if (this.isAnnotationPresent(MapKeyJoinColumn.class)) {
            this.m_mapKeyJoinColumns.add(new JoinColumnMetadata(this.getAnnotation(MapKeyJoinColumn.class), this));
        }
        if (this.isAnnotationPresent(AttributeOverrides.class)) {
            for (Object attributeOverride : (Object[])this.getAnnotation(AttributeOverrides.class).getAttributeArray("value")) {
                this.addAttributeOverride(new AttributeOverrideMetadata((MetadataAnnotation)attributeOverride, this));
            }
        }
        if (this.isAnnotationPresent(AttributeOverride.class)) {
            this.addAttributeOverride(new AttributeOverrideMetadata(this.getAnnotation(AttributeOverride.class), this));
        }
        if (this.isAnnotationPresent(AssociationOverrides.class)) {
            for (Object associationOverride : (Object[])this.getAnnotation(AssociationOverrides.class).getAttributeArray("value")) {
                this.addAssociationOverride(new AssociationOverrideMetadata((MetadataAnnotation)associationOverride, this));
            }
        }
        if (this.isAnnotationPresent(AssociationOverride.class)) {
            this.addAssociationOverride(new AssociationOverrideMetadata(this.getAnnotation(AssociationOverride.class), this));
        }
        if (this.isAnnotationPresent(OrderColumn.class)) {
            this.m_orderColumn = new OrderColumnMetadata(this.getAnnotation(OrderColumn.class), this);
        }
        if (this.isAnnotationPresent(MapKeyEnumerated.class)) {
            this.m_mapKeyEnumerated = new EnumeratedMetadata(this.getAnnotation(MapKeyEnumerated.class), this);
        }
        if (this.isAnnotationPresent(MapKeyTemporal.class)) {
            this.m_mapKeyTemporal = new TemporalMetadata(this.getAnnotation(MapKeyTemporal.class), this);
        }
        if (this.isAnnotationPresent(MapKeyConvert.class)) {
            this.m_mapKeyConvert = (String)this.getAnnotation(MapKeyConvert.class).getAttribute("value");
        }
    }

    protected void addAssociationOverride(AssociationOverrideMetadata associationOverride) {
        if (associationOverride.getName().startsWith("key.")) {
            associationOverride.setName(associationOverride.getName().substring("key.".length()));
        }
        this.m_mapKeyAssociationOverrides.add(associationOverride);
    }

    protected void addAttributeOverride(AttributeOverrideMetadata attributeOverride) {
        if (attributeOverride.getName().startsWith("key.")) {
            attributeOverride.setName(attributeOverride.getName().substring("key.".length()));
        }
        this.m_mapKeyAttributeOverrides.add(attributeOverride);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof CollectionAccessor) {
            CollectionAccessor collectionAccessor = (CollectionAccessor)objectToCompare;
            if (!this.valuesMatch(this.m_mapKeyColumn, collectionAccessor.getMapKeyColumn())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKeyEnumerated, collectionAccessor.getMapKeyEnumerated())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKeyAssociationOverrides, collectionAccessor.getMapKeyAssociationOverrides())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKeyAttributeOverrides, collectionAccessor.getMapKeyAttributeOverrides())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKeyJoinColumns, collectionAccessor.getMapKeyJoinColumns())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKey, collectionAccessor.getMapKey())) {
                return false;
            }
            if (!this.valuesMatch(this.m_orderBy, collectionAccessor.getOrderBy())) {
                return false;
            }
            if (!this.valuesMatch(this.m_orderColumn, collectionAccessor.getOrderColumn())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKeyConvert, collectionAccessor.getMapKeyConvert())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKeyClassName, collectionAccessor.getMapKeyClassName())) {
                return false;
            }
            return this.valuesMatch(this.m_mapKeyTemporal, collectionAccessor.getMapKeyTemporal());
        }
        return false;
    }

    @Override
    protected ColumnMetadata getColumn(String loggingCtx) {
        if (loggingCtx.equals("metadata_default_key_column")) {
            if (this.m_mapKeyColumn == null) {
                return new ColumnMetadata(this.getAnnotation(MapKeyColumn.class), this);
            }
            return this.m_mapKeyColumn;
        }
        return super.getColumn(loggingCtx);
    }

    @Override
    public String getDefaultFetchType() {
        return FetchType.LAZY.name();
    }

    @Override
    public EnumeratedMetadata getEnumerated(boolean isForMapKey) {
        return this.getMapKeyEnumerated();
    }

    @Override
    public MapKeyMetadata getMapKey() {
        return this.m_mapKey;
    }

    @Override
    public List<AssociationOverrideMetadata> getMapKeyAssociationOverrides() {
        return this.m_mapKeyAssociationOverrides;
    }

    @Override
    public List<AttributeOverrideMetadata> getMapKeyAttributeOverrides() {
        return this.m_mapKeyAttributeOverrides;
    }

    @Override
    public MetadataClass getMapKeyClass() {
        return this.m_mapKeyClass;
    }

    public String getMapKeyClassName() {
        return this.m_mapKeyClassName;
    }

    @Override
    public ColumnMetadata getMapKeyColumn() {
        return this.m_mapKeyColumn;
    }

    @Override
    public String getMapKeyConvert() {
        return this.m_mapKeyConvert;
    }

    public EnumeratedMetadata getMapKeyEnumerated() {
        return this.m_mapKeyEnumerated;
    }

    @Override
    public List<JoinColumnMetadata> getMapKeyJoinColumns() {
        return this.m_mapKeyJoinColumns;
    }

    public TemporalMetadata getMapKeyTemporal() {
        return this.m_mapKeyTemporal;
    }

    public OrderByMetadata getOrderBy() {
        return this.m_orderBy;
    }

    protected OrderColumnMetadata getOrderColumn() {
        return this.m_orderColumn;
    }

    @Override
    public MetadataClass getReferenceClass() {
        if (this.m_referenceClass == null) {
            this.m_referenceClass = this.getTargetEntity();
            if (this.m_referenceClass.isVoid()) {
                this.m_referenceClass = this.getReferenceClassFromGeneric();
                if (this.m_referenceClass == null) {
                    throw ValidationException.unableToDetermineTargetEntity(this.getAttributeName(), this.getJavaClass());
                }
                this.getLogger().logConfigMessage(this.getLoggingContext(), this.getAnnotatedElement(), (Object)this.m_referenceClass);
            }
        }
        return this.m_referenceClass;
    }

    @Override
    protected DatabaseTable getReferenceDatabaseTable() {
        if (this.getMapping().isManyToManyMapping()) {
            return ((ManyToManyMapping)this.getMapping()).getRelationTable();
        }
        return super.getReferenceDatabaseTable();
    }

    @Override
    public TemporalMetadata getTemporal(boolean isForMapKey) {
        return this.getMapKeyTemporal();
    }

    @Override
    protected boolean hasConvert(boolean isForMapKey) {
        return isForMapKey ? this.m_mapKeyConvert != null : super.hasConvert(isForMapKey);
    }

    @Override
    public boolean hasEnumerated(boolean isForMapKey) {
        return isForMapKey ? this.m_mapKeyEnumerated != null : super.hasEnumerated(isForMapKey);
    }

    @Override
    public boolean hasMapKey() {
        return this.m_mapKey != null;
    }

    @Override
    public boolean hasTemporal(boolean isForMapKey) {
        return isForMapKey ? this.m_mapKeyTemporal != null : super.hasTemporal(isForMapKey);
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.m_mapKeyJoinColumns, accessibleObject);
        this.initXMLObjects(this.m_mapKeyAssociationOverrides, accessibleObject);
        this.initXMLObjects(this.m_mapKeyAttributeOverrides, accessibleObject);
        this.initXMLObject(this.m_mapKey, accessibleObject);
        this.initXMLObject(this.m_mapKeyColumn, accessibleObject);
        this.initXMLObject(this.m_orderBy, accessibleObject);
        this.initXMLObject(this.m_orderColumn, accessibleObject);
        this.m_mapKeyClass = this.initXMLClassName(this.m_mapKeyClassName);
    }

    @Override
    public boolean isCollectionAccessor() {
        return true;
    }

    @Override
    public void process() {
        super.process();
        if (!this.getAccessibleObject().isSupportedToManyCollectionClass(this.getRawClass())) {
            throw ValidationException.invalidCollectionTypeForRelationship(this.getJavaClass(), this.getRawClass(), this.getAttributeName());
        }
    }

    protected void process(CollectionMapping mapping) {
        this.processRelationshipMapping(mapping);
        if (this.m_orderBy != null) {
            this.m_orderBy.process(mapping, this.getReferenceDescriptor(), this.getJavaClass());
        }
        this.processContainerPolicyAndIndirection(mapping);
        this.processReturnInsertAndUpdate();
        if (this.m_orderColumn != null) {
            this.m_orderColumn.process(mapping, this.getDescriptor());
        }
    }

    @Override
    protected void processAssociationOverride(AssociationOverrideMetadata associationOverride, EmbeddableMapping embeddableMapping, MetadataDescriptor owningDescriptor) {
        if (this.getMapping().isManyToManyMapping()) {
            JoinTableMetadata joinTable = associationOverride.getJoinTable();
            String defaultName = owningDescriptor.getPrimaryTableName() + "_" + this.getReferenceDescriptor().getPrimaryTableName();
            this.processTable(joinTable, defaultName);
            ManyToManyMapping overrideMapping = new ManyToManyMapping();
            overrideMapping.setAttributeName(this.getAttributeName());
            this.processJoinTable(overrideMapping, overrideMapping.getRelationTableMechanism(), joinTable);
            embeddableMapping.addOverrideManyToManyMapping(overrideMapping);
            this.setOverrideMapping(overrideMapping);
        } else {
            super.processAssociationOverride(associationOverride, embeddableMapping, owningDescriptor);
        }
    }

    public void setMapKey(MapKeyMetadata mapKey) {
        this.m_mapKey = mapKey;
    }

    public void setMapKeyAssociationOverrides(List<AssociationOverrideMetadata> mapKeyAssociationOverrides) {
        this.m_mapKeyAssociationOverrides = mapKeyAssociationOverrides;
    }

    public void setMapKeyAttributeOverrides(List<AttributeOverrideMetadata> mapKeyAttributeOverrides) {
        this.m_mapKeyAttributeOverrides = mapKeyAttributeOverrides;
    }

    @Override
    public void setMapKeyClass(MetadataClass mapKeyClass) {
        this.m_mapKeyClass = mapKeyClass;
    }

    public void setMapKeyClassName(String mapKeyClassName) {
        this.m_mapKeyClassName = mapKeyClassName;
    }

    public void setMapKeyColumn(ColumnMetadata mapKeyColumn) {
        this.m_mapKeyColumn = mapKeyColumn;
    }

    public void setMapKeyConvert(String mapKeyConvert) {
        this.m_mapKeyConvert = mapKeyConvert;
    }

    public void setMapKeyEnumerated(EnumeratedMetadata mapKeyEnumerated) {
        this.m_mapKeyEnumerated = mapKeyEnumerated;
    }

    public void setMapKeyJoinColumns(List<JoinColumnMetadata> mapKeyJoinColumns) {
        this.m_mapKeyJoinColumns = mapKeyJoinColumns;
    }

    public void setMapKeyTemporal(TemporalMetadata mapKeyTemporal) {
        this.m_mapKeyTemporal = mapKeyTemporal;
    }

    public void setOrderBy(OrderByMetadata orderBy) {
        this.m_orderBy = orderBy;
    }

    public void setOrderColumn(OrderColumnMetadata orderColumn) {
        this.m_orderColumn = orderColumn;
    }
}

