/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record.namespaces;

import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.persistence.internal.oxm.record.namespaces.UnmarshalNamespaceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnmarshalNamespaceContext
implements UnmarshalNamespaceResolver {
    private XMLStreamReader xmlStreamReader;
    private Set<String> prefixes;

    public UnmarshalNamespaceContext() {
        this.prefixes = new HashSet<String>(4);
    }

    public UnmarshalNamespaceContext(XMLStreamReader anXMLStreamReader) {
        this.xmlStreamReader = anXMLStreamReader;
        this.prefixes = new HashSet<String>(4);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (null == prefix) {
            prefix = "";
        }
        try {
            String namespaceURI = this.xmlStreamReader.getNamespaceURI(prefix);
            if (null == namespaceURI) {
                return this.xmlStreamReader.getAttributeValue("http://www.w3.org/2000/xmlns/", prefix);
            }
            return namespaceURI;
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.xmlStreamReader.getNamespaceContext().getPrefix(namespaceURI);
    }

    @Override
    public void push(String prefix, String namespaceURI) {
        this.prefixes.add(prefix);
    }

    @Override
    public void pop(String prefix) {
        if (null != this.getNamespaceURI(prefix)) {
            this.prefixes.remove(prefix);
        }
    }

    @Override
    public Set<String> getPrefixes() {
        return this.prefixes;
    }

    public XMLStreamReader getXmlStreamReader() {
        return this.xmlStreamReader;
    }

    public void setXmlStreamReader(XMLStreamReader xmlStreamReader) {
        this.xmlStreamReader = xmlStreamReader;
    }
}

