/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import org.eclipse.persistence.jpa.jpql.DeclarationResolver;
import org.eclipse.persistence.jpa.jpql.DefaultSemanticValidator;
import org.eclipse.persistence.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.NullResolver;
import org.eclipse.persistence.jpa.jpql.Resolver;
import org.eclipse.persistence.jpa.jpql.ResolverVisitor;
import org.eclipse.persistence.jpa.jpql.StateFieldResolver;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;

public class SubqueryEntityResolver
extends Resolver {
    private AbstractSchemaName abstractSchemaName;
    private Resolver derivedPathResolver;
    private String entityName;
    private IManagedType managedType;
    private boolean managedTypeResolved;
    private JPQLQueryContext queryContext;

    public SubqueryEntityResolver(Resolver parent, JPQLQueryContext queryContext, AbstractSchemaName abstractSchemaName) {
        super(parent);
        this.queryContext = queryContext;
        this.abstractSchemaName = abstractSchemaName;
        this.entityName = abstractSchemaName.getText();
    }

    public void accept(ResolverVisitor visitor) {
    }

    protected IType buildType() {
        IManagedType entity = this.getManagedType();
        return entity != null ? entity.getType() : this.getTypeHelper().objectType();
    }

    protected ITypeDeclaration buildTypeDeclaration() {
        return this.getType().getTypeDeclaration();
    }

    public String getAbstractSchemaName() {
        return this.entityName;
    }

    public IManagedType getManagedType() {
        if (this.managedType == null && !this.managedTypeResolved) {
            this.managedTypeResolved = true;
            this.managedType = this.getProvider().getEntityNamed(this.entityName);
            if (this.managedType == null) {
                Resolver resolver = this.resolveDerivePathResolver();
                this.managedType = resolver.getManagedType();
            }
        }
        return this.managedType;
    }

    public IMapping getMapping() {
        if (this.derivedPathResolver != null) {
            return this.derivedPathResolver.getMapping();
        }
        if (this.getManagedType() == null && this.queryContext.isSubquery()) {
            Resolver resolver = this.resolveDerivePathResolver();
            return resolver.getMapping();
        }
        return super.getMapping();
    }

    protected Resolver resolveDerivePathResolver() {
        if (this.derivedPathResolver == null) {
            DefaultSemanticValidator.VirtualIdentificationVariableFinder finder = new DefaultSemanticValidator.VirtualIdentificationVariableFinder();
            this.abstractSchemaName.accept(finder);
            if (finder.expression != null) {
                DeclarationResolver parent = this.queryContext.getParent().getActualDeclarationResolver();
                Resolver resolver = parent.getResolver(finder.expression.getVariableName());
                Resolver childResolver = resolver.getChild(this.entityName);
                if (childResolver == null) {
                    childResolver = new StateFieldResolver(resolver, this.entityName);
                }
                this.derivedPathResolver = childResolver;
            }
            if (this.derivedPathResolver == null) {
                this.derivedPathResolver = new NullResolver(this);
            }
        }
        return this.derivedPathResolver;
    }

    public String toString() {
        return this.entityName;
    }
}

