/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.XMLMarshaller;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.XMLFragmentReader;
import org.eclipse.persistence.oxm.record.JSONWriterRecord;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class JSONFormattedWriterRecord
extends JSONWriterRecord {
    private String tab;
    private int numberOfTabs = 0;
    private boolean complexType = true;
    private boolean isLastEventText = false;

    public JSONFormattedWriterRecord() {
        this.space = " ";
    }

    public JSONFormattedWriterRecord(Writer writer) {
        this();
        this.setWriter(writer);
    }

    public JSONFormattedWriterRecord(Writer writer, String callbackName) {
        this(writer);
        this.setCallbackName(callbackName);
    }

    private String tab() {
        if (this.tab == null) {
            this.tab = ((XMLMarshaller)this.getMarshaller()).getIndentString();
        }
        return this.tab;
    }

    @Override
    public void startDocument(String encoding, String version) {
        super.startDocument(encoding, version);
        ++this.numberOfTabs;
    }

    @Override
    public void endDocument() {
        --this.numberOfTabs;
        super.endDocument();
    }

    @Override
    protected void closeComplex() throws IOException {
        this.writer.write(Helper.cr());
        int x = 0;
        while (x < this.numberOfTabs) {
            this.writeValue(this.tab(), false);
            ++x;
        }
        this.writer.write(125);
    }

    @Override
    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        try {
            JSONWriterRecord.Level newLevel = null;
            JSONWriterRecord.Level position = null;
            if (this.levels.isEmpty()) {
                newLevel = new JSONWriterRecord.Level(true, true);
                this.levels.push(newLevel);
            } else {
                position = (JSONWriterRecord.Level)this.levels.peek();
                newLevel = new JSONWriterRecord.Level(true, true);
                this.levels.push(newLevel);
                if (position.isFirst()) {
                    position.setFirst(false);
                } else {
                    this.writer.write(44);
                }
            }
            if (xPathFragment.nameIsText() && position != null && position.isCollection() && position.isEmptyCollection()) {
                if (!this.charactersAllowed) {
                    throw JAXBException.jsonValuePropertyRequired("[");
                }
                this.writer.write(91);
                this.writer.write(32);
                position.setEmptyCollection(false);
                position.setNeedToOpenComplex(false);
                ++this.numberOfTabs;
                return;
            }
            this.addPositionalNodes(xPathFragment, namespaceResolver);
            if (position.isNeedToOpenComplex()) {
                this.writer.write(123);
                position.setNeedToOpenComplex(false);
                position.setNeedToCloseComplex(true);
            }
            if (!this.isLastEventText) {
                if (position.isCollection() && !position.isEmptyCollection()) {
                    this.writer.write(32);
                } else {
                    this.writer.write(Helper.cr());
                    int x = 0;
                    while (x < this.numberOfTabs) {
                        this.writeValue(this.tab(), false);
                        ++x;
                    }
                }
            }
            if (!position.isCollection() || position.isEmptyCollection()) {
                super.writeKey(xPathFragment);
                if (position.isCollection() && position.isEmptyCollection()) {
                    this.writer.write(91);
                    this.writer.write(32);
                    position.setEmptyCollection(false);
                }
            }
            ++this.numberOfTabs;
            this.isLastEventText = false;
            this.charactersAllowed = true;
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    public void element(XPathFragment frag) {
        try {
            this.isLastEventText = false;
            if (this.isStartElementOpen) {
                this.writer.write(62);
                this.isStartElementOpen = false;
            }
            this.writer.write(Helper.cr());
            int x = 0;
            while (x < this.numberOfTabs) {
                this.writeValue(this.tab(), false);
                ++x;
            }
            super.element(frag);
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.isLastEventText = false;
        --this.numberOfTabs;
        super.endElement(xPathFragment, namespaceResolver);
    }

    @Override
    public void startCollection() {
        if (this.levels.isEmpty()) {
            try {
                super.startCollection();
                this.writer.write(32);
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        } else {
            super.startCollection();
        }
    }

    @Override
    protected void endEmptyCollection() {
        super.endCollection();
    }

    @Override
    public void endCollection() {
        try {
            this.writer.write(32);
            super.endCollection();
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    public void characters(String value) {
        super.characters(value);
        this.isLastEventText = true;
        this.complexType = false;
    }

    @Override
    public void node(Node node, NamespaceResolver namespaceResolver) {
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            String resolverPfx = null;
            if (this.getNamespaceResolver() != null) {
                resolverPfx = ((NamespaceResolver)this.getNamespaceResolver()).resolveNamespaceURI(attr.getNamespaceURI());
            }
            if (resolverPfx != null) {
                this.attribute(attr.getNamespaceURI(), "", String.valueOf(resolverPfx) + ':' + attr.getLocalName(), attr.getNodeValue());
            } else {
                this.attribute(attr.getNamespaceURI(), "", attr.getName(), attr.getNodeValue());
                if (attr.getNamespaceURI() != null) {
                    this.attribute("http://www.w3.org/2000/xmlns/", "", "xmlns:" + attr.getPrefix(), attr.getNamespaceURI());
                    ((NamespaceResolver)this.getNamespaceResolver()).put(attr.getPrefix(), attr.getNamespaceURI());
                }
            }
        } else if (node.getNodeType() == 3) {
            this.characters(node.getNodeValue(), false, false);
        } else {
            try {
                JSONFormattedWriterRecordContentHandler wrcHandler = new JSONFormattedWriterRecordContentHandler();
                XMLFragmentReader xfragReader = new XMLFragmentReader(namespaceResolver);
                xfragReader.setContentHandler(wrcHandler);
                xfragReader.setProperty("http://xml.org/sax/properties/lexical-handler", wrcHandler);
                xfragReader.parse(node);
            }
            catch (SAXException sex) {
                throw XMLMarshalException.marshalException(sex);
            }
        }
    }

    @Override
    protected void writeKey(XPathFragment xPathFragment) throws IOException {
        this.writer.write(Helper.cr());
        int x = 0;
        while (x < this.numberOfTabs) {
            this.writeValue(this.tab(), false);
            ++x;
        }
        super.writeKey(xPathFragment);
    }

    private class JSONFormattedWriterRecordContentHandler
    extends JSONWriterRecord.JSONWriterRecordContentHandler {
        private JSONFormattedWriterRecordContentHandler() {
            super(JSONFormattedWriterRecord.this);
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            XPathFragment xPathFragment = new XPathFragment(localName);
            xPathFragment.setNamespaceURI(namespaceURI);
            JSONFormattedWriterRecord.this.endElement(xPathFragment, JSONFormattedWriterRecord.this.namespaceResolver);
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            try {
                if (JSONFormattedWriterRecord.this.isStartElementOpen) {
                    JSONFormattedWriterRecord.this.writer.write(62);
                    JSONFormattedWriterRecord.this.writer.write(Helper.cr());
                    JSONFormattedWriterRecord.this.isStartElementOpen = false;
                }
                this.writeComment(ch, start, length);
                JSONFormattedWriterRecord.this.complexType = false;
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }
    }
}

