/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaConstructor;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.javamodel.JavaPackage;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaAnnotationImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaConstructorImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaFieldImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaMethodImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaModelImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaPackageImpl;

public class JavaClassImpl
implements JavaClass {
    protected ParameterizedType jType;
    protected Class jClass;
    protected JavaModelImpl javaModelImpl;
    protected boolean isMetadataComplete;
    protected JavaClass superClassOverride;
    protected static String XML_REGISTRY_CLASS_NAME = "javax.xml.bind.annotation.XmlRegistry";

    public JavaClassImpl(Class javaClass, JavaModelImpl javaModelImpl) {
        this.jClass = javaClass;
        this.javaModelImpl = javaModelImpl;
        this.isMetadataComplete = false;
    }

    public JavaClassImpl(ParameterizedType javaType, Class javaClass, JavaModelImpl javaModelImpl) {
        this.jType = javaType;
        this.jClass = javaClass;
        this.javaModelImpl = javaModelImpl;
        this.isMetadataComplete = false;
    }

    public void setJavaModelImpl(JavaModelImpl javaModel) {
        this.javaModelImpl = javaModel;
    }

    @Override
    public Collection getActualTypeArguments() {
        ArrayList<JavaClass> argCollection = new ArrayList<JavaClass>();
        if (this.jType instanceof ParameterizedType) {
            Type[] params;
            ParameterizedType pType = this.jType;
            Type[] typeArray = params = pType.getActualTypeArguments();
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                Type type = typeArray[n2];
                if (type instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)type;
                    argCollection.add(new JavaClassImpl(pt, (Class)pt.getRawType(), this.javaModelImpl));
                } else if (type instanceof WildcardType) {
                    Type upperType;
                    Type[] upperTypes = ((WildcardType)type).getUpperBounds();
                    if (upperTypes.length > 0 && (upperType = upperTypes[0]) instanceof Class) {
                        argCollection.add(this.javaModelImpl.getClass((Class)upperType));
                    }
                } else if (type instanceof Class) {
                    argCollection.add(this.javaModelImpl.getClass((Class)type));
                } else if (type instanceof GenericArrayType) {
                    Class<?> genericTypeClass = (Class<?>)((GenericArrayType)type).getGenericComponentType();
                    genericTypeClass = Array.newInstance(genericTypeClass, 0).getClass();
                    argCollection.add(this.javaModelImpl.getClass(genericTypeClass));
                }
                ++n2;
            }
        }
        return argCollection;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public JavaAnnotation getAnnotation(JavaClass arg0) {
        if (arg0 != null && (!this.isMetadataComplete || arg0.getQualifiedName().equals(XML_REGISTRY_CLASS_NAME))) {
            Class annotationClass = ((JavaClassImpl)arg0).getJavaClass();
            if (this.javaModelImpl.getAnnotationHelper().isAnnotationPresent(this.getAnnotatedElement(), annotationClass)) {
                return new JavaAnnotationImpl(this.javaModelImpl.getAnnotationHelper().getAnnotation(this.getAnnotatedElement(), annotationClass));
            }
        }
        return null;
    }

    @Override
    public Collection getAnnotations() {
        ArrayList<JavaAnnotationImpl> annotationCollection = new ArrayList<JavaAnnotationImpl>();
        if (!this.isMetadataComplete) {
            Annotation[] annotations;
            Annotation[] annotationArray = annotations = this.javaModelImpl.getAnnotationHelper().getAnnotations(this.getAnnotatedElement());
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                annotationCollection.add(new JavaAnnotationImpl(annotation));
                ++n2;
            }
        }
        return annotationCollection;
    }

    @Override
    public Collection getDeclaredClasses() {
        Class<?>[] classes;
        ArrayList<JavaClass> classCollection = new ArrayList<JavaClass>();
        Class<?>[] classArray = classes = this.jClass.getDeclaredClasses();
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> javaClass = classArray[n2];
            classCollection.add(this.javaModelImpl.getClass(javaClass));
            ++n2;
        }
        return classCollection;
    }

    @Override
    public JavaField getDeclaredField(String arg0) {
        try {
            return this.getJavaField(this.jClass.getDeclaredField(arg0));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    @Override
    public Collection getDeclaredFields() {
        Field[] fields;
        ArrayList<JavaField> fieldCollection = new ArrayList<JavaField>();
        Field[] fieldArray = fields = PrivilegedAccessHelper.getDeclaredFields(this.jClass);
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            field.setAccessible(true);
            fieldCollection.add(this.getJavaField(field));
            ++n2;
        }
        return fieldCollection;
    }

    @Override
    public JavaMethod getDeclaredMethod(String arg0, JavaClass[] arg1) {
        if (arg1 == null) {
            arg1 = new JavaClass[]{};
        }
        Class[] params = new Class[arg1.length];
        int i = 0;
        while (i < arg1.length) {
            JavaClass jType = arg1[i];
            if (jType != null) {
                params[i] = ((JavaClassImpl)jType).getJavaClass();
            }
            ++i;
        }
        try {
            return this.getJavaMethod(this.jClass.getDeclaredMethod(arg0, params));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    @Override
    public Collection getDeclaredMethods() {
        Method[] methods;
        ArrayList<JavaMethod> methodCollection = new ArrayList<JavaMethod>();
        Method[] methodArray = methods = this.jClass.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            methodCollection.add(this.getJavaMethod(method));
            ++n2;
        }
        return methodCollection;
    }

    @Override
    public JavaConstructor getConstructor(JavaClass[] paramTypes) {
        if (paramTypes == null) {
            paramTypes = new JavaClass[]{};
        }
        Class[] params = new Class[paramTypes.length];
        int i = 0;
        while (i < paramTypes.length) {
            JavaClass jType = paramTypes[i];
            if (jType != null) {
                params[i] = ((JavaClassImpl)jType).getJavaClass();
            }
            ++i;
        }
        try {
            Constructor constructor = PrivilegedAccessHelper.getConstructorFor(this.jClass, params, true);
            return new JavaConstructorImpl(constructor, this.javaModelImpl);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    @Override
    public JavaConstructor getDeclaredConstructor(JavaClass[] paramTypes) {
        if (paramTypes == null) {
            paramTypes = new JavaClass[]{};
        }
        Class[] params = new Class[paramTypes.length];
        int i = 0;
        while (i < paramTypes.length) {
            JavaClass jType = paramTypes[i];
            if (jType != null) {
                params[i] = ((JavaClassImpl)jType).getJavaClass();
            }
            ++i;
        }
        try {
            return new JavaConstructorImpl(PrivilegedAccessHelper.getDeclaredConstructorFor(this.jClass, params, true), this.javaModelImpl);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    @Override
    public Collection getConstructors() {
        Constructor<?>[] constructors = this.jClass.getConstructors();
        ArrayList<JavaConstructorImpl> constructorCollection = new ArrayList<JavaConstructorImpl>(constructors.length);
        Constructor<?>[] constructorArray = constructors;
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> next = constructorArray[n2];
            constructorCollection.add(new JavaConstructorImpl(next, this.javaModelImpl));
            ++n2;
        }
        return constructorCollection;
    }

    @Override
    public Collection getDeclaredConstructors() {
        Constructor<?>[] constructors = this.jClass.getDeclaredConstructors();
        ArrayList<JavaConstructorImpl> constructorCollection = new ArrayList<JavaConstructorImpl>(constructors.length);
        Constructor<?>[] constructorArray = constructors;
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> next = constructorArray[n2];
            constructorCollection.add(new JavaConstructorImpl(next, this.javaModelImpl));
            ++n2;
        }
        return constructorCollection;
    }

    public JavaField getField(String arg0) {
        try {
            Field field = PrivilegedAccessHelper.getField(this.jClass, arg0, true);
            return this.getJavaField(field);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public Collection getFields() {
        Field[] fields;
        ArrayList<JavaField> fieldCollection = new ArrayList<JavaField>();
        Field[] fieldArray = fields = PrivilegedAccessHelper.getFields(this.jClass);
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            fieldCollection.add(this.getJavaField(field));
            ++n2;
        }
        return fieldCollection;
    }

    public Class getJavaClass() {
        return this.jClass;
    }

    @Override
    public JavaMethod getMethod(String arg0, JavaClass[] arg1) {
        if (arg1 == null) {
            arg1 = new JavaClass[]{};
        }
        Class[] params = new Class[arg1.length];
        int i = 0;
        while (i < arg1.length) {
            JavaClass jType = arg1[i];
            if (jType != null) {
                params[i] = ((JavaClassImpl)jType).getJavaClass();
            }
            ++i;
        }
        try {
            Method method = PrivilegedAccessHelper.getMethod(this.jClass, arg0, params, true);
            return this.getJavaMethod(method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    @Override
    public Collection getMethods() {
        Method[] methods;
        ArrayList<JavaMethod> methodCollection = new ArrayList<JavaMethod>();
        Method[] methodArray = methods = PrivilegedAccessHelper.getMethods(this.jClass);
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            methodCollection.add(this.getJavaMethod(method));
            ++n2;
        }
        return methodCollection;
    }

    @Override
    public String getName() {
        return this.jClass.getName();
    }

    @Override
    public JavaPackage getPackage() {
        return new JavaPackageImpl(this.jClass.getPackage(), this.javaModelImpl, this.isMetadataComplete);
    }

    @Override
    public String getPackageName() {
        int index;
        if (this.jClass.getPackage() != null) {
            return this.jClass.getPackage().getName();
        }
        Class<?> nonInnerClass = this.jClass;
        Class<?> enclosingClass = this.jClass.getEnclosingClass();
        while (enclosingClass != null) {
            nonInnerClass = enclosingClass;
            enclosingClass = nonInnerClass.getEnclosingClass();
        }
        String className = nonInnerClass.getCanonicalName();
        if (className != null && (index = className.lastIndexOf(".")) > -1) {
            return className.substring(0, index);
        }
        return null;
    }

    @Override
    public String getQualifiedName() {
        return this.jClass.getName();
    }

    @Override
    public String getRawName() {
        return this.jClass.getCanonicalName();
    }

    @Override
    public JavaClass getSuperclass() {
        Class<?>[] superInterfaces;
        if (this.superClassOverride != null) {
            return this.superClassOverride;
        }
        if (this.jClass.isInterface() && (superInterfaces = this.jClass.getInterfaces()) != null) {
            if (superInterfaces.length == 1) {
                return this.javaModelImpl.getClass(superInterfaces[0]);
            }
            Class<?> parent = null;
            Class<?>[] classArray = superInterfaces;
            int n = superInterfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> next = classArray[n2];
                if (!next.getName().startsWith("java.") && !next.getName().startsWith("javax.")) {
                    if (parent == null) {
                        parent = next;
                    } else {
                        throw JAXBException.invalidInterface(this.jClass.getName());
                    }
                }
                ++n2;
            }
            return this.javaModelImpl.getClass(parent);
        }
        return this.javaModelImpl.getClass(this.jClass.getSuperclass());
    }

    @Override
    public Type getGenericSuperclass() {
        return this.jClass.getGenericSuperclass();
    }

    @Override
    public boolean hasActualTypeArguments() {
        return this.getActualTypeArguments().size() > 0;
    }

    public JavaField getJavaField(Field field) {
        return new JavaFieldImpl(field, this.javaModelImpl, this.isMetadataComplete);
    }

    public JavaMethod getJavaMethod(Method method) {
        return new JavaMethodImpl(method, this.javaModelImpl, this.isMetadataComplete);
    }

    public JavaClass getOwningClass() {
        return this.javaModelImpl.getClass(this.jClass.getEnclosingClass());
    }

    @Override
    public boolean isAnnotation() {
        return this.jClass.isAnnotation();
    }

    @Override
    public boolean isArray() {
        return this.jClass.isArray();
    }

    public AnnotatedElement getAnnotatedElement() {
        return this.jClass;
    }

    @Override
    public boolean isAssignableFrom(JavaClass arg0) {
        if (!(arg0 instanceof JavaClassImpl)) {
            return false;
        }
        if (this.hasCustomSuperClass(arg0)) {
            return this.customIsAssignableFrom(arg0);
        }
        return this.jClass.isAssignableFrom(((JavaClassImpl)arg0).getJavaClass());
    }

    private boolean customIsAssignableFrom(JavaClass arg0) {
        Class<?>[] interfaces;
        JavaClassImpl jClass = (JavaClassImpl)arg0;
        Class cls = jClass.getJavaClass();
        if (cls == this.jClass) {
            return true;
        }
        Class<?>[] classArray = interfaces = cls.getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> nextInterface = classArray[n2];
            if (nextInterface == this.jClass) {
                return true;
            }
            if (this.customIsAssignableFrom(this.javaModelImpl.getClass(nextInterface))) {
                return true;
            }
            ++n2;
        }
        if (!jClass.isInterface()) {
            JavaClassImpl superJavaClass = (JavaClassImpl)jClass.getSuperclass();
            if (superJavaClass.getName().equals("java.lang.Object")) {
                return this.jClass == superJavaClass.getJavaClass();
            }
            return this.customIsAssignableFrom(superJavaClass);
        }
        return false;
    }

    private boolean hasCustomSuperClass(JavaClass arg0) {
        if (arg0 == null) {
            return false;
        }
        if (!this.javaModelImpl.hasXmlBindings()) {
            return false;
        }
        if (arg0.getClass() != this.getClass()) {
            return false;
        }
        if (arg0.getName().equals("java.lang.Object")) {
            return false;
        }
        JavaClassImpl jClass = (JavaClassImpl)arg0;
        if (jClass.getSuperClassOverride() != null) {
            return true;
        }
        return this.hasCustomSuperClass(jClass.getSuperclass());
    }

    @Override
    public boolean isEnum() {
        return this.jClass.isEnum();
    }

    @Override
    public boolean isInterface() {
        return this.jClass.isInterface();
    }

    @Override
    public boolean isMemberClass() {
        return this.jClass.isMemberClass();
    }

    @Override
    public boolean isPrimitive() {
        return this.jClass.isPrimitive();
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    @Override
    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    @Override
    public int getModifiers() {
        return this.jClass.getModifiers();
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    @Override
    public boolean isSynthetic() {
        return this.jClass.isSynthetic();
    }

    @Override
    public JavaClass getComponentType() {
        if (!this.isArray()) {
            return null;
        }
        return this.javaModelImpl.getClass(this.jClass.getComponentType());
    }

    public JavaClass getSuperClassOverride() {
        return this.superClassOverride;
    }

    public void setSuperClassOverride(JavaClass superClassOverride) {
        this.superClassOverride = superClassOverride;
    }

    void setIsMetadataComplete(Boolean isMetadataComplete) {
        if (isMetadataComplete != null) {
            this.isMetadataComplete = isMetadataComplete;
        }
    }

    @Override
    public JavaAnnotation getDeclaredAnnotation(JavaClass arg0) {
        if (arg0 != null && (!this.isMetadataComplete || arg0.getQualifiedName().equals(XML_REGISTRY_CLASS_NAME))) {
            Annotation[] annotations;
            Class annotationClass = ((JavaClassImpl)arg0).getJavaClass();
            Annotation[] annotationArray = annotations = this.javaModelImpl.getAnnotationHelper().getDeclaredAnnotations(this.getAnnotatedElement());
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (annotation.annotationType().equals(annotationClass)) {
                    return new JavaAnnotationImpl(annotation);
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public Collection getDeclaredAnnotations() {
        ArrayList<JavaAnnotationImpl> annotationCollection = new ArrayList<JavaAnnotationImpl>();
        if (!this.isMetadataComplete) {
            Annotation[] annotations;
            Annotation[] annotationArray = annotations = this.javaModelImpl.getAnnotationHelper().getDeclaredAnnotations(this.getAnnotatedElement());
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                annotationCollection.add(new JavaAnnotationImpl(annotation));
                ++n2;
            }
        }
        return annotationCollection;
    }
}

