/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSingleEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.parser.DatabaseType;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionFactory;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CastExpression
extends AbstractSingleEncapsulatedExpression {
    private String asIdentifier;
    private AbstractExpression databaseType;
    private boolean hasSpaceAfterAs;
    private boolean hasSpaceAfterExpression;
    private boolean parsingDatabaseType;
    private boolean shouldParseWithFactoryFirst = true;

    public CastExpression(AbstractExpression parent) {
        super(parent, "CAST");
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        this.acceptUnknownVisitor(visitor);
    }

    @Override
    protected void addOrderedEncapsulatedExpressionTo(List<Expression> children) {
        super.addOrderedEncapsulatedExpressionTo(children);
        if (this.hasSpaceAfterExpression) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.asIdentifier != null) {
            children.add(this.buildStringExpression("AS"));
        }
        if (this.hasSpaceAfterAs) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasDatabaseType()) {
            children.add(this.databaseType);
        }
    }

    @Override
    public String getEncapsulatedExpressionQueryBNFId() {
        return "scalar_expression";
    }

    public Expression getDatabaseType() {
        return this.databaseType;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("cast_expression");
    }

    public boolean hasAs() {
        return this.asIdentifier != null;
    }

    public boolean hasDatabaseType() {
        return this.databaseType != null && !this.databaseType.isNull();
    }

    @Override
    public boolean hasEncapsulatedExpression() {
        return super.hasEncapsulatedExpression() || this.asIdentifier != null || this.hasDatabaseType();
    }

    public boolean hasScalarExpression() {
        return super.hasEncapsulatedExpression();
    }

    public boolean hasSpaceAfterAs() {
        return this.hasSpaceAfterAs;
    }

    public boolean hasSpaceAfterExpression() {
        return this.hasSpaceAfterExpression;
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        if (this.parsingDatabaseType) {
            return super.isParsingComplete(wordParser, word, expression);
        }
        ExpressionFactory factory = this.getQueryBNF(this.getEncapsulatedExpressionQueryBNFId()).getExpressionFactory(word);
        return factory == null && expression != null || word.equalsIgnoreCase("AS") || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    protected void parseEncapsulatedExpression(WordParser wordParser, int whitespaceCount, boolean tolerant) {
        super.parseEncapsulatedExpression(wordParser, whitespaceCount, tolerant);
        boolean bl = this.hasSpaceAfterExpression = wordParser.skipLeadingWhitespace() > 0;
        if (wordParser.startsWithIdentifier("AS")) {
            this.asIdentifier = wordParser.moveForward("AS");
            boolean bl2 = this.hasSpaceAfterAs = wordParser.skipLeadingWhitespace() > 0;
        }
        if (!wordParser.isTail()) {
            this.parsingDatabaseType = true;
            if (tolerant) {
                this.databaseType = this.parse(wordParser, "database_type", tolerant);
            } else {
                this.databaseType = new DatabaseType(this, wordParser.word());
                this.databaseType.parse(wordParser, tolerant);
            }
        }
    }

    @Override
    protected void removeEncapsulatedExpression() {
        super.removeEncapsulatedExpression();
        this.asIdentifier = null;
        this.databaseType = null;
        this.hasSpaceAfterAs = false;
        this.hasSpaceAfterExpression = false;
    }

    @Override
    protected boolean shouldParseWithFactoryFirst() {
        return this.shouldParseWithFactoryFirst;
    }

    @Override
    protected void toParsedTextEncapsulatedExpression(StringBuilder writer, boolean actual) {
        super.toParsedTextEncapsulatedExpression(writer, actual);
        if (this.hasSpaceAfterExpression) {
            writer.append(' ');
        }
        if (this.asIdentifier != null) {
            writer.append(actual ? this.asIdentifier : "AS");
        }
        if (this.hasSpaceAfterAs) {
            writer.append(' ');
        }
        if (this.databaseType != null) {
            this.databaseType.toParsedText(writer, actual);
        }
    }
}

