/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.resources.common;

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSException;
import org.eclipse.persistence.jpa.rs.features.FeatureResponseBuilder;
import org.eclipse.persistence.jpa.rs.features.FeatureSet;
import org.eclipse.persistence.jpa.rs.features.fieldsfiltering.FieldsFilteringValidator;
import org.eclipse.persistence.jpa.rs.features.paging.PageableFieldValidator;
import org.eclipse.persistence.jpa.rs.resources.common.AbstractResource;
import org.eclipse.persistence.jpa.rs.util.IdHelper;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;
import org.eclipse.persistence.jpa.rs.util.StreamingOutputMarshaller;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseSession;

public abstract class AbstractEntityResource
extends AbstractResource {
    private static final String CLASS_NAME = AbstractEntityResource.class.getName();

    protected Response findAttributeInternal(String version, String persistenceUnit, String type, String id, String attribute, HttpHeaders headers, UriInfo uriInfo) {
        JPARSLogger.entering(CLASS_NAME, "findAttributeInternal", new Object[]{"GET", version, persistenceUnit, type, id, attribute, uriInfo.getRequestUri().toASCIIString()});
        EntityManager em = null;
        try {
            PageableFieldValidator validator;
            PersistenceContext context = this.getPersistenceContext(persistenceUnit, type, uriInfo.getBaseUri(), version, null);
            Object entityId = IdHelper.buildId(context, type, id);
            em = context.getEmf().createEntityManager(AbstractEntityResource.getMatrixParameters(uriInfo, persistenceUnit));
            Object entity = em.find(context.getClass(type), entityId, AbstractEntityResource.getQueryParameters(uriInfo));
            DatabaseSession serverSession = context.getServerSession();
            ClassDescriptor descriptor = serverSession.getClassDescriptor(context.getClass(type));
            if (descriptor == null) {
                throw JPARSException.classOrClassDescriptorCouldNotBeFoundForEntity(type, persistenceUnit);
            }
            DatabaseMapping attributeMapping = descriptor.getMappingForAttributeName(attribute);
            if (attributeMapping == null || entity == null) {
                throw JPARSException.databaseMappingCouldNotBeFoundForEntityAttribute(attribute, type, id, persistenceUnit);
            }
            if (!attributeMapping.isCollectionMapping()) {
                Object result = attributeMapping.getRealAttributeValueFromAttribute(attributeMapping.getAttributeValueFromObject(entity), entity, (AbstractSession)((Object)serverSession));
                if (result == null) {
                    JPARSLogger.error("jpars_could_not_find_entity_for_attribute", new Object[]{attribute, type, id, persistenceUnit});
                    throw JPARSException.attributeCouldNotBeFoundForEntity(attribute, type, id, persistenceUnit);
                }
                Response response = this.findAttributeResponse(context, attribute, type, id, persistenceUnit, result, AbstractEntityResource.getQueryParameters(uriInfo), headers, uriInfo, context.getSupportedFeatureSet().getResponseBuilder(FeatureSet.Feature.NO_PAGING));
                return response;
            }
            ReadQuery query = (ReadQuery)((ForeignReferenceMapping)attributeMapping).getSelectionQuery().clone();
            if (query == null) {
                throw JPARSException.selectionQueryForAttributeCouldNotBeFoundForEntity(attribute, type, id, persistenceUnit);
            }
            FeatureSet featureSet = context.getSupportedFeatureSet();
            AbstractSession clientSession = context.getClientSession(em);
            if (featureSet.isSupported(FeatureSet.Feature.PAGING) && (validator = new PageableFieldValidator(entity.getClass(), attribute, uriInfo)).isFeatureApplicable()) {
                query.setMaxRows(validator.getLimit());
                query.setFirstResult(validator.getOffset());
                Map<String, Object> queryParams = AbstractEntityResource.getQueryParameters(uriInfo);
                queryParams.put("limit", String.valueOf(validator.getLimit()));
                queryParams.put("offset", String.valueOf(validator.getOffset()));
                this.checkOrderBy(query);
                Object result = clientSession.executeQuery((DatabaseQuery)query, descriptor.getObjectBuilder().buildRow(entity, clientSession, DatabaseMapping.WriteType.INSERT));
                Response response = this.findAttributeResponse(context, attribute, type, id, persistenceUnit, result, queryParams, headers, uriInfo, context.getSupportedFeatureSet().getResponseBuilder(FeatureSet.Feature.PAGING));
                return response;
            }
            Object result = clientSession.executeQuery((DatabaseQuery)query, descriptor.getObjectBuilder().buildRow(entity, clientSession, DatabaseMapping.WriteType.INSERT));
            Response response = this.findAttributeResponse(context, attribute, type, id, persistenceUnit, result, AbstractEntityResource.getQueryParameters(uriInfo), headers, uriInfo, context.getSupportedFeatureSet().getResponseBuilder(FeatureSet.Feature.NO_PAGING));
            return response;
        }
        catch (Exception ex) {
            throw JPARSException.exceptionOccurred(ex);
        }
        finally {
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
    }

    protected Response findInternal(String version, String persistenceUnit, String type, String id, HttpHeaders headers, UriInfo uriInfo) {
        JPARSLogger.entering(CLASS_NAME, "findInternal", new Object[]{"GET", version, persistenceUnit, type, id, uriInfo.getRequestUri().toASCIIString()});
        try {
            FieldsFilteringValidator fieldsFilteringValidator;
            PersistenceContext context = this.getPersistenceContext(persistenceUnit, type, uriInfo.getBaseUri(), version, null);
            Map<String, String> discriminators = AbstractEntityResource.getMatrixParameters(uriInfo, persistenceUnit);
            Object entityId = IdHelper.buildId(context, type, id);
            Object entity = context.find(discriminators, type, entityId, AbstractEntityResource.getQueryParameters(uriInfo));
            if (entity == null) {
                JPARSLogger.error("jpars_could_not_find_entity_for_key", new Object[]{type, id, persistenceUnit});
                throw JPARSException.entityNotFound(type, id, persistenceUnit);
            }
            if (context.getSupportedFeatureSet().isSupported(FeatureSet.Feature.FIELDS_FILTERING) && (fieldsFilteringValidator = new FieldsFilteringValidator(context, uriInfo, entity)).isFeatureApplicable()) {
                StreamingOutputMarshaller marshaller = new StreamingOutputMarshaller(context, this.singleEntityResponse(context, entity, uriInfo), headers.getAcceptableMediaTypes(), fieldsFilteringValidator.getFields());
                return Response.ok((Object)marshaller).build();
            }
            return Response.ok((Object)new StreamingOutputMarshaller(context, this.singleEntityResponse(context, entity, uriInfo), headers.getAcceptableMediaTypes())).build();
        }
        catch (Exception ex) {
            throw JPARSException.exceptionOccurred(ex);
        }
    }

    protected Response createInternal(String version, String persistenceUnit, String type, HttpHeaders headers, UriInfo uriInfo, InputStream in) {
        JPARSLogger.entering(CLASS_NAME, "createInternal", new Object[]{"PUT", headers.getMediaType(), version, persistenceUnit, type, uriInfo.getRequestUri().toASCIIString()});
        try {
            Vector<DatabaseMapping> mappings;
            PersistenceContext context = this.getPersistenceContext(persistenceUnit, type, uriInfo.getBaseUri(), version, null);
            ClassDescriptor descriptor = context.getDescriptor(type);
            if (descriptor == null) {
                JPARSLogger.error("jpars_could_not_find_class_in_persistence_unit", new Object[]{type, persistenceUnit});
                throw JPARSException.classOrClassDescriptorCouldNotBeFoundForEntity(type, persistenceUnit);
            }
            Object entity = context.unmarshalEntity(type, StreamingOutputMarshaller.mediaType(headers.getAcceptableMediaTypes()), in);
            AbstractDirectMapping sequenceMapping = descriptor.getObjectBuilder().getSequenceMapping();
            if (sequenceMapping != null) {
                Object value = sequenceMapping.getAttributeAccessor().getAttributeValueFromObject(entity);
                if (descriptor.getObjectBuilder().isPrimaryKeyComponentInvalid(value, descriptor.getPrimaryKeyFields().indexOf(descriptor.getSequenceNumberField())) || descriptor.getSequence().shouldAlwaysOverrideExistingValue()) {
                    JPARSLogger.error("jpars_put_not_idempotent", new Object[]{type, persistenceUnit});
                    throw JPARSException.entityIsNotIdempotent(type, persistenceUnit);
                }
            }
            if ((mappings = descriptor.getMappings()) != null && !mappings.isEmpty()) {
                for (DatabaseMapping mapping : mappings) {
                    Object value;
                    RelationalDescriptor relDesc;
                    AbstractDirectMapping relSequenceMapping;
                    ClassDescriptor referenceDescriptor;
                    ForeignReferenceMapping fkMapping;
                    if (!(mapping instanceof ForeignReferenceMapping) || !(fkMapping = (ForeignReferenceMapping)mapping).isCascadePersist() && !fkMapping.isCascadeMerge() || (referenceDescriptor = fkMapping.getReferenceDescriptor()) == null || !(referenceDescriptor instanceof RelationalDescriptor) || (relSequenceMapping = (relDesc = (RelationalDescriptor)referenceDescriptor).getObjectBuilder().getSequenceMapping()) == null || (value = mapping.getAttributeAccessor().getAttributeValueFromObject(entity)) == null) continue;
                    if (value instanceof ValueHolder) {
                        ValueHolder holder = (ValueHolder)value;
                        Object obj = holder.getValue();
                        if (obj == null) continue;
                        JPARSLogger.error("jpars_put_not_idempotent", new Object[]{type, persistenceUnit});
                        throw JPARSException.entityIsNotIdempotent(type, persistenceUnit);
                    }
                    if (!(value instanceof Collection) || ((Collection)value).isEmpty()) continue;
                    JPARSLogger.error("jpars_put_not_idempotent", new Object[]{type, persistenceUnit});
                    throw JPARSException.entityIsNotIdempotent(type, persistenceUnit);
                }
            }
            context.create(AbstractEntityResource.getMatrixParameters(uriInfo, persistenceUnit), entity);
            Response.ResponseBuilder rb = Response.status((Response.Status)Response.Status.CREATED);
            return rb.entity((Object)new StreamingOutputMarshaller(context, this.singleEntityResponse(context, entity, uriInfo), headers.getAcceptableMediaTypes())).build();
        }
        catch (Exception ex) {
            throw JPARSException.exceptionOccurred(ex);
        }
    }

    protected Response updateInternal(String version, String persistenceUnit, String type, HttpHeaders headers, UriInfo uriInfo, InputStream in) {
        JPARSLogger.entering(CLASS_NAME, "updateInternal", new Object[]{"POST", headers.getMediaType(), version, persistenceUnit, type, uriInfo.getRequestUri().toASCIIString()});
        try {
            PersistenceContext context = this.getPersistenceContext(persistenceUnit, type, uriInfo.getBaseUri(), version, null);
            Object entity = context.unmarshalEntity(type, StreamingOutputMarshaller.mediaType(headers.getAcceptableMediaTypes()), in);
            entity = context.merge(AbstractEntityResource.getMatrixParameters(uriInfo, persistenceUnit), entity);
            return Response.ok((Object)new StreamingOutputMarshaller(context, this.singleEntityResponse(context, entity, uriInfo), headers.getAcceptableMediaTypes())).build();
        }
        catch (Exception ex) {
            throw JPARSException.exceptionOccurred(ex);
        }
    }

    protected Response setOrAddAttributeInternal(String version, String persistenceUnit, String type, String id, String attribute, HttpHeaders headers, UriInfo uriInfo, InputStream in) {
        JPARSLogger.entering(CLASS_NAME, "setOrAddAttributeInternal", new Object[]{"POST", headers.getMediaType(), version, persistenceUnit, type, id, attribute, uriInfo.getRequestUri().toASCIIString()});
        try {
            PersistenceContext context = this.getPersistenceContext(persistenceUnit, type, uriInfo.getBaseUri(), version, null);
            Object entityId = IdHelper.buildId(context, type, id);
            String partner = this.getRelationshipPartner(AbstractEntityResource.getMatrixParameters(uriInfo, attribute), AbstractEntityResource.getQueryParameters(uriInfo));
            ClassDescriptor descriptor = context.getDescriptor(type);
            DatabaseMapping mapping = descriptor.getMappingForAttributeName(attribute);
            if (!mapping.isForeignReferenceMapping()) {
                JPARSLogger.error("jpars_could_not_find_appropriate_mapping_for_update", new Object[]{attribute, type, id, persistenceUnit});
                throw JPARSException.databaseMappingCouldNotBeFoundForEntityAttribute(attribute, type, id, persistenceUnit);
            }
            Object entity = context.unmarshalEntity(mapping.getReferenceDescriptor().getAlias(), StreamingOutputMarshaller.mediaType(headers.getAcceptableMediaTypes()), in);
            Object result = context.updateOrAddAttribute(AbstractEntityResource.getMatrixParameters(uriInfo, persistenceUnit), type, entityId, AbstractEntityResource.getQueryParameters(uriInfo), attribute, entity, partner);
            if (result == null) {
                JPARSLogger.error("jpars_could_not_update_attribute", new Object[]{attribute, type, id, persistenceUnit});
                JPARSException.attributeCouldNotBeUpdated(attribute, type, id, persistenceUnit);
            }
            return Response.ok((Object)new StreamingOutputMarshaller(context, this.singleEntityResponse(context, result, uriInfo), headers.getAcceptableMediaTypes())).build();
        }
        catch (Exception ex) {
            throw JPARSException.exceptionOccurred(ex);
        }
    }

    protected Response removeAttributeInternal(String version, String persistenceUnit, String type, String id, String attribute, HttpHeaders headers, UriInfo uriInfo) {
        JPARSLogger.entering(CLASS_NAME, "removeAttributeInternal", new Object[]{"DELETE", headers.getMediaType(), version, persistenceUnit, type, id, attribute, uriInfo.getRequestUri().toASCIIString()});
        try {
            String listItemId = null;
            Map<String, String> matrixParams = AbstractEntityResource.getMatrixParameters(uriInfo, attribute);
            Map<String, Object> queryParams = AbstractEntityResource.getQueryParameters(uriInfo);
            if (queryParams != null && !queryParams.isEmpty()) {
                listItemId = (String)queryParams.get("eclipselink.jpars.list.item-id");
            }
            if (attribute == null && listItemId == null) {
                JPARSException.invalidRemoveAttributeRequest(null, type, id, persistenceUnit);
            }
            String partner = this.getRelationshipPartner(matrixParams, queryParams);
            PersistenceContext context = this.getPersistenceContext(persistenceUnit, type, uriInfo.getBaseUri(), version, null);
            Object entityId = IdHelper.buildId(context, type, id);
            ClassDescriptor descriptor = context.getDescriptor(type);
            DatabaseMapping mapping = descriptor.getMappingForAttributeName(attribute);
            if (!mapping.isForeignReferenceMapping()) {
                JPARSLogger.error("jpars_could_not_find_appropriate_mapping_for_update", new Object[]{attribute, type, id, persistenceUnit});
                throw JPARSException.databaseMappingCouldNotBeFoundForEntityAttribute(attribute, type, id, persistenceUnit);
            }
            Map<String, String> discriminators = AbstractEntityResource.getMatrixParameters(uriInfo, persistenceUnit);
            Object entity = context.find(discriminators, type, entityId, AbstractEntityResource.getQueryParameters(uriInfo));
            Object result = context.removeAttribute(AbstractEntityResource.getMatrixParameters(uriInfo, persistenceUnit), type, entityId, attribute, listItemId, entity, partner);
            if (result == null) {
                JPARSLogger.error("jpars_could_not_update_attribute", new Object[]{attribute, type, id, persistenceUnit});
                throw JPARSException.attributeCouldNotBeUpdated(attribute, type, id, persistenceUnit);
            }
            return Response.ok((Object)new StreamingOutputMarshaller(context, this.singleEntityResponse(context, result, uriInfo), headers.getAcceptableMediaTypes())).build();
        }
        catch (Exception ex) {
            throw JPARSException.exceptionOccurred(ex);
        }
    }

    protected Response deleteInternal(String version, String persistenceUnit, String type, String id, HttpHeaders headers, UriInfo uriInfo) {
        JPARSLogger.entering(CLASS_NAME, "deleteInternal", new Object[]{"DELETE", headers.getMediaType(), version, persistenceUnit, type, id, uriInfo.getRequestUri().toASCIIString()});
        try {
            PersistenceContext context = this.getPersistenceContext(persistenceUnit, type, uriInfo.getBaseUri(), version, null);
            Map<String, String> discriminators = AbstractEntityResource.getMatrixParameters(uriInfo, persistenceUnit);
            Object entityId = IdHelper.buildId(context, type, id);
            context.delete(discriminators, type, entityId);
            return Response.ok().build();
        }
        catch (Exception ex) {
            throw JPARSException.exceptionOccurred(ex);
        }
    }

    private Response findAttributeResponse(PersistenceContext context, String attribute, String entityType, String id, String persistenceUnit, Object queryResults, Map<String, Object> queryParams, HttpHeaders headers, UriInfo uriInfo, FeatureResponseBuilder responseBuilder) {
        if (queryResults != null) {
            Object results = responseBuilder.buildAttributeResponse(context, queryParams, attribute, queryResults, uriInfo);
            if (results != null) {
                return Response.ok((Object)new StreamingOutputMarshaller(context, results, headers.getAcceptableMediaTypes())).build();
            }
            throw JPARSException.responseCouldNotBeBuiltForFindAttributeRequest(attribute, entityType, id, persistenceUnit);
        }
        return Response.ok((Object)new StreamingOutputMarshaller(context, null, headers.getAcceptableMediaTypes())).build();
    }

    private void checkOrderBy(ReadQuery query) {
        ReadAllQuery readAllQuery;
        List<Expression> orderBy;
        if (query.isReadAllQuery() && ((orderBy = (readAllQuery = (ReadAllQuery)query).getOrderByExpressions()) == null || orderBy.isEmpty())) {
            JPARSLogger.warning("no_orderby_clause_for_paging", new Object[]{query.toString()});
        }
    }

    private Object singleEntityResponse(PersistenceContext context, Object entity, UriInfo uriInfo) {
        FeatureSet featureSet = context.getSupportedFeatureSet();
        FeatureResponseBuilder responseBuilder = featureSet.getResponseBuilder(FeatureSet.Feature.NO_PAGING);
        return responseBuilder.buildSingleEntityResponse(context, AbstractEntityResource.getQueryParameters(uriInfo), entity, uriInfo);
    }
}

