/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.jaxb.ObjectGraph;
import org.eclipse.persistence.jaxb.Subgraph;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.features.fieldsfiltering.FieldsFilter;
import org.eclipse.persistence.jpa.rs.features.fieldsfiltering.FieldsFilterType;
import org.eclipse.persistence.jpa.rs.util.list.PageableCollection;
import org.eclipse.persistence.jpa.rs.util.list.ReadAllQueryResultCollection;
import org.eclipse.persistence.jpa.rs.util.list.ReportQueryResultCollection;
import org.eclipse.persistence.jpa.rs.util.list.SingleResultQueryResult;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;

public class ObjectGraphBuilder {
    private final PersistenceContext context;

    public ObjectGraphBuilder(PersistenceContext context) {
        this.context = context;
    }

    public ObjectGraph createObjectGraph(Object object, FieldsFilter filter) {
        Node root = new Node();
        if (PersistenceWeavedRest.class.isAssignableFrom(object.getClass())) {
            this.createNodeForEntity(object, root);
        } else if (object instanceof SingleResultQueryResult) {
            root.addAttributeNode("links");
            SingleResultQueryResult singleResultQueryResult = (SingleResultQueryResult)object;
            this.processFieldsList(root.addSubNode("fields"), singleResultQueryResult.getFields());
        } else if (object instanceof ReadAllQueryResultCollection) {
            this.createNodeForPageableCollection((PageableCollection)object, root);
        } else {
            return null;
        }
        ObjectGraph objectGraph = this.context.getJAXBContext().createObjectGraph(object.getClass());
        this.fillObjectGraphFromNode(objectGraph, root, filter);
        return objectGraph;
    }

    private void createNodeForPageableCollection(PageableCollection collection, Node node) {
        node.addAttributeNode("hasMore");
        node.addAttributeNode("count");
        node.addAttributeNode("offset");
        node.addAttributeNode("limit");
        node.addAttributeNode("links");
        if (collection.getItems() != null && !collection.getItems().isEmpty()) {
            Node subNode = node.addSubNode("items");
            if (collection instanceof ReportQueryResultCollection) {
                ReportQueryResultCollection reportQueryResultCollection = (ReportQueryResultCollection)collection;
                this.processFieldsList(subNode.addSubNode("fields"), reportQueryResultCollection.getItems().get(0).getFields());
            } else {
                this.createNodeForEntity(collection.getItems().get(0), subNode);
            }
        }
    }

    private void processFieldsList(Node fieldsNode, List<JAXBElement> elements) {
        for (JAXBElement field : elements) {
            if (field.getValue() instanceof PersistenceWeavedRest) {
                Node subNode = fieldsNode.addSubNode(field.getName().toString());
                subNode.addAttributeNode("_persistence_links");
                continue;
            }
            fieldsNode.addAttributeNode(field.getName().toString());
        }
    }

    private void createNodeForEntity(Object object, Node node) {
        ClassDescriptor classDescriptor = this.context.getServerSession().getProject().getDescriptors().get(object.getClass());
        if (classDescriptor == null) {
            return;
        }
        node.addAttributeNode("_persistence_links");
        for (DatabaseMapping mapping : classDescriptor.getMappings()) {
            if (ForeignReferenceMapping.class.isAssignableFrom(mapping.getClass())) {
                Node subNode = node.addSubNode(mapping.getAttributeName());
                if (mapping.isCollectionMapping()) {
                    subNode.addAttributeNode("links");
                    Node itemsSubNode = subNode.addSubNode("items");
                    itemsSubNode.addAttributeNode("_persistence_links");
                    continue;
                }
                subNode.addAttributeNode("_persistence_links");
                continue;
            }
            node.addAttributeNode(mapping.getAttributeName());
        }
    }

    private void fillObjectGraphFromNode(ObjectGraph objectGraph, Node node, FieldsFilter filter) {
        for (String attribute : node.getNodesMap().keySet()) {
            if (filter != null && (filter.getType() != FieldsFilterType.INCLUDE ? filter.getFields().contains(attribute) : !attribute.equals("_persistence_links") && !filter.getFields().contains(attribute))) continue;
            Node value = node.get(attribute);
            if (value != null) {
                Subgraph subgraph = objectGraph.addSubgraph(attribute);
                this.fillSubgraphFromNode(subgraph, value);
                continue;
            }
            objectGraph.addAttributeNodes(attribute);
        }
    }

    private void fillSubgraphFromNode(Subgraph subgraph, Node node) {
        for (String attribute : node.getNodesMap().keySet()) {
            Node value = node.get(attribute);
            if (value != null) {
                Subgraph childSubgraph = subgraph.addSubgraph(attribute);
                this.fillSubgraphFromNode(childSubgraph, value);
                continue;
            }
            subgraph.addAttributeNodes(attribute);
        }
    }

    private static class Node {
        private final Map<String, Node> nodesMap = new HashMap<String, Node>();

        private Node() {
        }

        public void addAttributeNode(String attribute) {
            this.nodesMap.put(attribute, null);
        }

        public Node addSubNode(String attribute) {
            Node subNode = new Node();
            this.nodesMap.put(attribute, subNode);
            return subNode;
        }

        public Map<String, Node> getNodesMap() {
            return this.nodesMap;
        }

        public Node get(String key) {
            return this.nodesMap.get(key);
        }

        public String toString() {
            return "Node{nodesMap=" + this.nodesMap + '}';
        }
    }
}

