/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;

public class ApplicationAccessWLS {
    private static final Logger LOGGER = Logger.getLogger(ApplicationAccessWLS.class.getName());
    private final Map<ClassLoader, String> appNames = Collections.synchronizedMap(new WeakHashMap());
    private Object applicationAccessInstance;
    private Method getApplicationNameMethod;
    private Method getApplicationVersionMethod;
    private Object cicManagerInstance;
    private Method getCurrentCicMethod;
    private Method getApplicationIdMethod;

    public ApplicationAccessWLS() {
        try {
            this.initUsingCic();
            LOGGER.fine("ApplicationAccessWLS initialized using ComponentInvocationContext.");
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Error initializing ApplicationAccessWLS using ComponentInvocationContext. Trying to initialize it using ApplicationAccess.", e);
            this.cicManagerInstance = null;
            try {
                this.initUsingApplicationAccess();
                LOGGER.fine("ApplicationAccessWLS initialized using ApplicationAccess.");
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Error initializing ApplicationAccessWLS using ApplicationAccess.", ex);
                this.applicationAccessInstance = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getApplicationName(ClassLoader classLoader) {
        if (this.appNames.containsKey(classLoader)) {
            return this.appNames.get(classLoader);
        }
        Map<ClassLoader, String> map = this.appNames;
        synchronized (map) {
            if (this.appNames.containsKey(classLoader)) {
                return this.appNames.get(classLoader);
            }
            String appName = this.getApplicationNameInternal(classLoader);
            this.appNames.put(classLoader, appName);
            return appName;
        }
    }

    private String getApplicationNameInternal(ClassLoader classLoader) {
        if (this.cicManagerInstance != null) {
            try {
                return this.getAppNameUsingCic();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "ApplicationAccessWLS.getApplicationName error in getAppNameUsingCic.", e);
                return null;
            }
        }
        if (this.applicationAccessInstance != null) {
            try {
                return this.getAppNameUsingApplicationAccess(classLoader);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "ApplicationAccessWLS.getApplicationName error in getAppNameUsingApplicationAccess.", e);
                return null;
            }
        }
        LOGGER.fine("ApplicationAccessWLS: null applicationName returned.");
        return null;
    }

    protected void initUsingCic() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class cicManagerClass = PrivilegedAccessHelper.getClassForName("weblogic.invocation.ComponentInvocationContextManager");
        Method getInstance = PrivilegedAccessHelper.getDeclaredMethod(cicManagerClass, "getInstance", new Class[0]);
        this.cicManagerInstance = PrivilegedAccessHelper.invokeMethod(getInstance, cicManagerClass);
        this.getCurrentCicMethod = PrivilegedAccessHelper.getMethod(cicManagerClass, "getCurrentComponentInvocationContext", new Class[0], true);
        Class cicClass = PrivilegedAccessHelper.getClassForName("weblogic.invocation.ComponentInvocationContext");
        this.getApplicationIdMethod = PrivilegedAccessHelper.getDeclaredMethod(cicClass, "getApplicationId", new Class[0]);
    }

    protected void initUsingApplicationAccess() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class applicationAccessClass = PrivilegedAccessHelper.getClassForName("weblogic.application.ApplicationAccess");
        Method getApplicationAccessMethod = PrivilegedAccessHelper.getDeclaredMethod(applicationAccessClass, "getApplicationAccess", new Class[0]);
        this.applicationAccessInstance = PrivilegedAccessHelper.invokeMethod(getApplicationAccessMethod, applicationAccessClass);
        Class[] methodParameterTypes = new Class[]{ClassLoader.class};
        this.getApplicationNameMethod = PrivilegedAccessHelper.getMethod(applicationAccessClass, "getApplicationName", methodParameterTypes, true);
        this.getApplicationVersionMethod = PrivilegedAccessHelper.getMethod(applicationAccessClass, "getApplicationVersion", methodParameterTypes, true);
    }

    private String getAppNameUsingCic() throws InvocationTargetException, IllegalAccessException {
        Object cicInstance = PrivilegedAccessHelper.invokeMethod(this.getCurrentCicMethod, this.cicManagerInstance);
        return (String)PrivilegedAccessHelper.invokeMethod(this.getApplicationIdMethod, cicInstance);
    }

    private String getAppNameUsingApplicationAccess(ClassLoader classLoader) throws InvocationTargetException, IllegalAccessException {
        String appVersion;
        Object[] parameters = new Object[]{classLoader};
        String appName = (String)PrivilegedAccessHelper.invokeMethod(this.getApplicationNameMethod, this.applicationAccessInstance, parameters);
        if (appName != null && (appVersion = (String)PrivilegedAccessHelper.invokeMethod(this.getApplicationVersionMethod, this.applicationAccessInstance, parameters)) != null) {
            return String.valueOf(appName) + "#" + appVersion;
        }
        return appName;
    }
}

