/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.foundation;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.MappedKeyMapContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.DirectToFieldChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractColumnMapping;
import org.eclipse.persistence.mappings.foundation.MapKeyMapping;
import org.eclipse.persistence.mappings.querykeys.DirectQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryByExamplePolicy;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.CopyGroup;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.remote.DistributedSession;

public abstract class AbstractDirectMapping
extends AbstractColumnMapping
implements MapKeyMapping {
    protected transient Class attributeClassification;
    protected String attributeClassificationName;
    protected transient Class attributeObjectClassification;
    protected transient Object nullValue;
    protected DatabaseTable keyTableForMapKey = null;
    protected String fieldClassificationClassName = null;
    protected boolean bypassDefaultNullValueCheck;
    protected Boolean isMutable;

    @Override
    public void addAdditionalFieldsToQuery(ReadQuery selectionQuery, Expression baseExpression) {
        if (selectionQuery.isObjectLevelReadQuery()) {
            ((ObjectLevelReadQuery)selectionQuery).addAdditionalField(baseExpression.getField(this.getField()));
        } else if (selectionQuery.isDataReadQuery()) {
            ((SQLSelectStatement)((DataReadQuery)selectionQuery).getSQLStatement()).addField(baseExpression.getField(this.getField()));
        }
    }

    @Override
    public void addFieldsForMapKey(AbstractRecord joinRow) {
        if (!this.isReadOnly() && this.isUpdatable()) {
            joinRow.put(this.getField(), (Object)null);
        }
    }

    @Override
    public void addKeyToDeletedObjectsList(Object object, Map deletedObjects) {
    }

    public boolean isMutable() {
        if (this.isMutable == null) {
            return false;
        }
        return this.isMutable;
    }

    public void setIsMutable(boolean isMutable) {
        this.isMutable = isMutable ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public void buildBackupClone(Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        this.buildClone(clone, null, backup, null, unitOfWork);
    }

    @Override
    public ChangeRecord buildChangeRecord(Object clone, ObjectChangeSet owner, AbstractSession session) {
        return this.internalBuildChangeRecord(this.getAttributeValueFromObject(clone), null, owner);
    }

    @Override
    public void buildClone(Object original, CacheKey cacheKey, Object clone, Integer refreshCascade, AbstractSession cloningSession) {
        this.buildCloneValue(original, clone, cloningSession);
    }

    @Override
    public void buildCloneFromRow(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object clone, CacheKey sharedCacheKey, ObjectBuildingQuery sourceQuery, UnitOfWorkImpl unitOfWork, AbstractSession executionSession) {
        Object attributeValue = this.valueFromRow(databaseRow, joinManager, sourceQuery, sharedCacheKey, executionSession, true, null);
        this.setAttributeValueInObject(clone, attributeValue);
    }

    public void buildCloneValue(Object original, Object clone, AbstractSession session) {
        Object attributeValue = this.getAttributeValueFromObject(original);
        attributeValue = this.buildCloneValue(attributeValue, session);
        this.setAttributeValueInObject(clone, attributeValue);
    }

    protected Object buildCloneValue(Object attributeValue, AbstractSession session) {
        Object newAttributeValue = attributeValue;
        if (this.isMutable() && attributeValue != null) {
            if (attributeValue instanceof byte[]) {
                int length = ((byte[])attributeValue).length;
                byte[] arrayCopy = new byte[length];
                System.arraycopy(attributeValue, 0, arrayCopy, 0, length);
                newAttributeValue = arrayCopy;
            } else if (attributeValue instanceof Byte[]) {
                int length = ((Byte[])attributeValue).length;
                Byte[] arrayCopy = new Byte[length];
                System.arraycopy(attributeValue, 0, arrayCopy, 0, length);
                newAttributeValue = arrayCopy;
            } else if (attributeValue instanceof char[]) {
                int length = ((char[])attributeValue).length;
                char[] arrayCopy = new char[length];
                System.arraycopy(attributeValue, 0, arrayCopy, 0, length);
                newAttributeValue = arrayCopy;
            } else if (attributeValue instanceof Character[]) {
                int length = ((Character[])attributeValue).length;
                Character[] arrayCopy = new Character[length];
                System.arraycopy(attributeValue, 0, arrayCopy, 0, length);
                newAttributeValue = arrayCopy;
            } else {
                newAttributeValue = attributeValue instanceof Date ? ((Date)attributeValue).clone() : (attributeValue instanceof Calendar ? ((Calendar)attributeValue).clone() : this.getObjectValue(this.getFieldValue(attributeValue, session), session));
            }
        }
        return newAttributeValue;
    }

    @Override
    public void buildCopy(Object copy, Object original, CopyGroup group) {
        this.buildCloneValue(original, copy, group.getSession());
    }

    @Override
    public Object buildElementClone(Object attributeValue, Object parent, CacheKey cacheKey, Integer refreshCascade, AbstractSession cloningSession, boolean isExisting, boolean isFromSharedCache) {
        return this.buildCloneValue(attributeValue, cloningSession);
    }

    @Override
    public Expression buildExpression(Object queryObject, QueryByExamplePolicy policy, Expression expressionBuilder, Map processedObjects, AbstractSession session) {
        String attributeName = this.getAttributeName();
        Object attributeValue = this.getAttributeValueFromObject(queryObject);
        if (!policy.shouldIncludeInQuery(queryObject.getClass(), attributeName, attributeValue)) {
            return null;
        }
        Expression expression = expressionBuilder.get(attributeName);
        expression = attributeValue == null ? policy.completeExpressionForNull(expression) : policy.completeExpression(expression, attributeValue, attributeValue.getClass());
        return expression;
    }

    @Override
    public ReadQuery buildSelectionQueryForDirectCollectionKeyMapping(ContainerPolicy containerPolicy) {
        DataReadQuery query = new DataReadQuery();
        query.setSQLStatement(new SQLSelectStatement());
        query.setContainerPolicy(containerPolicy);
        return query;
    }

    @Override
    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map newObjects, Map unregisteredExistingObjects, Map visitedObjects, UnitOfWorkImpl uow, boolean getAttributeValueFromObject, Set cascadeErrors) {
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects, boolean getAttributeValueFromObject) {
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects, boolean getAttributeValueFromObject) {
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    @Override
    public Object clone() {
        AbstractDirectMapping clone = (AbstractDirectMapping)super.clone();
        clone.setField(this.getField().clone());
        return clone;
    }

    @Override
    public ChangeRecord compareForChange(Object clone, Object backUp, ObjectChangeSet owner, AbstractSession session) {
        if (owner.isNew()) {
            return this.internalBuildChangeRecord(this.getAttributeValueFromObject(clone), null, owner);
        }
        if (!this.compareObjects(backUp, clone, session)) {
            Object oldValue = null;
            if (backUp != null && clone != backUp) {
                oldValue = this.getAttributeValueFromObject(backUp);
            }
            return this.internalBuildChangeRecord(this.getAttributeValueFromObject(clone), oldValue, owner);
        }
        return null;
    }

    @Override
    public void deleteMapKey(Object objectDeleted, AbstractSession session) {
    }

    @Override
    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        Object firstValue = this.getAttributeValueFromObject(firstObject);
        Object secondValue = this.getAttributeValueFromObject(secondObject);
        return this.compareObjectValues(firstValue, secondValue, session);
    }

    protected boolean compareObjectValues(Object firstValue, Object secondValue, AbstractSession session) {
        if (firstValue == secondValue) {
            return true;
        }
        if (firstValue != null && secondValue != null && firstValue.equals(secondValue)) {
            return true;
        }
        if ((firstValue = this.getFieldValue(firstValue, session)) == (secondValue = this.getFieldValue(secondValue, session))) {
            return true;
        }
        if (firstValue == null || secondValue == null) {
            return false;
        }
        if (firstValue.equals(secondValue)) {
            return true;
        }
        return Helper.comparePotentialArrays(firstValue, secondValue);
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        if (this.getAttributeClassificationName() != null) {
            Class attributeClass;
            block13: {
                attributeClass = null;
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            attributeClass = AccessController.doPrivileged(new PrivilegedClassForName(this.getAttributeClassificationName(), true, classLoader));
                            break block13;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.getAttributeClassificationName(), exception.getException());
                        }
                    }
                    attributeClass = PrivilegedAccessHelper.getClassForName(this.getAttributeClassificationName(), true, classLoader);
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.getAttributeClassificationName(), exc);
                }
            }
            this.setAttributeClassification(attributeClass);
        }
        if (this.fieldClassificationClassName != null) {
            Class fieldClassification;
            block14: {
                fieldClassification = null;
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            fieldClassification = AccessController.doPrivileged(new PrivilegedClassForName(this.fieldClassificationClassName, true, classLoader));
                            break block14;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.fieldClassificationClassName, exception.getException());
                        }
                    }
                    fieldClassification = PrivilegedAccessHelper.getClassForName(this.fieldClassificationClassName, true, classLoader);
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.fieldClassificationClassName, exc);
                }
                catch (Exception e) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.fieldClassificationClassName, e);
                }
            }
            this.setFieldClassification(fieldClassification);
        }
    }

    @Override
    public Object createSerializableMapKeyInfo(Object key, AbstractSession session) {
        return key;
    }

    @Override
    public List<Object> createMapComponentsFromSerializableKeyInfo(Object[] keyInfo, AbstractSession session) {
        return Arrays.asList(keyInfo);
    }

    @Override
    public Object createStubbedMapComponentFromSerializableKeyInfo(Object keyInfo, AbstractSession session) {
        return keyInfo;
    }

    @Override
    public Object createMapComponentFromRow(AbstractRecord dbRow, ObjectBuildingQuery query, CacheKey parentCacheKey, AbstractSession session, boolean isTargetProtected) {
        Object key = dbRow.get(this.getField());
        key = this.getObjectValue(key, session);
        return key;
    }

    @Override
    public Object createMapComponentFromJoinedRow(AbstractRecord dbRow, JoinedAttributeManager joinManger, ObjectBuildingQuery query, CacheKey parentCacheKey, AbstractSession session, boolean isTargetProtected) {
        return this.createMapComponentFromRow(dbRow, query, parentCacheKey, session, isTargetProtected);
    }

    @Override
    public QueryKey createQueryKeyForMapKey() {
        DirectQueryKey queryKey = new DirectQueryKey();
        queryKey.setField(this.getField());
        return queryKey;
    }

    @Override
    public Map extractIdentityFieldsForQuery(Object object, AbstractSession session) {
        HashMap<DatabaseField, Object> fields = new HashMap<DatabaseField, Object>();
        Object key = object;
        if (this.getConverter() != null) {
            key = this.getConverter().convertObjectValueToDataValue(key, session);
        }
        fields.put(this.getField(), key);
        return fields;
    }

    @Override
    public List<DatabaseTable> getAdditionalTablesForJoinQuery() {
        ArrayList<DatabaseTable> tables = new ArrayList<DatabaseTable>(1);
        tables.add(this.getField().getTable());
        return tables;
    }

    @Override
    public Class getAttributeClassification() {
        return this.attributeClassification;
    }

    public String getAttributeClassificationName() {
        if (this.attributeClassificationName == null && this.attributeClassification != null) {
            this.attributeClassificationName = this.attributeClassification.getName();
        }
        return this.attributeClassificationName;
    }

    @Override
    public Object getObjectValue(Object fieldValue, Session session) {
        Object attributeValue = fieldValue;
        if (fieldValue == null && this.nullValue != null) {
            return this.nullValue;
        }
        if (this.converter != null) {
            attributeValue = this.converter.convertDataValueToObjectValue(attributeValue, session);
        } else if (!(attributeValue != null && attributeValue.getClass() == this.attributeObjectClassification || attributeValue == null && this.bypassDefaultNullValueCheck)) {
            try {
                attributeValue = session.getDatasourcePlatform().convertObject(attributeValue, this.attributeClassification);
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
            }
        }
        if (attributeValue == null) {
            attributeValue = this.nullValue;
        }
        return attributeValue;
    }

    public Object getObjectValueWithoutClassCheck(Object fieldValue, Session session) {
        if (fieldValue == null && this.nullValue != null) {
            return this.nullValue;
        }
        Object attributeValue = fieldValue;
        if (this.converter != null) {
            attributeValue = this.converter.convertDataValueToObjectValue(attributeValue, session);
        } else if (attributeValue == null && !this.bypassDefaultNullValueCheck) {
            try {
                attributeValue = session.getDatasourcePlatform().convertObject(null, this.attributeClassification);
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
            }
        }
        if (attributeValue == null) {
            attributeValue = this.nullValue;
        }
        return attributeValue;
    }

    @Override
    public boolean isAbstractDirectMapping() {
        return true;
    }

    @Override
    public ClassDescriptor getReferenceDescriptor() {
        return null;
    }

    @Override
    public Class getFieldClassification(DatabaseField fieldToClassify) {
        if (fieldToClassify.type != null) {
            return fieldToClassify.type;
        }
        if (this.hasConverter()) {
            return null;
        }
        return Helper.getObjectClass(this.attributeClassification);
    }

    public Class getFieldClassification() {
        if (this.getField() == null) {
            return null;
        }
        return this.getField().getType();
    }

    public void setFieldClassification(Class fieldType) {
        this.getField().setType(fieldType);
    }

    public void setFieldClassificationClassName(String className) {
        this.fieldClassificationClassName = className;
    }

    public void setFieldType(int jdbcType) {
        this.getField().setSqlType(jdbcType);
    }

    public String getFieldName() {
        return this.getField().getQualifiedName();
    }

    @Override
    public Object getFieldValue(Object attributeValue, AbstractSession session) {
        Class fieldClassification;
        Object fieldValue = attributeValue;
        if (this.nullValue != null && this.nullValue.equals(fieldValue)) {
            return null;
        }
        if (this.converter != null) {
            fieldValue = this.converter.convertObjectValueToDataValue(fieldValue, session);
        }
        if ((fieldClassification = this.field.type) == null) {
            fieldClassification = this.getFieldClassification(this.field);
        }
        if (!(fieldValue != null && fieldClassification == fieldValue.getClass() || fieldValue == null && this.bypassDefaultNullValueCheck)) {
            try {
                fieldValue = session.getPlatform(this.descriptor.getJavaClass()).convertObject(fieldValue, fieldClassification);
            }
            catch (ConversionException exception) {
                throw ConversionException.couldNotBeConverted((Object)this, this.descriptor, exception);
            }
        }
        return fieldValue;
    }

    @Override
    public Map<DatabaseField, DatabaseField> getForeignKeyFieldsForMapKey() {
        return null;
    }

    @Override
    public List<DatabaseField> getIdentityFieldsForMapKey() {
        return this.getAllFieldsForMapKey();
    }

    @Override
    public List<DatabaseField> getAllFieldsForMapKey() {
        Vector<DatabaseField> fields = new Vector<DatabaseField>(1);
        fields.add(this.getField());
        return fields;
    }

    @Override
    public ObjectLevelReadQuery getNestedJoinQuery(JoinedAttributeManager joinManager, ObjectLevelReadQuery query, AbstractSession session) {
        return null;
    }

    public Object getNullValue() {
        return this.nullValue;
    }

    @Override
    public Expression getAdditionalSelectionCriteriaForMapKey() {
        return null;
    }

    @Override
    public Object getTargetVersionOfSourceObject(Object object, Object parent, MergeManager mergeManager, AbstractSession targetSession) {
        return object;
    }

    @Override
    public Class getMapKeyTargetType() {
        Class aClass = this.getAttributeAccessor().getAttributeClass();
        if (aClass == null) {
            aClass = this.getAttributeClassification();
        }
        if (aClass == null) {
            aClass = this.getField().getType();
        }
        return aClass;
    }

    @Override
    public Integer getWeight() {
        return this.weight;
    }

    @Override
    public void remoteInitialization(DistributedSession session) {
        if (!this.isRemotelyInitialized()) {
            super.remoteInitialization(session);
            if (this.attributeClassification == null) {
                this.attributeClassification = this.getAttributeAccessor().getAttributeClass();
            }
            this.attributeObjectClassification = Helper.getObjectClass(this.attributeClassification);
        }
    }

    @Override
    public void preInitialize(AbstractSession session) throws DescriptorException {
        super.preInitialize(session);
        if (this.attributeClassification == null) {
            this.attributeClassification = this.getAttributeAccessor().getAttributeClass();
        }
        this.attributeObjectClassification = Helper.getObjectClass(this.attributeClassification);
        if (this.isMutable == null) {
            if (this.hasConverter()) {
                this.setIsMutable(this.getConverter().isMutable());
            } else {
                this.setIsMutable(false);
            }
            if (this.getAttributeClassification() != null && (ClassConstants.UTILDATE.isAssignableFrom(this.getAttributeClassification()) || ClassConstants.CALENDAR.isAssignableFrom(this.getAttributeClassification()))) {
                this.setIsMutable(session.getProject().getDefaultTemporalMutable());
            }
        }
        Map nullValues = session.getPlatform(this.descriptor.getJavaClass()).getConversionManager().getDefaultNullValues();
        this.bypassDefaultNullValueCheck = !this.attributeClassification.isPrimitive() && (nullValues == null || !nullValues.containsKey(this.attributeClassification));
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (this.getField() == null) {
            session.getIntegrityChecker().handleError(DescriptorException.fieldNameNotSetInMapping(this));
        }
        this.isInsertable = this.getField().isInsertable();
        this.isUpdatable = this.getField().isUpdatable();
        if (this.keyTableForMapKey == null) {
            this.setField(this.getDescriptor().buildField(this.getField()));
        } else {
            this.setField(this.getDescriptor().buildField(this.getField(), this.keyTableForMapKey));
        }
        this.setFields(this.collectFields());
        if (this.hasConverter()) {
            this.getConverter().initialize(this, session);
        }
        if (this.getField().getSqlType() == 2002) {
            this.getDescriptor().setIsNativeConnectionRequired(true);
        }
    }

    public ChangeRecord internalBuildChangeRecord(Object newValue, Object oldValue, ObjectChangeSet owner) {
        DirectToFieldChangeRecord changeRecord = new DirectToFieldChangeRecord(owner);
        changeRecord.setAttribute(this.getAttributeName());
        changeRecord.setMapping(this);
        changeRecord.setNewValue(newValue);
        changeRecord.setOldValue(oldValue);
        return changeRecord;
    }

    @Override
    public boolean isDirectToFieldMapping() {
        return true;
    }

    @Override
    public void iterateOnMapKey(DescriptorIterator iterator, Object element) {
        if (iterator.shouldIterateOnPrimitives()) {
            iterator.iteratePrimitiveForMapping(element, this);
        }
    }

    @Override
    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        this.setAttributeValueInObject(target, this.buildCloneValue(((DirectToFieldChangeRecord)changeRecord).getNewValue(), mergeManager.getSession()));
    }

    @Override
    public void mergeIntoObject(Object target, boolean isTargetUnInitialized, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        if ((mergeManager.shouldMergeCloneIntoWorkingCopy() || mergeManager.shouldMergeCloneWithReferencesIntoWorkingCopy()) && !mergeManager.isForRefresh() && this.descriptor.getObjectChangePolicy().isObjectChangeTrackingPolicy()) {
            Object targetAttribute;
            Object attributeValue = this.getAttributeValueFromObject(source);
            if (!this.compareObjectValues(attributeValue, targetAttribute = this.getAttributeValueFromObject(target), mergeManager.getSession())) {
                this.setAttributeValueInObject(target, this.buildCloneValue(attributeValue, mergeManager.getSession()));
                this.descriptor.getObjectChangePolicy().raiseInternalPropertyChangeEvent(target, this.getAttributeName(), targetAttribute, attributeValue);
            }
        } else {
            this.setAttributeValueInObject(target, this.buildCloneValue(this.getAttributeValueFromObject(source), mergeManager.getSession()));
        }
    }

    @Override
    public void preinitializeMapKey(DatabaseTable table) throws DescriptorException {
        this.keyTableForMapKey = table;
    }

    @Override
    public void postInitializeMapKey(MappedKeyMapContainerPolicy policy) {
        if (this.getField().getType() == null) {
            this.getField().setType(this.getFieldClassification(this.getField()));
        }
    }

    @Override
    public boolean requiresDataModificationEventsForMapKey() {
        return !this.isReadOnly() && this.isUpdatable();
    }

    public void setAttributeClassification(Class attributeClassification) {
        this.attributeClassification = attributeClassification;
    }

    public void setAttributeClassificationName(String attributeClassificationName) {
        this.attributeClassificationName = attributeClassificationName;
    }

    public void setNullValue(Object nullValue) {
        this.nullValue = nullValue;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.getAttributeName() + "-->" + this.getField() + "]";
    }

    @Override
    public void updateChangeRecord(Object clone, Object newValue, Object oldValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) {
        DirectToFieldChangeRecord changeRecord = (DirectToFieldChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (changeRecord == null) {
            objectChangeSet.addChange(this.internalBuildChangeRecord(newValue, oldValue, objectChangeSet));
        } else {
            changeRecord.setNewValue(newValue);
        }
    }

    @Override
    public boolean isChangeTrackingSupported(Project project) {
        return !this.isMutable();
    }

    @Override
    public boolean isCloningRequired() {
        return this.isMutable() || this.getDescriptor().getCopyPolicy().buildsNewInstance();
    }

    @Override
    public Object unwrapKey(Object key, AbstractSession session) {
        return key;
    }

    @Override
    public void validateBeforeInitialization(AbstractSession session) throws DescriptorException {
        if (this.getFieldName() == null || this.getFieldName().length() == 0) {
            session.getIntegrityChecker().handleError(DescriptorException.noFieldNameForMapping(this));
        }
    }

    @Override
    public Object wrapKey(Object key, AbstractSession session) {
        return key;
    }

    @Override
    public Object valueFromObject(Object object, DatabaseField field, AbstractSession session) throws DescriptorException {
        return this.getFieldValue(this.getAttributeValueFromObject(object), session);
    }

    @Override
    public void buildShallowOriginalFromRow(AbstractRecord databaseRow, Object original, JoinedAttributeManager joinManager, ObjectBuildingQuery query, AbstractSession executionSession) {
        this.readFromRowIntoObject(databaseRow, null, original, null, query, executionSession, true);
    }

    @Override
    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery query, CacheKey cacheKey, AbstractSession executionSession, boolean isTargetProtected, Boolean[] wasCacheUsed) {
        Object cached;
        if (this.descriptor.getCachePolicy().isProtectedIsolation() && this.isCacheable && isTargetProtected && cacheKey != null && (cached = cacheKey.getObject()) != null) {
            if (wasCacheUsed != null) {
                wasCacheUsed[0] = Boolean.TRUE;
            }
            Object attributeValue = this.getAttributeValueFromObject(cached);
            return this.buildCloneValue(attributeValue, executionSession);
        }
        if (row.hasSopObject()) {
            return this.getAttributeValueFromObject(row.getSopObject());
        }
        Object fieldValue = row.get(this.getField());
        Object attributeValue = this.getObjectValue(fieldValue, executionSession);
        return attributeValue;
    }

    @Override
    public Object valueFromResultSet(ResultSet resultSet, ObjectBuildingQuery query, AbstractSession session, DatabaseAccessor accessor, ResultSetMetaData metaData, int columnNumber, DatabasePlatform platform) throws SQLException {
        if (this.attributeObjectClassification == ClassConstants.STRING) {
            String val = platform.shouldUseGetSetNString() ? resultSet.getNString(columnNumber) : resultSet.getString(columnNumber);
            return this.getObjectValueWithoutClassCheck(val, session);
        }
        if (this.attributeObjectClassification == ClassConstants.LONG) {
            return this.getObjectValueWithoutClassCheck(resultSet.getLong(columnNumber), session);
        }
        if (this.attributeObjectClassification == ClassConstants.INTEGER) {
            return this.getObjectValueWithoutClassCheck(resultSet.getInt(columnNumber), session);
        }
        Object fieldValue = accessor.getObject(resultSet, this.getField(), metaData, columnNumber, platform, true, session);
        return this.getObjectValue(fieldValue, session);
    }

    @Override
    protected abstract void writeValueIntoRow(AbstractRecord var1, DatabaseField var2, Object var3);

    @Override
    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) {
        if (this.isReadOnly() || writeType.equals((Object)DatabaseMapping.WriteType.INSERT) && !this.isInsertable() || writeType.equals((Object)DatabaseMapping.WriteType.UPDATE) && !this.isUpdatable()) {
            return;
        }
        if (this.isPrimaryKeyMapping && !changeRecord.getOwner().isNew()) {
            throw ValidationException.primaryKeyUpdateDisallowed(changeRecord.getOwner().getClassName(), changeRecord.getAttribute());
        }
        Object attributeValue = ((DirectToFieldChangeRecord)changeRecord).getNewValue();
        Object fieldValue = this.getFieldValue(attributeValue, session);
        if (fieldValue == null) {
            row.setNullValueInFields(true);
        }
        row.add(this.getField(), fieldValue);
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) {
        if (this.isReadOnly() || writeType.equals((Object)DatabaseMapping.WriteType.INSERT) && !this.isInsertable() || writeType.equals((Object)DatabaseMapping.WriteType.UPDATE) && !this.isUpdatable()) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(object);
        Object fieldValue = this.getFieldValue(attributeValue, session);
        if (fieldValue == null) {
            row.setNullValueInFields(true);
        }
        this.writeValueIntoRow(row, this.getField(), fieldValue);
    }

    @Override
    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery query, AbstractRecord databaseRow) {
        if (query.getSession().isUnitOfWork() && this.compareObjects(query.getBackupClone(), query.getObject(), query.getSession())) {
            return;
        }
        super.writeFromObjectIntoRowForUpdate(query, databaseRow);
    }

    @Override
    public void writeInsertFieldsIntoRow(AbstractRecord databaseRow, AbstractSession session) {
        if (this.isInsertable() && !this.isReadOnly()) {
            databaseRow.add(this.getField(), null);
        }
    }

    @Override
    public void writeUpdateFieldsIntoRow(AbstractRecord databaseRow, AbstractSession session) {
        if (this.isUpdatable() && !this.isReadOnly()) {
            databaseRow.add(this.getField(), null);
        }
    }
}

