/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.plsql;

import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.helper.ComplexDatabaseType;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLCollection;

public class PLSQLargument
implements Cloneable {
    public String name;
    public int direction = DatasourceCall.IN;
    public int originalIndex = Integer.MIN_VALUE;
    public int inIndex = Integer.MIN_VALUE;
    public int outIndex = Integer.MIN_VALUE;
    public DatabaseType databaseType;
    public int length = 255;
    public int precision = Integer.MIN_VALUE;
    public int scale = Integer.MIN_VALUE;
    public boolean cursorOutput = false;

    public PLSQLargument() {
    }

    public PLSQLargument(String name, int originalIndex, int direction, DatabaseType databaseType) {
        this();
        this.name = name;
        this.databaseType = databaseType;
        this.originalIndex = originalIndex;
        this.direction = direction;
    }

    public PLSQLargument(String name, int originalIndex, int direction, DatabaseType databaseType, int length) {
        this(name, originalIndex, direction, databaseType);
        this.length = length;
    }

    public PLSQLargument(String name, int originalIndex, int direction, DatabaseType databaseType, int precision, int scale) {
        this(name, originalIndex, direction, databaseType);
        this.precision = precision;
        this.scale = scale;
    }

    protected PLSQLargument clone() {
        try {
            return (PLSQLargument)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public void useNamedCursorOutputAsResultSet() {
        this.cursorOutput = true;
    }

    public void setIsNonAssociativeCollection(boolean isNonAsscociative) {
        if (this.databaseType != null && this.databaseType.isComplexDatabaseType() && ((ComplexDatabaseType)this.databaseType).isCollection()) {
            ((PLSQLCollection)this.databaseType).setIsNestedTable(isNonAsscociative);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append('{');
        if (this.direction == DatasourceCall.IN) {
            sb.append("IN");
        } else if (this.direction == DatasourceCall.INOUT) {
            sb.append("IN");
        } else if (this.direction == DatasourceCall.OUT) {
            sb.append("OUT");
        } else if (this.direction == DatasourceCall.OUT_CURSOR) {
            sb.append("OUT CURSOR");
        }
        sb.append(',');
        sb.append(this.originalIndex);
        sb.append(',');
        if (this.inIndex != Integer.MIN_VALUE) {
            sb.append(this.inIndex);
        }
        sb.append(',');
        if (this.outIndex != Integer.MIN_VALUE) {
            sb.append(this.outIndex);
        }
        sb.append('}');
        return sb.toString();
    }
}

