/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.descriptors.changetracking;

import java.beans.PropertyChangeEvent;
import java.lang.ref.WeakReference;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.changetracking.ObjectChangeListener;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;

public class AttributeChangeListener
extends ObjectChangeListener {
    protected transient WeakReference<ClassDescriptor> descriptor;
    protected transient WeakReference<UnitOfWorkImpl> uow;
    protected ObjectChangeSet objectChangeSet;
    protected Object owner;

    public AttributeChangeListener(ClassDescriptor descriptor, UnitOfWorkImpl uow, Object owner) {
        this.descriptor = new WeakReference<ClassDescriptor>(descriptor);
        this.uow = new WeakReference<UnitOfWorkImpl>(uow);
        this.owner = owner;
    }

    public ObjectChangeSet getObjectChangeSet() {
        return this.objectChangeSet;
    }

    public void setObjectChangeSet(ObjectChangeSet changeSet) {
        this.objectChangeSet = changeSet;
    }

    public ClassDescriptor getDescriptor() {
        return (ClassDescriptor)this.descriptor.get();
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = new WeakReference<ClassDescriptor>(descriptor);
    }

    public UnitOfWorkImpl getUnitOfWork() {
        return (UnitOfWorkImpl)this.uow.get();
    }

    public void setUnitOfWork(UnitOfWorkImpl uow) {
        this.uow = new WeakReference<UnitOfWorkImpl>(uow);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.ignoreEvents) {
            return;
        }
        this.internalPropertyChange(evt);
    }

    @Override
    public void internalPropertyChange(PropertyChangeEvent evt) {
        if (evt.getNewValue() == evt.getOldValue()) {
            return;
        }
        ClassDescriptor descriptor = this.getDescriptor();
        DatabaseMapping mapping = null;
        if (descriptor != null) {
            mapping = descriptor.getObjectBuilder().getMappingForAttributeName(evt.getPropertyName());
            if (mapping == null) {
                throw ValidationException.wrongPropertyNameInChangeEvent(this.owner.getClass(), evt.getPropertyName());
            }
            if ((mapping instanceof AbstractDirectMapping || mapping instanceof AbstractTransformationMapping) && (evt.getNewValue() == null && evt.getOldValue() == null || evt.getNewValue() != null && evt.getNewValue().equals(evt.getOldValue()))) {
                return;
            }
        }
        super.internalPropertyChange(evt);
        UnitOfWorkImpl uow = this.getUnitOfWork();
        if (uow != null) {
            if (uow.getUnitOfWorkChangeSet() == null) {
                uow.setUnitOfWorkChangeSet(new UnitOfWorkChangeSet(uow));
            }
            if (this.objectChangeSet == null) {
                uow.addToChangeTrackedHardList(this.owner);
                this.objectChangeSet = this.getDescriptor().getObjectBuilder().createObjectChangeSet(this.owner, (UnitOfWorkChangeSet)uow.getUnitOfWorkChangeSet(), false, uow);
            }
        }
        if (mapping != null) {
            if (evt.getClass().equals(ClassConstants.PropertyChangeEvent_Class)) {
                mapping.updateChangeRecord(evt.getSource(), evt.getNewValue(), evt.getOldValue(), this.objectChangeSet, this.getUnitOfWork());
            } else if (evt.getClass().equals(ClassConstants.CollectionChangeEvent_Class) || evt.getClass().equals(ClassConstants.MapChangeEvent_Class)) {
                mapping.updateCollectionChangeRecord((CollectionChangeEvent)evt, this.objectChangeSet, this.getUnitOfWork());
            } else {
                throw ValidationException.wrongChangeEvent(evt.getClass());
            }
        }
    }

    @Override
    public void clearChanges(boolean forRefresh) {
        super.clearChanges(forRefresh);
        if (forRefresh && this.objectChangeSet != null) {
            this.objectChangeSet.clear(true);
        }
        this.objectChangeSet = null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getObjectChangeSet() + ")";
    }
}

