/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record.deferred;

import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.Unmarshaller;
import org.eclipse.persistence.internal.oxm.record.UnmappedContentHandlerWrapper;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.internal.oxm.record.deferred.DeferredContentHandler;
import org.eclipse.persistence.internal.oxm.unmapped.UnmappedContentHandler;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.xml.sax.SAXException;

public class AnyMappingContentHandler
extends DeferredContentHandler {
    private boolean usesXMLRoot;

    public AnyMappingContentHandler(UnmarshalRecord parentRecord, boolean usesXMLRoot) {
        super(parentRecord);
        this.usesXMLRoot = usesXMLRoot;
    }

    @Override
    protected void processEmptyElement() throws SAXException {
        this.processSimpleElement();
    }

    @Override
    protected void processSimpleElement() throws SAXException {
        if (this.usesXMLRoot) {
            this.getEvents().remove(0);
            this.executeEvents(this.getParent());
        } else {
            this.processComplexElement();
        }
    }

    @Override
    protected void processComplexElement() throws SAXException {
        UnmappedContentHandler unmappedContentHandler;
        this.getParent().unmappedContent();
        Class unmappedContentHandlerClass = ((Unmarshaller)this.getParent().getUnmarshaller()).getUnmappedContentHandlerClass();
        if (null == unmappedContentHandlerClass) {
            unmappedContentHandler = UnmarshalRecord.DEFAULT_UNMAPPED_CONTENT_HANDLER;
        } else {
            try {
                PrivilegedNewInstanceFromClass privilegedNewInstanceFromClass = new PrivilegedNewInstanceFromClass(unmappedContentHandlerClass);
                unmappedContentHandler = (UnmappedContentHandler)privilegedNewInstanceFromClass.run();
            }
            catch (ClassCastException e) {
                throw XMLMarshalException.unmappedContentHandlerDoesntImplement(e, unmappedContentHandlerClass.getName());
            }
            catch (IllegalAccessException e) {
                throw XMLMarshalException.errorInstantiatingUnmappedContentHandler(e, unmappedContentHandlerClass.getName());
            }
            catch (InstantiationException e) {
                throw XMLMarshalException.errorInstantiatingUnmappedContentHandler(e, unmappedContentHandlerClass.getName());
            }
        }
        UnmappedContentHandlerWrapper unmappedContentHandlerWrapper = new UnmappedContentHandlerWrapper(this.getParent(), unmappedContentHandler);
        this.executeEvents(unmappedContentHandlerWrapper);
    }
}

